/*************************************************************************************************/
/*!
   	@file		TextAlignCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"TextAlignCfgView" class 
**************************************************************************************************/
class TextAlignCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<RadioGroupView>				m_halign;
	instance<RadioGroupView>				m_valign;

	rControlMsg			m_msg;
	int					m_id;

	const int			m_item_h;

// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_halign->SetRadioNum( 3 );
	m_halign->SetString( 0 , L"left" );
	m_halign->SetString( 1 , L"center" );
	m_halign->SetString( 2 , L"right" );
	m_halign->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Size().width , m_item_h * 3 ) )
			);
	m_halign->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	
	m_valign->SetRadioNum( 3 );
	m_valign->SetString( 0 , L"top" );
	m_valign->SetString( 1 , L"center" );
	m_valign->SetString( 2 , L"bottom" );
	m_valign->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_item_h * 3 + 5 ) , isize( p->m_rect.Size().width , m_item_h * 3 ) )
			);
	m_valign->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
}
// public functions
public:
//=================================================================================================
TextAlignCfgView() : 
		m_item_h( 15 ) , 
		m_id( 0 )
{
}
//=================================================================================================
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
TextAlignHorz_gp GetTextAlignHorz()const
{
	int		s = m_halign->GetSelect();
	if( s == 0 )
		return Left_TextAlignHorz_gp;
	else if( s == 1 )
		return Center_TextAlignHorz_gp;
	else
		return Right_TextAlignHorz_gp;
}
//=================================================================================================
TextAlignVert_gp GetTextAlignVert()const
{
	int		s = m_valign->GetSelect();
	if( s == 0 )
		return Top_TextAlignVert_gp;
	else if( s == 1 )
		return Center_TextAlignVert_gp;
	else
		return Bottom_TextAlignVert_gp;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
