/*************************************************************************************************/
/*!
   	@file		SourceGenTextureWeight16CfgView.h
	@author 	Fanzo
 	@date 		2008/6/11
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"SourceGenTextureWeight16CfgView" class 
**************************************************************************************************/
class SourceGenTextureWeight16CfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<TextureCfgView>					m_texture;
	instance<WrapTypeCfgView>				m_wraptype;
	instance<NormTableBicubicCfgView>		m_param;

	instance<PaintTexture>					m_source_paint;
	instance<TextureImageWeight16>			m_source_texture;
	
	rControlMsg									m_msg;
	int											m_id;
	
	const int									m_info_w;
	const int									m_sh;
	
	// edit data
	fvector2			m_pos;
	fvector2			m_zoom;
	float				m_rotate;

	const rgba			m_ec;
	const float			m_coor_l;
	const int			m_handle_r;
	
// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_texture->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( m_info_w , m_sh ) )
			);
	m_texture->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );

	m_wraptype->SetAlign( Horz_RadioAlign );
	m_wraptype->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 ,  m_sh ) , isize( m_info_w , m_sh ) )
			);
	m_wraptype->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	m_param->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( m_info_w , 0 ) , isize( p->m_rect.Size().width - m_info_w , p->m_rect.Size().height ) )
			);
	m_param->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
SourceGenTextureWeight16CfgView() : 
		m_id( 0 ) , 
		m_info_w( 150 ) , 
		m_pos( 0.0f , 0.0f ) , 
		m_zoom( 1.0f , 1.0f ) , 
		m_rotate( 0.0f ) , 
		m_coor_l( 50.0f ) , 
		m_ec( 121 , 121 , 40 ) , 
		m_handle_r( 5 ) , 
		m_sh( 15 )
{
	m_source_paint->SetTexture( (iTexture)m_source_texture );
}		
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	add texture
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool AddTexture
		(
		const wstring&	path
		)
{
	return m_texture->AddTexture( path );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iTexture GetSourceTexture
		(
		const faffine&	aff
		)
{
	m_source_texture->SetWraptype( m_wraptype->GetValue() );
	m_source_texture->SetTexture( (iSurfaceSource)m_texture->GetValue() );
	m_source_texture->SetInterpolateTable( (iNormTable_f)m_param->GetValue1_f() , (iNormTable_f)m_param->GetValue2_f() );
	isize		size	= m_source_texture->TextureSize();
	faffine		taff	= 
			faffine::GetScale( 1.0f / size.width , 1.0f / size.height ) 
			* aff * faffine::GetMove( m_pos ) * faffine::GetRotate( m_rotate ) * faffine::GetScale( m_zoom.x , m_zoom.y ) 
			* faffine::GetScale( (float)size.width , (float)size.height );
	m_source_texture->SetTransform( taff.Inverse() );
	return (iTexture)m_source_texture;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iPaint GetSourcePaint
		(
		const DPI&		dpi , 
		const faffine&	aff
		)
{
	m_source_texture->SetWraptype( m_wraptype->GetValue() );
	m_source_texture->SetTexture( (iSurfaceSource)m_texture->GetValue() );
	m_source_texture->SetInterpolateTable( (iNormTable_f)m_param->GetValue1_f() , (iNormTable_f)m_param->GetValue2_f() );
	m_source_texture->SetTransform( faffine() );
	
	faffine		taff	= aff * faffine::GetMove( m_pos ) * faffine::GetRotate( m_rotate ) * faffine::GetScale( m_zoom.x , m_zoom.y );
	m_source_paint->SetTransform( taff.Inverse() );
	return (iPaint)m_source_paint;
}
//=================================================================================================
int GetEditPointNum()
{
	return 4;
}
//=================================================================================================
fvector2 GetEditPoint
		(
		int				off
		)
{
	faffine		aff	= faffine::GetMove( m_pos ) * faffine::GetRotate( m_rotate ) * faffine::GetScale( m_zoom.x , m_zoom.y );
	if( off == 0 )
		return aff.Transform( fvector2( 0.0f , 0.0f ) );
	else if( off == 1 )
		return aff.Transform( fvector2( m_coor_l , 0.0f ) );
	else if( off == 2 )
		return aff.Transform( fvector2( 0.0f , m_coor_l ) );
	else
	{
		faffine		taff	= faffine::GetMove( m_pos ) * faffine::GetRotate( m_rotate );
		return taff.Transform( fvector2( m_coor_l , m_coor_l ) );
	}
}
//=================================================================================================
void SetEditPoint
		(
		int				off , 
		fvector2		pnt
		)
{
	if( off == 0 )
		m_pos = pnt;
	else if( off == 1 )
	{
		fvector2	v = pnt - m_pos;
		fvector2	b = faffine::GetRotate( m_rotate ).Transform( fvector2( 1.0f , 0.0f ) ).GetUnit();
		m_zoom.x	= v.Inner( b ) / m_coor_l;
	}
	else if( off == 2 )
	{
		fvector2	v = pnt - m_pos;
		fvector2	b = faffine::GetRotate( m_rotate ).Transform( fvector2( 0.0f , 1.0f ) ).GetUnit();
		m_zoom.y	= v.Inner( b ) / m_coor_l;
	}
	else if( off == 3 )
	{
		fvector2	v = pnt - m_pos;
		m_rotate	= v.GetAngle_f( fvector2( 1.0f , 1.0f ) );
	}
}	
//=================================================================================================
bool SearchEditPoint
		(
		const fvector2&		pnt , 
		int*				pntoff
		)
{
	int		off , num = GetEditPointNum();
	for( off = 0 ; off < num ; off++ )
	{
		fvector2	p = GetEditPoint( off );
		frect		r( p.x - m_handle_r , p.y - m_handle_r , p.x + m_handle_r , p.y + m_handle_r );
		if( true == r.IsInside( pnt ) )
		{
			*pntoff	= off;
			return true;
		}
	}
	return false;
}
//=================================================================================================
void DrawEditHandle
		(
		const faffine&	aff , 
		iSurfaceDest&	surface
		)
{
	DrawLine( surface , aff.Transform( GetEditPoint( 0 ) ) , aff.Transform( GetEditPoint( 1 ) ) , 2.0f , m_ec );
	DrawLine( surface , aff.Transform( GetEditPoint( 0 ) ) , aff.Transform( GetEditPoint( 2 ) ) , 2.0f , m_ec );
	int		off , num = GetEditPointNum();
	for( off = 0 ; off < num ; off++ )
		DrawCircle( surface , aff.Transform( GetEditPoint( off ) ) , ( float )m_handle_r , m_ec );
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace SourceGenTextureWeight16CfgView;		

#pragma pack( pop )			//release align
