/*************************************************************************************************/
/*!
   	@file		SeparateView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"SeparateView" class 
**************************************************************************************************/
class SeparateView : public View
{
	msg_view_map_begin()
	msg_view_hook( Update , OnUpdate )
	msg_view_map_end( View )

// variable member
private:
	wstring					m_string;
	instance<Font>		m_font;
	const rgba				m_color;
	
// msg functions
protected:
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	irect		r = GetTextRect( m_string , ( iFont )m_font , Center_TextAlign );
	fvector2	pos( ( GetRect().Size().width - r.Size().width ) / 2.0f , GetRect().Size().height / 2.0f );
	DrawText( (iSurfaceDest)p->m_surface , pos , m_string.c_str() , ( iFont )m_font , m_color , Center_TextAlign );

	DrawLine( (iSurfaceDest)p->m_surface , fvector2( 0.0f , pos.y ) , fvector2( pos.x - 5 , pos.y ) , 1.0f , m_color );
	DrawLine( (iSurfaceDest)p->m_surface , fvector2( pos.x + r.Width() + 5 , pos.y ) , fvector2( (float)GetRect().Width() , pos.y ) , 1.0f , m_color );
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
SeparateView() : m_color( 65 , 133 , 215 )
{
	cb_verify( true == m_font->Create( fsize( 0.0f , 10.0f ) , L"Tahoma" , Roman_FontCharsetType , 400 , false ) );
}
//=================================================================================================
//!	set string
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetString
		(
		const wstring&		str
		)
{
	m_string	= str;
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace SeparateView;		

#pragma pack( pop )			//release align
