/*************************************************************************************************/
/*!
   	@file		PathOperatorCfgView.h
	@author 	Fanzo
 	@date 		2008/5/30
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"
#include	"RadioGroupView.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"PathOperatorCfgView" class 
**************************************************************************************************/
class PathOperatorCfgView : public RadioGroupView
{
// variable member
private:
	
// msg functions
protected:

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PathOperatorCfgView()
{
	SetRadioNum( 4 );
	SetString( 0 , L"and" );
	SetString( 1 , L"or" );
	SetString( 2 , L"xor" );
	SetString( 3 , L"sub" );
	SetColumn( 2 );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
PathOperator GetValue()
{
	int		sel = GetSelect();
	if( sel == 0 )
		return And_PathOperator;
	else if ( sel == 1 )
		return Or_PathOperator;
	else if( sel == 2 )
		return Xor_PathOperator;
	else
		return Sub_PathOperator;
}
};
/**************************************************************************************************
"PolygonOperatorCfgView" class 
**************************************************************************************************/
class PolygonOperatorCfgView : public RadioGroupView
{
// variable member
private:
	
// msg functions
protected:

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PolygonOperatorCfgView()
{
	SetRadioNum( 2 );
	SetString( 0 , L"and" );
	SetString( 1 , L"sub" );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
PolygonOperator GetValue()
{
	int		sel = GetSelect();
	if( sel == 0 )
		return And_PolygonOperator;
	else
		return Sub_PolygonOperator;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace PathOperatorCfgView;		

#pragma pack( pop )			//release align
