/*************************************************************************************************/
/*!
   	@file		NormTableLinearCfgView.h
	@author 	Fanzo
 	@date 		2008/6/4
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"NormTableLinearCfgView" class 
**************************************************************************************************/
class NormTableLinearCfgView : public View
{
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_hook( LDragStart , OnLDragStart )
	msg_view_hook( LDrag , OnLDrag )
	msg_view_hook( LDragEnd , OnLDragEnd )
	msg_view_hook( LDragCancel , OnLDragCancel )
	msg_view_map_end( View )

// variable member
private:
	rControlMsg								m_msg;
	int										m_id;
	
	instance<NormFunctionLinear>			m_norm;
	bool									m_tbl_i16_flag;
	instance<NormTable_i16>				m_tbl_i16;
	bool									m_tbl_f_flag;
	instance<NormTable_f>				m_tbl_f;

	int										m_edit_pnt;
	
	const int								m_handle_r;
	const rgba								m_hc;
	
// private functions
private:
//=================================================================================================
fvector2 ToClient
		(
		const fvector2&		p
		)
{
	isize		size = GetRect().Size();
	return fvector2( p.x * ( size.width - m_handle_r * 2 ) + m_handle_r , size.height - ( p.y * ( size.height - m_handle_r * 2 ) + m_handle_r ) );
}
//=================================================================================================
float ToNormalized
		(
		float	y
		)
{
	isize	size	= GetRect().Size();
	int		l		= ( size.height - m_handle_r * 2 );
	float	v = ( y - m_handle_r ) / ( l == 0 ? 1 : l );
	v	= v < 0.0f ? 0.0f : ( v > 1.0f ? 1.0f : v );
	return 1.0f - v;
}

// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	DrawNormalizedBack( (iSurfaceDest)p->m_surface , GetRect().Size() , m_handle_r - 1 );
	
	isize		size = GetRect().Size();
	// draw handle
	fvector2	v1 = ToClient( fvector2( 0.0f , m_norm->GetNormalizedValue( 0.0f ) ) );
	fvector2	v2 = ToClient( fvector2( 1.0f , m_norm->GetNormalizedValue( 1.0f ) ) );
	DrawLine( (iSurfaceDest)p->m_surface , v1 , v2 , 1.0f , m_hc );
	DrawCircle( (iSurfaceDest)p->m_surface , v1 , ( float )m_handle_r , m_hc );
	DrawCircle( (iSurfaceDest)p->m_surface , v2 , ( float )m_handle_r , m_hc );
}
//=================================================================================================
void OnLDragStart
		(
		LDragStart_ViewPM*	p
		)
{
	isize		size= GetRect().Size();
	{
		fvector2	pnt = ToClient( fvector2( 0.0f , m_norm->GetNormalizedValue( 0.0f ) ) );
		irect		rc( ( int )pnt.x - m_handle_r , ( int )pnt.y - m_handle_r , ( int )pnt.x + m_handle_r , ( int )pnt.y + m_handle_r );
		if( true == rc.IsInside( p->m_pos ) )
			m_edit_pnt = 0;
	}
	{
		fvector2	pnt = ToClient( fvector2( 1.0f , m_norm->GetNormalizedValue( 1.0f ) ) );
		irect		rc( ( int )pnt.x - m_handle_r , ( int )pnt.y - m_handle_r , ( int )pnt.x + m_handle_r , ( int )pnt.y + m_handle_r );
		if( true == rc.IsInside( p->m_pos ) )
			m_edit_pnt = 1;
	}
}
//=================================================================================================
void OnLDrag
		(
		LDrag_ViewPM*	p
		)
{
	if( m_edit_pnt == -1 )
		return;
	if( m_edit_pnt == 0 )
	{
		float	v = ToNormalized( ( float )p->m_pos.y );
		float	a , b;
		m_norm->GetCoefficient( &a , &b );
		m_norm->SetCoefficient( fvector2( 0.0f , v ) , fvector2( 1.0f , a + b ) );
	}
	else if( m_edit_pnt == 1 )
	{
		float	v = ToNormalized( ( float )p->m_pos.y );
		float	a , b;
		m_norm->GetCoefficient( &a , &b );
		m_norm->SetCoefficient( fvector2( 0.0f , b ) , fvector2( 1.0f , v ) );
	}
	m_tbl_i16_flag	= false;
	m_tbl_f_flag	= false;
	
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
//=================================================================================================
void OnLDragEnd
		(
		LDragEnd_ViewPM*	p
		)
{
	m_edit_pnt = -1;
}
//=================================================================================================
void OnLDragCancel
		(
		LDragCancel_ViewPM*	p
		)
{
	m_edit_pnt = -1;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
NormTableLinearCfgView() : 
		m_handle_r( 4 ) , 
		m_id( 0 ) , 
		m_hc( 100 , 100 , 220 ) , 
		m_edit_pnt( -1 ) , 
		m_tbl_i16_flag( false ) , 
		m_tbl_f_flag( false )
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set param
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetCoefficient
		(
		const fvector2&		p1 , 
		const fvector2&		p2
		)
{
	m_norm->SetCoefficient( p1 , p2 );
	m_tbl_i16_flag	= false;
	m_tbl_f_flag	= false;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iNormTable_i16 GetValue_i16()
{
	if( m_tbl_i16_flag == false )
	{
		m_tbl_i16->SetNormFunction( (iNormFunction)m_norm , 0.0f , 1.0f );
		m_tbl_i16_flag	= true;
	}
	return (iNormTable_i16)m_tbl_i16;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iNormTable_f GetValue_f()
{
	if( m_tbl_f_flag == false )
	{
		m_tbl_f->SetNormFunction( (iNormFunction)m_norm , 0.0f , 1.0f );
		m_tbl_f_flag	= true;
	}
	return (iNormTable_f)m_tbl_f;
}

};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace NormTableLinearCfgView;		

#pragma pack( pop )			//release align
