/*************************************************************************************************/
/*!
   	@file		NormTableCfgView.h
	@author 	Fanzo
 	@date 		2008/6/4
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"NormTableCfgView" class 
**************************************************************************************************/
class NormTableCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
protected:
	instance<NormTableLinearCfgView>	m_linear;
	instance<NormTableSinCfgView>	m_sin;
	instance<NormTableSplineCfgView>	m_spline;
private:
	instance<RadioGroupView>			m_select;

	rControlMsg							m_msg;
	int									m_id;
	
	const int							m_sh;

// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	if( id == 0 )
	{
		if( m_select->GetSelect() == 0 )
			m_linear->Show( true );
		else
			m_linear->Show( false );
		if( m_select->GetSelect() == 1 )
			m_sin->Show( true );
		else
			m_sin->Show( false );
		if( m_select->GetSelect() == 2 )
			m_spline->Show( true );
		else
			m_spline->Show( false );
	}
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_select->SetAlign( Horz_RadioAlign );
	m_select->SetRadioNum( 3 );
	m_select->SetString( 0 , L"linear" );
	m_select->SetString( 1 , L"sin" );
	m_select->SetString( 2 , L"spline" );
	m_select->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Size().width , m_sh ) )
			);
	m_select->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );

	m_linear->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_sh ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_sh ) ) , 
			m_select->GetSelect() == 0
			);
	m_linear->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );

	m_sin->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_sh ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_sh ) ) , 
			m_select->GetSelect() == 1
			);
	m_sin->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );

	m_spline->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_sh ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_sh ) ) , 
			m_select->GetSelect() == 2
			);
	m_spline->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
NormTableCfgView() : 
		m_sh( 15 ) , 
		m_id( 0 )
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iNormTable_i16 GetValue_i16()
{
	if( m_select->GetSelect() == 0 )
		return m_linear->GetValue_i16();
	else if( m_select->GetSelect() == 1 )
		return m_sin->GetValue_i16();
	else
		return m_spline->GetValue_i16();
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iNormTable_f GetValue_f()
{
	if( m_select->GetSelect() == 0 )
		return m_linear->GetValue_f();
	else if( m_select->GetSelect() == 1 )
		return m_sin->GetValue_f();
	else
		return m_spline->GetValue_f();
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace NormTableCfgView;		

#pragma pack( pop )			//release align
