/*************************************************************************************************/
/*!
   	@file		GenStrokeCfgView.h
	@author 	Fanzo
 	@date 		2008/5/28
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"GenStrokeCfgView" class 
**************************************************************************************************/
class GenStrokeCfgView : public RadioGroupView
{
// variable member
private:
	instance<OutlineGenStroke>	m_stroke;
	instance<OutlineGenDash>		m_dash;
	
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
GenStrokeCfgView()
{
	SetRadioNum( 2 );
	SetString( 0 , L"stroke" );
	SetString( 1 , L"dash" );
}
//=================================================================================================
//!	get stroke type
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int GetStrokeType()
{
	return GetSelect();
}
//=================================================================================================
//!	get stroke
//!	@retval			---
//-------------------------------------------------------------------------------------------------
instance<OutlineGenStroke>& GetStroke()
{
	return m_stroke;
}
//=================================================================================================
//!	get dash
//!	@retval			---
//-------------------------------------------------------------------------------------------------
instance<OutlineGenDash>& GetDash()
{
	return m_dash;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iOutlineGen GetValue()
{
	int	s = GetSelect();
	if( s == 0 )
		return ( iOutlineGen )m_stroke;
	else
		return ( iOutlineGen )m_dash;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace GenStrokeCfgView;		

#pragma pack( pop )			//release align
