/*************************************************************************************************/
/*!
   	@file		BrushSolidCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"BrushSolidCfgView" class 
**************************************************************************************************/
class BrushSolidCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<ColorCfgView>		m_color;
	iPaintSolid_gp					m_brush;
	
	rControlMsg						m_msg;
	int								m_id;
	

// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_color->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Size().width , p->m_rect.Size().height ) )
			);
	m_color->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
BrushSolidCfgView() : 
		m_id( 0 ) 
{
	m_color->SetValue( rgba( 127 , 191 , 121 , 255 ) );
	m_brush	= CreatePaintSolid( rgba( 127 , 191 , 121 , 255 ) );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set color
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetColor
		(
		const rgba&	c
		)
{
	m_color->SetValue( c );
	m_brush->SetColor( c );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iPaint_gp GetBrush()
{
	m_brush->SetColor( m_color->GetValue() );
	return (iPaint_gp)m_brush;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
