/*************************************************************************************************/
/*!
   	@file		BrushGradRadialCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"BrushGradRadialCfgView" class 
**************************************************************************************************/
class BrushGradRadialCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<ColorlistCfgView>				m_color;
	iPaintGradRadial_gp							m_brush;
	rControlMsg									m_msg;
	int											m_id;
	const int									m_color_w;

	// edit data
	fvector2			m_pos;
	fvector2			m_vec;
	float				m_rate[4];

	iPen_gp				m_pen_handle;
	iPaint_gp			m_brush_handle;
	const float			m_handle_r;
	
// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_color->SetColorNum( 4 );
	m_color->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( m_color_w , p->m_rect.Size().height ) )
			);
	m_color->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	m_color->SetValue( 0 , rgba( 0 , 0 , 0 , 255 ) );
	m_color->SetValue( 1 , rgba( 255 , 255 , 255 , 255 ) );
	m_color->SetValue( 2 , rgba( 0 , 255 , 255 , 255 ) );
	m_color->SetValue( 3 , rgba( 255 , 255 , 255 , 255 ) );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
BrushGradRadialCfgView() : 
		m_id( 0 ) , 
		m_color_w( 130 ) , 
		m_vec( 0.0f , -40.0f ) , 
		m_pos( 0.0f , 0.0f ) , 
		m_handle_r( 1.0f )
{
	m_pen_handle	= CreatePenStroke();
	m_brush_handle	= CreatePaintSolid( rgba( 40 , 121 , 121 , 255 ) );
	m_brush			= CreatePaintGradRadial();
	m_rate[0]= 0.0f;
	m_rate[1]= 0.5f;
	m_rate[2]= 0.7f;
	m_rate[3]= 1.0f;
}		
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iPaint_gp GetBrush
		(
		const faffine&	ltod
		)
{
	rgba	color[4] = 
			{
			m_color->GetValue( 0 ) , 
			m_color->GetValue( 1 ) , 
			m_color->GetValue( 2 ) , 
			m_color->GetValue( 3 ) 
			};
	m_brush->SetGradationVector( m_pos , m_vec.Length() );
	m_brush->SetColorTable( 4 , m_rate , color );
	m_brush->SetTransform( ltod.Inverse() );
	return (iPaint_gp)m_brush;
}
//=================================================================================================
int GetEditPointNum()
{
	return 4;
}
//=================================================================================================
fvector2 GetEditPoint
		(
		int				off
		)
{
	return m_pos + m_vec * m_rate[ off ];
}
//=================================================================================================
void SetEditPoint
		(
		int				off , 
		fvector2		pnt
		)
{
	if( off == 0 )
		m_pos	= pnt;
	else if( off == 3 )
		m_vec	= pnt - m_pos;
	else
	{
		float		l	= m_vec.Length();
		if( l == 0.0f )
			return;
		fvector2	uv	= m_vec / l;
		float		r	= uv.Inner( pnt - m_pos ) / l;
		r	= r < m_rate[ off - 1 ] ? m_rate[ off - 1 ] : r;
		r	= r > m_rate[ off + 1 ] ? m_rate[ off + 1 ] : r;
		m_rate[ off ]	 = r;
	}
}	
//=================================================================================================
bool SearchEditPoint
		(
		const fvector2&		pnt , 
		int*				pntoff
		)
{
	int		off , num = GetEditPointNum();
	for( off = 0 ; off < num ; off++ )
	{
		fvector2	p = GetEditPoint( off );
		frect		r( p.x - m_handle_r , p.y - m_handle_r , p.x + m_handle_r , p.y + m_handle_r );
		if( true == r.IsInside( pnt ) )
		{
			*pntoff	= off;
			return true;
		}
	}
	return false;
}
//=================================================================================================
void DrawEditHandle
		(
		iGraphics_gp&	g , 
		const faffine&	ltod
		)
{
	g->SetStrokeWidth( 0.5f );
	g->SetStrokePen( m_pen_handle );
	g->SetStrokePaint( m_brush_handle );
	g->SetPaint( m_brush_handle );
	fvector2	pnt[] = { GetEditPoint( 0 ) , GetEditPoint( GetEditPointNum() - 1 ) };
	g->StrokeLine( _countof( pnt ) , pnt , faffine() , ltod );
	int		off , num = GetEditPointNum();
	for( off = 0 ; off < num ; off++ )
		g->PaintCircle( GetEditPoint( off ) , m_handle_r , m_handle_r , ltod );
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
