/*************************************************************************************************/
/*!
   	@file		BrushCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"BrushCfgView" class 
**************************************************************************************************/
class BrushCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<RadioGroupView>			m_select;
	instance<BrushSolidCfgView>		m_solid;
	instance<BrushGradLinearCfgView>	m_gradlinear;
	instance<BrushGradRadialCfgView>	m_gradradial;
	instance<BrushSurfaceCfgView>	m_surface;

	rControlMsg			m_msg;
	int					m_id;
	const int			m_item_h;

// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	if( id == 0 )
	{
		if( m_select->GetSelect() == 0 )
			m_solid->Show( true );
		else
			m_solid->Show( false );
		if( m_select->GetSelect() == 1 )
			m_gradlinear->Show( true );
		else
			m_gradlinear->Show( false );
		if( m_select->GetSelect() == 2 )
			m_gradradial->Show( true );
		else
			m_gradradial->Show( false );
		if( m_select->GetSelect() == 3 )
			m_surface->Show( true );
		else
			m_surface->Show( false );
	}
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_select->SetAlign( Horz_RadioAlign );
	m_select->SetRadioNum( 4 );
	m_select->SetString( 0 , L"solid" );
	m_select->SetString( 1 , L"linear" );
	m_select->SetString( 2 , L"radial" );
	m_select->SetString( 3 , L"image" );
	m_select->SetSelect( 0 );
	m_select->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Size().width , m_item_h ) )
			);
	m_select->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	m_solid->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_item_h ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_item_h ) ) , 
			m_select->GetSelect() == 0
			);
	m_solid->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	m_gradlinear->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_item_h ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_item_h ) ) , 
			m_select->GetSelect() == 1
			);
	m_gradlinear->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	m_gradradial->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_item_h ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_item_h ) ) , 
			m_select->GetSelect() == 2
			);
	m_gradradial->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	m_surface->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_item_h ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_item_h ) ) , 
			m_select->GetSelect() == 3
			);
	m_surface->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
BrushCfgView() : 
		m_item_h( 20 ) , 
		m_id( 0 )
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set color
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetColor
		(
		const rgba&	c
		)
{
	m_solid->SetColor( c );
}
//=================================================================================================
//!	add texture
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool AddTexture
		(
		const wstring&	path
		)
{
	if( false ==  m_surface->AddTexture( path ) )
		return false;
	return true;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iPaint_gp GetBrush
		(
		const DPI&		dpi , 
		const faffine&	ltod
		)
{
	int		type = m_select->GetSelect();
	if( type == 0 )
		return m_solid->GetBrush();
	else if( type == 1 )
		return m_gradlinear->GetBrush( ltod );
	else if( type == 2 )
		return m_gradradial->GetBrush( ltod );
	else if( type == 3 )
		return m_surface->GetBrush( dpi , ltod );
	return m_solid->GetBrush();
}
//=================================================================================================
int GetEditPointNum()
{
	int		type = m_select->GetSelect();
	if( type == 0 )
		return 0;
	else if( type == 1 )
		return m_gradlinear->GetEditPointNum();
	else if( type == 2 )
		return m_gradradial->GetEditPointNum();
	else if( type == 3 )
		return m_surface->GetEditPointNum();
	return 0;
}
//=================================================================================================
void SetEditPoint
		(
		int				off , 
		fvector2		pnt
		)
{
	int		type = m_select->GetSelect();
	if( type == 1 )
		m_gradlinear->SetEditPoint( off , pnt );
	else if( type == 2 )
		m_gradradial->SetEditPoint( off , pnt );
	else if( type == 3 )
		m_surface->SetEditPoint( off , pnt );
}	
//=================================================================================================
bool SearchEditPoint
		(
		const fvector2&		pnt , 
		int*				pntoff
		)
{
	int		type = m_select->GetSelect();
	if( type == 1 )
		return m_gradlinear->SearchEditPoint( pnt , pntoff );
	else if( type == 2 )
		return m_gradradial->SearchEditPoint( pnt , pntoff );
	else if( type == 3 )
		return m_surface->SearchEditPoint( pnt , pntoff );
	return false;
}
//=================================================================================================
void DrawEditHandle
		(
		iGraphics_gp&	g , 
		const faffine&	ltod
		)
{
	int		type = m_select->GetSelect();
	if( type == 1 )
		m_gradlinear->DrawEditHandle( g , ltod );
	else if( type == 2 )
		m_gradradial->DrawEditHandle( g , ltod );
	else if( type == 3 )
		m_surface->DrawEditHandle( g , ltod );
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
