/*************************************************************************************************/
/*!
   	@file		AsioKsSetting.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"../Project/win/AsioKs/resource.h"
#include	<iomanip>

#pragma pack( push , 8 )		//set align

using namespace shared;
using namespace icubic;
using namespace icubic_audio;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"AsioKsSetting" class 
**************************************************************************************************/
class AsioKsSetting : public Dialog
{
	msg_dlg_map_begin()
	msg_dlg_hook( WM_INITDIALOG					, OnInitDialog );
	msg_dlg_hook( WM_DESTROY					, OnDestroy );
	msg_dlg_hook( WM_HSCROLL					, OnHScroll );
	msg_dlg_cmd_hook( IDC_COMBO_DEVICE			, CBN_SELCHANGE	, OnDeviceChange );
	msg_dlg_cmd_hook( IDC_COMBO_FORMAT			, CBN_SELCHANGE	, OnFormatChange );
	msg_dlg_cmd_hook( IDCANCEL					, BN_CLICKED	, OnCancel );
	msg_dlg_map_end()

	cb_guid_define( FileId , 0xD308BB1E , 0xB2CD4571 , 0xA8973677 , 0xCF3C7E47 );
	
public:
	class SampleType
	{
	public:
		GUID			m_type;
		uint32			m_samplebit;
		SampleFormat	m_format;
	};
	class FormatInfo
	{
	public:
		SampleType			m_sampletype;
		uint32				m_samplerate;
	};
	class DeviceInfo
	{
	public:
		wstring				m_name;
		Array<uint32>		m_channels[2];
		wstring				m_path;
		ULONG				m_pinid;
		Array<FormatInfo>	m_formats;
		DeviceInfo() : m_pinid(0){}
	};
	class EditData
	{
	public:
		int32		m_devid;
		int32		m_fmtid;
		uint32		m_buffersamples;
		EditData() : m_devid( -1 ) , m_fmtid( -1 ) , m_buffersamples( 256 ){}
	};

// variable member
private:
	Array<SampleType>			m_sampletypes;
	Straightdata<DeviceInfo>	m_devlist;
	EditData					m_edit;
	
	// const
	static const uint32			m_buffersamples_min = 32 * 2;
	static const uint32			m_buffersamples_max = 32 * 128;

// private functions
private:
//=================================================================================================
bool Save()
{
	wstring		folder;
	if( false == GetModuleFolder( NULL , &folder ) )
		return false;
	instance<FileWriter>	file;
	if( false == file->Open( ( folder + L"asioks.setting" ).c_str() ) )
		return false;
	if( false == icubic::Save( (iStreamWrite)file , FileId() ) )
		return false;
	if( false == Save_utf16( (iStreamWrite)file , m_devlist[m_edit.m_devid].m_path ) )
		return false;
	if( false == file->Write( &m_devlist[m_edit.m_devid].m_pinid , sizeof( m_devlist[m_edit.m_devid].m_pinid ) , 1 , Little_EndianType ) )
		return false;
	if( false == file->Write( &m_devlist[m_edit.m_devid].m_formats[m_edit.m_fmtid].m_samplerate , sizeof( m_devlist[m_edit.m_devid].m_formats[m_edit.m_fmtid].m_samplerate ) , 1 , Little_EndianType ) )
		return false;
	if( false == file->Write( &m_edit.m_buffersamples , sizeof( m_edit.m_buffersamples ) , 1 , Little_EndianType ) )
		return false;
	return true;
}
//=================================================================================================
bool Load()
{
	wstring		folder;
	if( false == GetModuleFolder( NULL , &folder ) )
		return false;
	instance<FileReader>	file;
	if( false == file->Open( ( folder + L"asioks.setting" ).c_str() ) )
		return false;
	{
		guid	id;
		if( false == icubic::Load( (iStreamRead)file , &id ) )
			return false;
		if( id != FileId() )
			return false;
	}		
	wstring		dev_path;
	if( false == Load_utf16( (iStreamRead)file , &dev_path ) )
		return false;
	ULONG		pinid;
	if( false == file->Read( &pinid , sizeof( pinid ) , 1 , Little_EndianType ) )
		return false;
	uint32		samplerate;
	if( false == file->Read( &samplerate , sizeof( samplerate ) , 1 , Little_EndianType ) )
		return false;
	uint32		buffersamples;
	if( false == file->Read( &buffersamples , sizeof( buffersamples ) , 1 , Little_EndianType ) )
		return false;
	buffersamples	= clip( buffersamples , m_buffersamples_min , m_buffersamples_max );

	int	devoff , devnum = m_devlist.GetDatanum();
	for( devoff = 0 ; devoff < devnum ; devoff++ )
	{
		if( m_devlist[devoff].m_path == dev_path
		&&  m_devlist[devoff].m_pinid == pinid )
			break;
	}
	if( devoff == devnum )
		devoff	= 0;
	m_edit.m_devid	= devoff;
	SelectFormat( samplerate );
	m_edit.m_buffersamples	= buffersamples;	
	return true;
}
//=================================================================================================
void SelectFormat
		(
		uint32		samplerate
		)
{
	int		fmtoff , fmtnum = m_devlist[m_edit.m_devid].m_formats.GetDatanum();
	int		fmtid	= 0;
	for( fmtoff = 0 ; fmtoff < fmtnum ; fmtoff++ )
	{
		if( m_devlist[m_edit.m_devid].m_formats[fmtoff].m_samplerate <= samplerate )
			fmtid	= fmtoff;
	}
	m_edit.m_fmtid	= fmtid;
}
//=================================================================================================
void UpdateFormats
		(
		uint32			ch_max , 
		DeviceInfo&		devinfo
		)
{
	wdm::PinStream	device;
	devinfo.m_formats.Resize( 0 );

	static
	const uint32	samplerate[] = 
	{
		11025 , 
		22050 , 
		44100 , 
		48000 ,
		88200 ,  
		96000 , 
		176400 , 
		192000 , 
	};
	HANDLE	handle = CreateFileW
			(
			devinfo.m_path.c_str() , 
			GENERIC_READ | GENERIC_WRITE,
			0,
			NULL,
			OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED,
			NULL
			);
    if ( false == IsValidHandle( handle ) )
		return;

	uint32	ch;
	for( ch = ch_max ; ch >= 1 ; ch-- )
	{
		int32		sr_off;
		for( sr_off = 0 ; sr_off < _countof( samplerate ) ; sr_off++ )
		{
			int32	st_off;
			for( st_off = 0 ; st_off < m_sampletypes.GetDatanum() ; st_off++ )
			{
				if( true == device.Create
						( 
						handle , 
						devinfo.m_pinid , 
						ch , 
						m_sampletypes[st_off].m_type , 
						m_sampletypes[st_off].m_samplebit , 
						samplerate[sr_off]
						) )
				{
					device.Destroy();
					int32	loff = devinfo.m_formats.Add();
					devinfo.m_formats[loff].m_sampletype	= m_sampletypes[st_off];
					devinfo.m_formats[loff].m_samplerate	= samplerate[sr_off];
					break;
				}
			}
		}
		if( devinfo.m_formats.GetDatanum() != 0 )
			break;
	}
	uint32	av_ch;
	for( av_ch = 1 ; av_ch < ch ; av_ch++ )
	{
		int32	fmtoff;
		for( fmtoff = 0 ; fmtoff < devinfo.m_formats.GetDatanum() ; fmtoff++ )
		{
			if( false == device.Create
					( 
					handle , 
					devinfo.m_pinid , 
					av_ch , 
					devinfo.m_formats[fmtoff].m_sampletype.m_type , 
					devinfo.m_formats[fmtoff].m_sampletype.m_samplebit , 
					devinfo.m_formats[fmtoff].m_samplerate
					) )
					break;
			device.Destroy();
		}
		if( fmtoff == devinfo.m_formats.GetDatanum() )
			devinfo.m_channels[1][ devinfo.m_channels[1].Add() ]	= av_ch;
	}
	devinfo.m_channels[1][ devinfo.m_channels[1].Add() ]	= ch;
	
	CloseHandle( handle );
}
//=================================================================================================
void UpdateDevlicelist()
{
	m_devlist.Resize( 0 );
	instance<wdm::EnumAudioDevice>	enums;
	enums->Enum();
	int32	devoff , devnum = enums->GetDeviceNum();
	for( devoff = 0 ; devoff < devnum ; devoff++ )
	{
		IEnumAudioDevice::DeviceInfo	info;
		cb_verify( true == enums->GetDeviceInfo( devoff , &info ) );
		if( info.m_type == IEnumAudioDevice::Output )
		{
			uint32	ch_max;
			int	loff = m_devlist.Add();
			m_devlist[loff].m_name = info.m_name;
			cb_verify( true == enums->GetWdmInfo( devoff , &m_devlist[loff].m_path , &m_devlist[loff].m_pinid , 0 , &ch_max ) );
			UpdateFormats( ch_max , m_devlist[loff] );
			if( m_devlist[loff].m_formats.GetDatanum() == 0 )
				m_devlist.Delete(loff);
		}
	}
}
//=================================================================================================
void UpdateDevice()
{
	combobox_ResetContent( IDC_COMBO_DEVICE );
	int		devoff , devnum = m_devlist.GetDatanum();
	for( devoff = 0 ; devoff < devnum ; devoff++ )
		combobox_AddString( IDC_COMBO_DEVICE , m_devlist[devoff].m_name.c_str() );
	combobox_SetCurSel( IDC_COMBO_DEVICE , m_edit.m_devid );
}
//=================================================================================================
void UpdateFormat()
{
	combobox_ResetContent( IDC_COMBO_FORMAT );
	int		fmtoff , fmtnum = m_devlist[m_edit.m_devid].m_formats.GetDatanum();
	for( fmtoff = 0 ; fmtoff < fmtnum ; fmtoff++ )
	{
		std::wostringstream	os;
		os << m_devlist[m_edit.m_devid].m_formats[fmtoff].m_samplerate << L"Hz";
		combobox_AddString( IDC_COMBO_FORMAT , os.str().c_str() );
	}
	combobox_SetCurSel( IDC_COMBO_FORMAT , m_edit.m_fmtid );
}
//=================================================================================================
void UpdateBufferSamples()
{
	slider_SetRange( IDC_SLIDER_BUFFERSAMPLES , 0 , ( m_buffersamples_max - m_buffersamples_min ) / 32 , false );
	slider_SetPos( IDC_SLIDER_BUFFERSAMPLES , ( m_edit.m_buffersamples - m_buffersamples_min ) / 32 );
}
//=================================================================================================
void UpdateLatency()
{
	if( m_edit.m_fmtid < 0 )
	{
		static_SetText( IDC_STATIC_LATENCY , L"---" );
		return;
	}
	std::wostringstream	os;
	os << m_edit.m_buffersamples << L"samples";
	os << L" ( " << setw( 3 ) << fixed << setprecision( 2 ) << (float)m_edit.m_buffersamples * 1000 / (float)m_devlist[m_edit.m_devid].m_formats[m_edit.m_fmtid].m_samplerate << L"ms )";
	static_SetText( IDC_STATIC_LATENCY , os.str().c_str() );
}
//=================================================================================================
void UpdateDeviceInfo()
{
	std::wostringstream	os;
	os << L"`l: ";
	int	choff;
	for( choff = 0 ; choff < m_devlist[m_edit.m_devid].m_channels[1].GetDatanum() ; choff++ )
	{
		if( choff != 0 )
			os << L" , ";
		os << m_devlist[m_edit.m_devid].m_channels[1][choff];
	}
	os << L"\r\nTvOrbg: " << m_devlist[m_edit.m_devid].m_formats[m_edit.m_fmtid].m_sampletype.m_samplebit;
	edit_SetText( IDC_EDIT_INFO , os.str().c_str() );
}
// msg handler
public:
//=================================================================================================
void OnInitDialog
		(
		WPARAM	wparam,
		LPARAM	lparam
		)
{
	UpdateDevice();
	UpdateFormat();
	UpdateBufferSamples();
	UpdateLatency();
	UpdateDeviceInfo();
}
//=================================================================================================
void OnDestroy
		(
		WPARAM	wparam,
		LPARAM	lparam
		)
{
	Save();
}
//=================================================================================================
void OnHScroll
		(
		WPARAM	wparam,
		LPARAM	lparam
		)
{
	int		msg = LOWORD( wparam );
	int		pos = HIWORD( wparam );
	if( msg == TB_THUMBTRACK
		 ||  msg == TB_THUMBPOSITION
	     ||  msg == TB_PAGEUP
	     ||  msg == TB_PAGEDOWN )
	{
		cb_trace( L"OnHScroll = %d\n" , slider_GetPos( IDC_SLIDER_BUFFERSAMPLES ) );
		m_edit.m_buffersamples	= slider_GetPos( IDC_SLIDER_BUFFERSAMPLES ) * 32 + m_buffersamples_min;
		UpdateLatency();
	}
}
//=================================================================================================
void OnDeviceChange()
{
	uint32	samplerate	= m_devlist[m_edit.m_devid].m_formats[m_edit.m_fmtid].m_samplerate;
	m_edit.m_devid		= combobox_GetCurSel( IDC_COMBO_DEVICE );
	SelectFormat( samplerate );

	UpdateDevice();
	UpdateFormat();
	UpdateBufferSamples();
	UpdateLatency();
	UpdateDeviceInfo();
}
//=================================================================================================
void OnFormatChange()
{
	m_edit.m_fmtid	= combobox_GetCurSel( IDC_COMBO_FORMAT );
	UpdateFormat();
	UpdateBufferSamples();
	UpdateLatency();
	UpdateDeviceInfo();
}
//=================================================================================================
void OnCancel()
{
	EndDialog( 0 );
//	Destroy();
}
// public functions
public:
//=================================================================================================
AsioKsSetting()
{
	m_sampletypes.Resize( 4 );
	m_sampletypes[0].m_type			= KSDATAFORMAT_SUBTYPE_PCM;
	m_sampletypes[0].m_samplebit	= 32;
	m_sampletypes[0].m_format		= int32align32lsb;
	m_sampletypes[1].m_type			= KSDATAFORMAT_SUBTYPE_PCM;
	m_sampletypes[1].m_samplebit	= 24;
	m_sampletypes[1].m_format		= int24align24lsb;
	m_sampletypes[2].m_type			= KSDATAFORMAT_SUBTYPE_PCM;
	m_sampletypes[2].m_samplebit	= 16;
	m_sampletypes[2].m_format		= int16align16lsb;
	m_sampletypes[3].m_type			= KSDATAFORMAT_SUBTYPE_PCM;
	m_sampletypes[3].m_samplebit	= 8;
	m_sampletypes[3].m_format		= int8align8;
}
//=================================================================================================
~AsioKsSetting()
{
	Destroy();
}
//=================================================================================================
bool Initialize
		(
		DeviceInfo*	devinfo , 
		int32*		fmtid , 
		uint32*		buffersamples
		)
{
	UpdateDevlicelist();
	if( m_devlist.GetDatanum() == 0 )
		return false;
	
	if( false == Load() )
	{
		m_edit.m_devid			= 0;
		SelectFormat( 44100 );
		m_edit.m_buffersamples	= 512;
	}	
	store( devinfo , m_devlist[m_edit.m_devid] );
	store( fmtid , m_edit.m_fmtid );
	store( buffersamples , m_edit.m_buffersamples );
	return true;
}
//=================================================================================================
bool Create
		(
		HINSTANCE			hinst , 
		HWND				parent
		)
{
	if( m_hwnd != NULL )
		return true;
	return DoModal( hinst , parent , L"IDD_ASIOKS_SETTING" , 0 );
	
/*
	if( m_hwnd != NULL )
		return true;
	return Dialog::Create( hinst , parent , L"IDD_ASIOKS_SETTING" );
*/
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define


#pragma pack( pop )			//release align
