/*************************************************************************************************/
/*!
   	@file		Misc.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
cb_inline
bool GetModulePath
		(
		HINSTANCE		hinst , 
		wstring*		rpath
		)
{
	wchar_t		path[ _MAX_PATH ];
	DWORD	size = GetModuleFileNameW( hinst , path , _MAX_PATH );
	if( size == 0 )
		return false;
	store( rpath , wstring( path ) );
	return true;
}
//=================================================================================================
cb_inline
bool GetModuleFolder
		(
		HINSTANCE		hinst , 
		wstring*		folder
		)
{
	wchar_t		path[_MAX_PATH];
	wchar_t		drive[_MAX_DRIVE];
	wchar_t		dir[_MAX_DIR];
	wchar_t		fname[_MAX_FNAME];
	wchar_t		ext[_MAX_EXT];
	DWORD	size = GetModuleFileNameW( hinst , path , _MAX_PATH );
	if( size == 0 )
		return false;
	_wsplitpath_s( path , drive , _MAX_DRIVE , dir , _MAX_DIR , fname , _MAX_FNAME , ext , _MAX_EXT );
	_wmakepath_s( path , _MAX_PATH , drive , dir , L"" , L"");
	store( folder , wstring( path ) );
	return true;
}
//=================================================================================================
cb_inline
bool IsValidHandle
		(
		HANDLE	handle
		)
{
	if( handle == NULL || handle == INVALID_HANDLE_VALUE )
		return false;
    return true;
}
//=================================================================================================
cb_inline
void SafeCloseHandle
		(
		HANDLE&		handle
		)
{
	if( true == IsValidHandle( handle ) )
		CloseHandle( handle );
	handle	= NULL;
}
//=================================================================================================
cb_inline
bool ToString
		(
		const GUID&		clsid , 
		wstring*		str
		)
{
	LPOLESTR	olestr = NULL;
	if( S_OK != StringFromCLSID( clsid , &olestr ) )
		return false;
	*str	= olestr;
	::CoTaskMemFree( olestr );
	return true;
}
//=================================================================================================
cb_inline
bool StringTo
		(
		GUID*			clsid , 
		const wchar_t*	str
		)
{
	if( S_OK != CLSIDFromString( ( LPOLESTR )str , clsid ) )
		return false;
	return true;
}


};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
