/*************************************************************************************************/
/*!
   	@file		iMetadata.h
	@author 	Fanzo
*/
/*************************************************************************************************/

#ifndef		_21F1F2E3_B713_4e00_974C_5202D5D5C993
#define		_21F1F2E3_B713_4e00_974C_5202D5D5C993

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IMetaNode" interface 
***************************************************************************************************/
cb_guid_define( IMetaNode_IID , 0x847005CE , 0x9167403a , 0xBA2FAE7C , 0x302871F4 );
class IMetaNode;
typedef icubic::iface_object< IMetaNode , IMetaNode_IID >		iMetaNode;
typedef icubic::iface_reference< IMetaNode , IMetaNode_IID >	rMetaNode;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IMetaNode
{
public:
//=================================================================================================
//!	set parent
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call SetParent
		(
		iMetaNode&		parent
		) = 0;
//=================================================================================================
//!	get parent
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iMetaNode cb_call GetParent() = 0;
//=================================================================================================
//!	get childnum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
int cb_call GetChildnum() = 0;
//=================================================================================================
//!	get child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iMetaNode cb_call GetChild
		(
		int		childoff
		) = 0;
//=================================================================================================
//!	insert child
//!	@retval			if error , return -1
//-------------------------------------------------------------------------------------------------
virtual
int cb_call InsertChild
		(
		iMetaNode&		child , 
		int				insertpos
		) = 0;
//=================================================================================================
//!	search child
//!	@retval			if not exist return -1
//-------------------------------------------------------------------------------------------------
virtual
int cb_call SearchChild
		(
		iMetaNode&		child
		) = 0;
//=================================================================================================
//!	remove child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call RemoveChild
		(
		int		childoff
		) = 0;
//=================================================================================================
//!	remove
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Remove() = 0;
};

/**************************************************************************************************
 "IMetadata" interface 
***************************************************************************************************/
cb_guid_define( IMetadata_IID , 0xFBCAEC9B , 0xBC0A425a , 0xB0DC668B , 0x509004EF );
class IMetadata;
typedef icubic::iface_object< IMetadata , IMetadata_IID >		iMetadata;
typedef icubic::iface_reference< IMetadata , IMetadata_IID >	rMetadata;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IMetadata : public IMetaNode
{
public:
//=================================================================================================
//!	
//!	@retval			---
//-------------------------------------------------------------------------------------------------
/*
virtual
void cb_call test() = 0;
*/
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align

#endif