/*************************************************************************************************/
/*!
   	@file		iPathSegment.h
	@author 	Fanzo
 	@date 		2008/3/1
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne
#define		cb_pathsegment_max_accident_error		0.2f

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define
///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IPathSegment" interface 
***************************************************************************************************/
cb_guid_define( IPathSegment_IID , 0x553DF756 , 0x682040cc , 0xBF8A2EC8 , 0x3C5A603E );
class IPathSegment;
typedef icubic::iface_object< IPathSegment , IPathSegment_IID >		iPathSegment;
typedef icubic::iface_reference< IPathSegment , IPathSegment_IID >	rPathSegment;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPathSegment
{
public:
//=================================================================================================
//!	IsExist
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call IsExist() = 0;
//=================================================================================================
//!	get optimum samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
int cb_call GetOptimumSample
		(
		float		samplescale
		) = 0;
//=================================================================================================
//!	get optimum length samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
int cb_call GetOptimumLengthSample() = 0;
//=================================================================================================
//!	value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
fvector2 cb_call Value
		(
		float	t
		) = 0;
//=================================================================================================
//!	Differential
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
fvector2 cb_call Differential
		(
		float	t
		) = 0;
//=================================================================================================
//!	SecondOrderDifferential
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
fvector2 cb_call SecondOrderDifferential
		(
		float	t
		) = 0;
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
