/*************************************************************************************************/
/*!
   	@file		ioutline.h
	@author 	Fanzo
 	@date 		2008/3/2
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

struct OutlineNode
{
	union
	{
		float	m[ 2 ];
		struct
		{
			float	x , y;
		};
	};
	OutlineNode*	m_next;
};
typedef OutlineNode*	OutlineNodePtr;

struct OutlineSeg
{
	OutlineNode		*m_node;
	OutlineSeg		*m_next;
};
struct OutlineInfo
{
	frect			m_boundbox;
	OutlineSeg		*m_first;
};

/**************************************************************************************************
 "IOutlineInfo" interface 
***************************************************************************************************/
cb_guid_define( IOutlineInfo_IID , 0xBCE5CABC , 0x9E574f05 , 0xA7440931 , 0x395B89B7 );
class IOutlineInfo;
typedef icubic::iface_object< IOutlineInfo , IOutlineInfo_IID >		iOutlineInfo;
typedef icubic::iface_reference< IOutlineInfo , IOutlineInfo_IID >	rOutlineInfo;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IOutlineInfo
{
public:
//=================================================================================================
//!	get info
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call GetOutlineInfo
		(
		OutlineInfo*	info
		) = 0;
};

/**************************************************************************************************
 "IOutline" interface 
***************************************************************************************************/
cb_guid_define( IOutline_IID , 0xC43C7CC8 , 0x35A74a36 , 0xA84C9D14 , 0x95DFA06E );
class IOutline;
typedef icubic::iface_object< IOutline , IOutline_IID >	iOutline;
typedef icubic::iface_reference< IOutline , IOutline_IID >	rOutline;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IOutline : public IOutlineInfo
{
public:
//=================================================================================================
//!	Reset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Reset() = 0;
//=================================================================================================
//!	copy
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Copy
		(
		IOutlineInfo*	info
		) = 0;
//=================================================================================================
//!	create group
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
OutlineSeg* cb_call CreateOutline() = 0;
//=================================================================================================
//!	insert node
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
OutlineNodePtr* cb_call InsertNode
		(
		OutlineNodePtr*		prev , 
		const fvector2		&pos
		) = 0;
//=================================================================================================
//!	insert node
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
OutlineNodePtr* cb_call InsertNode
		(
		OutlineNodePtr*		node , 
		const fvector2		pos[] , 
		int					num
		) = 0;
//=================================================================================================
//!	clip rect
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Clip
		(
		const frect&		clip , 
		const faffine&		trans
		) = 0;
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
