/*************************************************************************************************/
/*!
   	@file		iLoaderImagefile.h
	@author 	Fanzo
 	@date 		2008/3/25
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "ILoaderImagefile" interface 
***************************************************************************************************/
cb_guid_define( ILoaderImagefile_IID , 0x9CEB2B71 , 0xAB154835 , 0x80570DC7 , 0x0B048742 );
class ILoaderImagefile;
typedef icubic::iface_object< ILoaderImagefile , ILoaderImagefile_IID >	iLoaderImagefile;
typedef icubic::iface_reference< ILoaderImagefile , ILoaderImagefile_IID >	rLoaderImagefile;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ILoaderImagefile
{
public:
//=================================================================================================
//!	check image format
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call CheckImagefileSign
		(
		iFileStreamRead			&reader
		) = 0;
//=================================================================================================
//!	load
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Load
		(
		iFileStreamRead			&reader
		) = 0;
//=================================================================================================
//!	get number of image.
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
int32 cb_call GetImageNum() = 0;
//=================================================================================================
//!	get dpi
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
DPI cb_call GetImageDPI
		(
		int32		imageoff
		)const = 0;
//=================================================================================================
//!	get size of image.
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
isize cb_call GetImageSize
		(
		int32		imageoff
		) = 0;
//=================================================================================================
//!	get surface
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call GetImage
		(
		int32		imageoff , 
		pixelformat	destformat , 
		void*		dest , 
		int			pitchbyte
		) = 0;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
