/*************************************************************************************************/
/*!
   	@file		PathQuadratic.h
	@author 	Fanzo
 	@date 		2008/5/6
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"PathQuadratic_bs" class 
**************************************************************************************************/
class PathQuadratic_bs :
	public IPathSegment
{
	cb_copy_impossible( PathQuadratic_bs );
	
// variable member
private:
	float	m_samplenum;
	float	m_a[2] , m_b[2] , m_c[2];

// private functions
private:		
//=================================================================================================
//!	get optimum samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void UpdateSamplenum()
{
	if( m_a[0] == 0.0f && m_a[1] == 0.0f )
	{
		m_samplenum = 0.0f;
		return;
	}
	// h = 2 * sqrt( e / sqrt( ax^2 + ay^2 ) )
	float	h	= 2.0f * sqrtf( cb_pathsegment_max_accident_error / sqrtf( m_a[0]*m_a[0] + m_a[1]*m_a[1] ) );
	m_samplenum	= 1.0f / h;
}

// "IPath" interface functions
public:
//=================================================================================================
//!	IsExist
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call IsExist()
{
	if( m_a[0]==0.0f && m_a[1]==0.0f && m_b[0]==0.0f && m_b[1]==0.0f )
		return false;
	return true;
}
//=================================================================================================
//!	get optimum samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int cb_call GetOptimumSample
		(
		float	samplescale
		)
{
	int	num = (int)( samplescale * m_samplenum );
	return num < 2 ? 2 : num;
}
//=================================================================================================
//!	get optimum length samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int cb_call GetOptimumLengthSample()
{
	return 16;
}
//=================================================================================================
//!	value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 cb_call Value
		(
		float	t
		)
{
	float	t_t		= t * t;
	return fvector2
			(
			m_a[0] * t_t + m_b[0] * t + m_c[0] , 
			m_a[1] * t_t + m_b[1] * t + m_c[1]
			);
}
//=================================================================================================
//!	Differential
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 cb_call Differential
		(
		float	t
		)
{
	return fvector2
			(
			2.0f * m_a[0] * t + m_b[0] , 
			2.0f * m_a[1] * t + m_b[1]
			);		
}
//=================================================================================================
//!	SecondOrderDifferential
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 cb_call SecondOrderDifferential
		(
		float	t
		)
{
	return fvector2
			(
			2.0f * m_a[0] , 
			2.0f * m_a[1]
			);		
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PathQuadratic_bs() : m_samplenum( 0.0f )
{
	m_a[0]	= 0.0f;
	m_a[1]	= 0.0f;
	m_b[0]	= 0.0f;
	m_b[1]	= 0.0f;
	m_c[0]	= 0.0f;
	m_c[1]	= 0.0f;
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializeParam
		(
		float			a0 , 
		float			b0 , 
		float			c0 , 
		float			a1 , 
		float			b1 , 
		float			c1 , 
		const faffine&	affine
		)
{
	int		i;
	for( i = 0 ; i < 2 ; i++ )
	{
		m_a[i]	= affine.m[i][0]*a0 + affine.m[i][1]*a1;
		m_b[i]	= affine.m[i][0]*b0 + affine.m[i][1]*b1;
		m_c[i]	= affine.m[i][0]*c0 + affine.m[i][1]*c1 + affine.m[i][2];
	}
	UpdateSamplenum();
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializeBezierQ
		(
		const fvector2&	sp , 
		const fvector2&	hp , 
		const fvector2&	tp , 
		const faffine&	affine
		)
{
	InitializeParam
		( 
		sp.x - 2.0f * hp.x + tp.x , 
		2.0f * ( -sp.x + hp.x ) , 
		sp.x , 
		sp.y - 2.0f * hp.y + tp.y , 
		2.0f * ( -sp.y + hp.y ) , 
		sp.y , 
		affine
		); 
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializeBezierQ
		(
		float			sx , 
		float			sy , 
		float			hx , 
		float			hy , 
		float			tx , 
		float			ty , 
		const faffine&	affine
		)
{
	InitializeParam
		( 
		sx - 2.0f * hx + tx , 
		2.0f * ( -sx + hx ) , 
		sx , 
		sy - 2.0f * hy + ty , 
		2.0f * ( -sy + hy ) , 
		sy , 
		affine
		); 
}
};
/**************************************************************************************************
"PathQuadratic" class 
**************************************************************************************************/
class PathQuadratic : 
	virtual public object_base , 
	public PathQuadratic_bs
{
// query
	query_begin();
	iface_hook( IPathSegment , IPathSegment_IID )
	query_end( object_base );

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PathQuadratic()
{
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
