/*************************************************************************************************/
/*!
   	@file		OutlineEffectStroke.h
	@author 	Fanzo
 	@date 		2008/5/27
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iOutlineEffect.h"
#include	"JointBevel.h"
#include	"CapFlat.h"
#include	"PathSegmentSampler.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"OutlineEffectStroke" class 
**************************************************************************************************/
class OutlineEffectStroke : 
	virtual public object_base , 
	public IOutlineEffect
{
// query
	query_begin();
	iface_hook( IOutlineEffect , IOutlineEffect_IID )
	query_end( object_base );
	
// variable member
private:
	bool			m_close;
	float			m_w_r2;
	
	iJoint			m_joint;
	iCap			m_start_cap;
	iCap			m_end_cap;
	
// private functions
private:
//=================================================================================================
//!	start cap
//!	@retval			---
//-------------------------------------------------------------------------------------------------
OutlineNodePtr* SetStartCap
		(
		iOutline&		outline , 
		OutlineNodePtr*	node , 
		const fvector2&	vec , 
		const fvector2&	w0 , 
		const fvector2&	w1 
		)
{
	if( m_close == false )
		return m_start_cap->InsertCap( outline , node , -vec , w0 , w1 , 1.0f );
	return node;
}
//=================================================================================================
//!	end cap
//!	@retval			---
//-------------------------------------------------------------------------------------------------
OutlineNodePtr* SetEndCap
		(
		iOutline&		outline , 
		OutlineNodePtr*	node , 
		const fvector2&	vec , 
		const fvector2&	w0 , 
		const fvector2&	w1 
		)
{
	if( m_close == false )
		return m_end_cap->InsertCap( outline , node , vec , w0 , w1 , 1.0f );
	return node;
}
//=================================================================================================
//!	set loop
//!	@retval			---
//-------------------------------------------------------------------------------------------------
OutlineNodePtr* SetLoop
		(
		iOutline&		outline , 
		OutlineNodePtr*	node , 
		const fvector2&	s_pos , 
		const fvector2&	s_vec , 
		const fvector2&	s_w0 , 
		const fvector2&	s_w1 ,
		const fvector2&	t_pos , 
		const fvector2&	t_vec , 
		const fvector2&	t_w0 , 
		const fvector2&	t_w1 
		)
{
	if( m_close == false )
		return node;
	if( s_pos == t_pos )
		return m_joint->InsertJoint( outline , node , s_pos , s_vec , s_w0 , s_w1 , t_vec , t_w0 , t_w1 , 1.0f );

	fvector2	c_vec	= ( t_pos - s_pos ).GetUnit();
	fvector2	r		= ( c_vec * m_w_r2 ).GetRotate90();
	fvector2	c_sw0	= s_pos - r;
	fvector2	c_sw1	= s_pos + r;
	fvector2	c_tw0	= t_pos - r;
	fvector2	c_tw1	= t_pos + r;
	node = m_joint->InsertJoint( outline , node , s_pos , s_vec , s_w0 , s_w1 , c_vec , c_sw0 , c_sw1 , 1.0f );
	node = InsertLineStroke( outline , node , c_sw0 , c_sw1 , c_tw0 , c_tw1 );
	node = m_joint->InsertJoint( outline , node , t_pos , c_vec , c_tw0 , c_tw1 , t_vec , t_w0 , t_w1 , 1.0f );
	return node;
}
//=================================================================================================
//!	get param
//!	@retval			---
//-------------------------------------------------------------------------------------------------
OutlineNode* GetParam
		(
		OutlineNode*		src_node , 
		fvector2*			sp , 
		fvector2*			tp , 
		fvector2*			uv , 
		fvector2*			sw0 , 
		fvector2*			sw1 , 
		fvector2*			tw0 , 
		fvector2*			tw1
		)
{
	while( src_node != 0 && src_node->m_next != 0 )
	{
		fvector2	s_pos	= fvector2( src_node->x , src_node->y );
		fvector2	t_pos	= fvector2( src_node->m_next->x , src_node->m_next->y );
		if( s_pos != t_pos )
		{
			store( sp , s_pos );
			store( tp , t_pos );
			fvector2	vec	= store( uv , ( t_pos - s_pos ).GetUnit() );
			fvector2	r = ( vec * m_w_r2 ).GetRotate90();
			store( sw0 , s_pos - r );
			store( sw1 , s_pos + r );
			store( tw0 , t_pos - r );
			store( tw1 , t_pos + r );
			return src_node;
		}
		src_node	= src_node->m_next;
	}
	return 0;
}
//=================================================================================================
//!	insert line
//!	@retval			---
//-------------------------------------------------------------------------------------------------
OutlineNodePtr* InsertLineStroke
		(
		iOutline&			outline , 
		OutlineNodePtr*		node , 
		const fvector2&		sw0 , 
		const fvector2&		sw1 , 
		const fvector2&		tw0 , 
		const fvector2&		tw1
		)
{
	node = outline->InsertNode( node , sw0 );
	node = outline->InsertNode( node , tw0 );
	outline->InsertNode( node , sw1 );
	outline->InsertNode( node , tw1 );
	return node;
}
//=================================================================================================
//!	GenerateOutline
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void GenerateOutline
		(
		iOutline&		outline , 
		OutlineNode*	src_node
		)
{
	if( src_node == 0 || src_node->m_next == 0 )
		return;

	fvector2		sp , tp , uv , sw0 , sw1 , tw0 , tw1;
	src_node = GetParam( src_node , &sp , &tp , &uv , &sw0 , &sw1 , &tw0 , &tw1 );
	if( src_node == 0 )
		return;
	fvector2		fsp = sp , fuv =uv , fsw0 = sw0 , fsw1 = sw1;
	OutlineNodePtr*	node = &outline->CreateOutline()->m_node;

	node = SetStartCap( outline , node , uv , sw0 , sw1 );

	node = InsertLineStroke( outline , node , sw0 , sw1 , tw0 , tw1 );
	fvector2		t_sp , t_tp , t_uv , t_sw0 , t_sw1 , t_tw0 , t_tw1;
	while( 0 != ( src_node = GetParam( src_node , &t_sp , &t_tp , &t_uv , &t_sw0 , &t_sw1 , &t_tw0 , &t_tw1 ) ) )
	{
		node = m_joint->InsertJoint( outline , node , tp , uv , tw0 , tw1 , t_uv , t_sw0 , t_sw1 , 1.0f );
		node = InsertLineStroke( outline , node , t_sw0 , t_sw1 , t_tw0 , t_tw1 );
		sp = t_sp;
		tp = t_tp;
		uv = t_uv;
		sw0= t_sw0;
		sw1= t_sw1;
		tw0= t_tw0;
		tw1= t_tw1;
		src_node	= src_node->m_next;
	}

	node = SetLoop( outline , node , tp , uv , tw0 , tw1 , fsp , fuv , fsw0 , fsw1 );
	node = SetEndCap( outline , node , uv , tw0 , tw1 );
}
// "IOutlineEffect" interface functions
public:
//=================================================================================================
//!	effect
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call Effect
		(
		iOutline&		dest , 
		iOutline&		src
		)
{
	OutlineInfo		oi;
	if( false == src->GetOutlineInfo( &oi ) )
		return;

	const OutlineSeg*	first	= oi.m_first;
	while( first != 0 )
	{
		GenerateOutline( dest , first->m_node );
		first	= first->m_next;
	}
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
OutlineEffectStroke() : m_close( false ) , m_w_r2( 0.5f )
{
	m_joint		= instance<JointBevel>();
	m_start_cap	= instance<CapFlat>();
	m_end_cap	= instance<CapFlat>();
}
//=================================================================================================
//!	set width
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetWidth
		(
		float		w
		)
{
	m_w_r2	= w / 2.0f;
}
//=================================================================================================
//!	set stroke type
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetClose
		(
		bool		close
		)
{
	m_close	= close;
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
