/*************************************************************************************************/
/*!
   	@file		NormFunctionSpline.h
	@author 	Fanzo
 	@date 		2008/4/11
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"Spline.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"NormFunctionSpline" class 
**************************************************************************************************/
class NormFunctionSpline : 
	virtual public object_base , 
	public INormFunction
{
	query_begin();
	iface_hook( INormFunction , INormFunction_IID )
	query_end( object_base );
	
// variable member
private:
	fSpline_x	m_spline;
	
// private functions
private:

// "INormFunction" interface functions
public:
//=================================================================================================
//!	GetNormalizedValue
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float cb_call GetNormalizedValue
		(
		float		n		//!< [in] 0.0 - 1.0
		)
{
	return m_spline.GetValue( n );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
NormFunctionSpline()
{
}
//=================================================================================================
//!	set params
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool SetParam
		(
		SplineEdgetype	edgetype , 
		const fvector2	points[] ,		//!< [in]  0 <= point[ 0 ].x < point[ 1 ].x < ... < point[ n-1 ].x <= 1.0f
		int				pointnum , 
		float			s_gradient , 
		float			t_gradient
		)
{
	m_spline.SetEdgetype( edgetype );
	m_spline.SetEdgeGradient( s_gradient , t_gradient );
	m_spline.SetPoints( points , pointnum );
	return m_spline.Update();
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
