/*************************************************************************************************/
/*!
   	@file		CapArrow.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"CapArrow" class 
**************************************************************************************************/
class CapArrow : 
	virtual public object_base , 
	public ICap
{
// query
	query_begin();
	iface_hook( ICap , ICap_IID )
	query_end( object_base );
	
// variable member
private:
	float	m_head_scale;
	float	m_width_scale;
	
// "ICap" interface functions
public:
//=================================================================================================
//!	insert joint
//!	@retval			last node pointer
//-------------------------------------------------------------------------------------------------
OutlineNodePtr* cb_call InsertCap
		(
		iOutline			&outline ,
		OutlineNodePtr*		node , 
		const fvector2&		vec , 
		const fvector2&		w0 ,
		const fvector2&		w1 , 
		float				samplescale
		)
{
//	if( node == 0 )
//		return node;
	fvector2	pnt[ 5 ];
	pnt[0]	= w0;
	pnt[1]	= ( w0 - w1 ) * m_width_scale + w0;
	pnt[2]	= vec * ( w0 - w1 ).Length() * m_head_scale + ( w0 + w1 ) / 2.0f;
	pnt[3]	= ( w1 - w0 ) * m_width_scale + w1;
	pnt[4]	= w1;

	OutlineSeg* info = outline->CreateOutline();
	outline->InsertNode( &info->m_node , pnt , _countof( pnt ) );
	return node;
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
CapArrow() : m_head_scale( 1.0f ) , m_width_scale( 0.5f )
{
}
//=================================================================================================
//!	set scale
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetArrowSize
		(
		float	head_scale , 
		float	width_scale
		)
{
	m_head_scale	= head_scale;
	m_width_scale	= width_scale;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
