/*************************************************************************************************/
/*!
   	@file		sb.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once


#pragma pack( push , 8 )		//set align
namespace icubic_audio
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

enum SampleFormat
{
	int8align8	= 0 , 

	int16align16lsb , 
	int16align16msb , 
	int24align24lsb , 
	int24align24msb , 
	int32align32lsb , 
	int32align32msb , 

	float32align32lsb ,
	float32align32msb , 		
	float64align64lsb , 		
	float64align64msb , 

	int16align32lsb , 
	int16align32msb , 
	int18align32lsb , 
	int18align32msb , 
	int20align32lsb , 
	int20align32msb , 
	int24align32lsb , 
	int24align32msb , 
	
	SampleFormatNum
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
cb_inline
int32 GetSampleFormatSize
		(
		SampleFormat	fmt
		)
{
	static const int32	tbl[SampleFormatNum] = 
	{
		1 , 
		2 , 
		2 , 
		3 , 
		3 , 
		4 , 
		4 , 
		4 , 
		4 , 
		8 , 
		8 , 
		4 , 
		4 , 
		4 , 
		4 , 
		4 , 
		4 , 
		4 , 
		4 , 
	};
	return tbl[fmt];
}
//=================================================================================================
cb_inline
SampleFormat Int32Format()
{
#if defined( cb_little_endian )
	return int32align32lsb;
#elif defined( cb_big_endian )
	return int32align32msb;
#else
#	error	unknown endian
#endif
}
//=================================================================================================
cb_inline
SampleFormat FloatFormat()
{
#if defined( cb_little_endian )
	return float32align32lsb;
#elif defined( cb_big_endian )
	return float32align32msb;
#else
#	error	unknown endian
#endif
}
//=================================================================================================
cb_inline
SampleFormat DoubleFormat()
{
#if defined( cb_little_endian )
	return float64align64lsb;
#elif defined( cb_big_endian )
	return float64align64msb;
#else
#	error	unknown endian
#endif
}
};	//namespace
#pragma pack( pop )			//release align

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"cpp/sb_cpp.h"



#pragma pack( push , 8 )		//set align
namespace icubic_audio
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
// convert
//=================================================================================================
//=================================================================================================
cb_inline
void ConvertFormat
		(
		SampleFormat	src_fmt ,
		const void*		src ,
		SampleFormat	dest_fmt ,
		void*			dest
		)
{
	sb_cpp_convert( src_fmt , src , dest_fmt , dest );
}
//=================================================================================================
cb_inline
void ConvertFormat_cp
		(
		SampleFormat	src_fmt ,
		const void*		src ,
		SampleFormat	dest_fmt ,
		void*			dest
		)
{
	sb_cpp_convert_cp( src_fmt , src , dest_fmt , dest );
}
//=================================================================================================
cb_inline
void ConvertFormat
		(
		int32			samplenum , 
		SampleFormat	src_fmt ,
		const void*		src ,
		SampleFormat	dest_fmt ,
		void*			dest
		)
{
	sb_cpp_convert( src_fmt , src , dest_fmt , dest , samplenum );
}
//=================================================================================================
cb_inline
void ConvertFormat_cp
		(
		int32			samplenum , 
		SampleFormat	src_fmt ,
		const void*		src ,
		SampleFormat	dest_fmt ,
		void*			dest
		)
{
	sb_cpp_convert_cp( src_fmt , src , dest_fmt , dest , samplenum );
}
//=================================================================================================
cb_inline
void InterleaveToMulti
		(
		int					channel , 
		int					samplenum , 
		SampleFormat		src_fmt , 
		const void*			src , 
		SampleFormat		dest_fmt , 
		void**				dest
		)
{
	sb_cpp_interleave_to_multi( channel , samplenum , src_fmt , src , dest_fmt , dest );
}
//=================================================================================================
cb_inline
void MultiToInterleave
		(
		int					channel , 
		int					samplenum , 
		SampleFormat		src_fmt , 
		void const*const*	src , 
		SampleFormat		dest_fmt , 
		void*				dest
		)
{
	sb_cpp_multi_to_interleave( channel , samplenum , src_fmt , src , dest_fmt , dest );
}

};	//namespace

#pragma pack( pop )			//release align
