/*************************************************************************************************/
/*!
   	@file		sb_cpp_interleave.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files




#pragma pack( push , 8 )		//set align

namespace icubic_audio
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define



//=================================================================================================
// interleave_to_multi
//=================================================================================================
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int8align8_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align16msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align24msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int32align32msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float32align32msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_float64align64msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int16align32msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int18align32msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int20align32msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int8align8( psrc , &pdest[choff][ sampleoff * 1 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int16align16lsb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int16align16msb( psrc , &pdest[choff][ sampleoff * 2 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int24align24lsb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int24align24msb( psrc , &pdest[choff][ sampleoff * 3 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_float32align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_float32align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_float64align64lsb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_float64align64msb( psrc , &pdest[choff][ sampleoff * 8 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int16align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int16align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int18align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int18align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int20align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int20align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int24align32lsb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi_int24align32msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		const void*			src , 
		void**				dest
		)
{
	const uint8*	psrc		= (const uint8*)src;
	uint8**			pdest		= (uint8**)dest;
	
	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int24align32msb( psrc , &pdest[choff][ sampleoff * 4 ] );
			psrc += 4;
		}
	}
}

//=================================================================================================
// multi_to_interleave
//=================================================================================================
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int8align8( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int16align16lsb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int16align16msb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int24align24lsb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int24align24msb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int32align32lsb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int32align32msb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_float32align32lsb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_float32align32msb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_float64align64lsb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_float64align64msb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int16align32lsb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int16align32msb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int18align32lsb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int18align32msb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int20align32lsb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int20align32msb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int24align32lsb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int8align8_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int8align8_to_int24align32msb( &psrc[ choff ][ sampleoff * 1 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int8align8( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int16align16msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int24align24msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int32align32msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_float32align32msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_float64align64msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int16align32msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int18align32msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int20align32msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16lsb_to_int24align32msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int8align8( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int16align16msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int24align24msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int32align32msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_float32align32msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_float64align64msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int16align32msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int18align32msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int20align32msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align16msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align16msb_to_int24align32msb( &psrc[ choff ][ sampleoff * 2 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int8align8( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int16align16msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int24align24msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int32align32msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_float32align32msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_float64align64msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int16align32msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int18align32msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int20align32msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24lsb_to_int24align32msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int8align8( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int16align16msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int24align24msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int32align32msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_float32align32msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_float64align64msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int16align32msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int18align32msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int20align32msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align24msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align24msb_to_int24align32msb( &psrc[ choff ][ sampleoff * 3 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int8align8( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int16align16msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int24align24msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_float32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_float64align64msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int16align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int18align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int20align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32lsb_to_int24align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int8align8( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int16align16msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int24align24msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_float32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_float64align64msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int16align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int18align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int20align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int32align32msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int32align32msb_to_int24align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int8align8( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int16align16msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int24align24msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_float32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_float64align64msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int16align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int18align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int20align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32lsb_to_int24align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int8align8( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int16align16msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int24align24msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_float32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_float64align64msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int16align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int18align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int20align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float32align32msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float32align32msb_to_int24align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int8align8( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int16align16msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int24align24msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int32align32msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_float32align32msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_float64align64msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int16align32msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int18align32msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int20align32msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64lsb_to_int24align32msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int8align8( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int16align16msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int24align24msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int32align32msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_float32align32msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_float64align64msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int16align32msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int18align32msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int20align32msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_float64align64msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_float64align64msb_to_int24align32msb( &psrc[ choff ][ sampleoff * 8 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int8align8( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int16align16msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int24align24msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_float32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_float64align64msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int16align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int18align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int20align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32lsb_to_int24align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int8align8( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int16align16msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int24align24msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_float32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_float64align64msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int16align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int18align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int20align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int16align32msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int16align32msb_to_int24align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int8align8( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int16align16msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int24align24msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_float32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_float64align64msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int16align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int18align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int20align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32lsb_to_int24align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int8align8( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int16align16msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int24align24msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_float32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_float64align64msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int16align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int18align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int20align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int18align32msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int18align32msb_to_int24align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int8align8( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int16align16msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int24align24msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_float32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_float64align64msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int16align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int18align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int20align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32lsb_to_int24align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int8align8( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int16align16msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int24align24msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_float32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_float64align64msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int16align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int18align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int20align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int20align32msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int20align32msb_to_int24align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int8align8( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int16align16msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int24align24msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_float32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_float64align64msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int16align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int18align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int20align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32lsb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32lsb_to_int24align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int8align8
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int8align8( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 1;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int16align16lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int16align16lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int16align16msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int16align16msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 2;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int24align24lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int24align24lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int24align24msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int24align24msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 3;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_float32align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_float32align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_float32align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_float32align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_float64align64lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_float64align64lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_float64align64msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_float64align64msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 8;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int16align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int16align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int16align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int16align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int18align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int18align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int18align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int18align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int20align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int20align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int20align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int20align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int24align32lsb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int24align32lsb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave_int24align32msb_int24align32msb
		(
		int					channel , 
		int					samplenum , 
		void const*const*	src , 
		void*				dest
		)
{
	uint8 const*const*	psrc		= (uint8 const*const*)src;
	uint8*				pdest		= (uint8*)dest;

	int	sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		int	choff;
		for( choff = 0 ; choff < channel ; choff++ )
		{
			sb_cpp_convert_int24align32msb_to_int24align32msb( &psrc[ choff ][ sampleoff * 4 ] , pdest );
			pdest += 4;
		}
	}
}

//=================================================================================================
// interleave_to_multi( format )
//=================================================================================================
//=================================================================================================
cb_inline
void sb_cpp_interleave_to_multi
		(
		int				channel , 
		int				samplenum , 
		SampleFormat	src_fmt ,
		const void*		src , 
		SampleFormat	dest_fmt ,
		void**			dest
		)
{
	typedef void (*func)( int , int , const void* , void** );
	static
	const func	funclist[SampleFormatNum][SampleFormatNum] = 
	{
		{
			sb_cpp_interleave_to_multi_int8align8_int8align8 , 
			sb_cpp_interleave_to_multi_int8align8_int16align16lsb , 
			sb_cpp_interleave_to_multi_int8align8_int16align16msb , 
			sb_cpp_interleave_to_multi_int8align8_int24align24lsb , 
			sb_cpp_interleave_to_multi_int8align8_int24align24msb , 
			sb_cpp_interleave_to_multi_int8align8_int32align32lsb , 
			sb_cpp_interleave_to_multi_int8align8_int32align32msb , 
			sb_cpp_interleave_to_multi_int8align8_float32align32lsb , 
			sb_cpp_interleave_to_multi_int8align8_float32align32msb , 
			sb_cpp_interleave_to_multi_int8align8_float64align64lsb , 
			sb_cpp_interleave_to_multi_int8align8_float64align64msb , 
			sb_cpp_interleave_to_multi_int8align8_int16align32lsb , 
			sb_cpp_interleave_to_multi_int8align8_int16align32msb , 
			sb_cpp_interleave_to_multi_int8align8_int18align32lsb , 
			sb_cpp_interleave_to_multi_int8align8_int18align32msb , 
			sb_cpp_interleave_to_multi_int8align8_int20align32lsb , 
			sb_cpp_interleave_to_multi_int8align8_int20align32msb , 
			sb_cpp_interleave_to_multi_int8align8_int24align32lsb , 
			sb_cpp_interleave_to_multi_int8align8_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int16align16lsb_int8align8 , 
			sb_cpp_interleave_to_multi_int16align16lsb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int16align16msb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int24align24msb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int32align32msb , 
			sb_cpp_interleave_to_multi_int16align16lsb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int16align16lsb_float32align32msb , 
			sb_cpp_interleave_to_multi_int16align16lsb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int16align16lsb_float64align64msb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int16align32msb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int18align32msb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int20align32msb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int16align16lsb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int16align16msb_int8align8 , 
			sb_cpp_interleave_to_multi_int16align16msb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int16align16msb_int16align16msb , 
			sb_cpp_interleave_to_multi_int16align16msb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int16align16msb_int24align24msb , 
			sb_cpp_interleave_to_multi_int16align16msb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int16align16msb_int32align32msb , 
			sb_cpp_interleave_to_multi_int16align16msb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int16align16msb_float32align32msb , 
			sb_cpp_interleave_to_multi_int16align16msb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int16align16msb_float64align64msb , 
			sb_cpp_interleave_to_multi_int16align16msb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int16align16msb_int16align32msb , 
			sb_cpp_interleave_to_multi_int16align16msb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int16align16msb_int18align32msb , 
			sb_cpp_interleave_to_multi_int16align16msb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int16align16msb_int20align32msb , 
			sb_cpp_interleave_to_multi_int16align16msb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int16align16msb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int24align24lsb_int8align8 , 
			sb_cpp_interleave_to_multi_int24align24lsb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int16align16msb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int24align24msb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int32align32msb , 
			sb_cpp_interleave_to_multi_int24align24lsb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int24align24lsb_float32align32msb , 
			sb_cpp_interleave_to_multi_int24align24lsb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int24align24lsb_float64align64msb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int16align32msb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int18align32msb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int20align32msb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int24align24lsb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int24align24msb_int8align8 , 
			sb_cpp_interleave_to_multi_int24align24msb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int24align24msb_int16align16msb , 
			sb_cpp_interleave_to_multi_int24align24msb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int24align24msb_int24align24msb , 
			sb_cpp_interleave_to_multi_int24align24msb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int24align24msb_int32align32msb , 
			sb_cpp_interleave_to_multi_int24align24msb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int24align24msb_float32align32msb , 
			sb_cpp_interleave_to_multi_int24align24msb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int24align24msb_float64align64msb , 
			sb_cpp_interleave_to_multi_int24align24msb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int24align24msb_int16align32msb , 
			sb_cpp_interleave_to_multi_int24align24msb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int24align24msb_int18align32msb , 
			sb_cpp_interleave_to_multi_int24align24msb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int24align24msb_int20align32msb , 
			sb_cpp_interleave_to_multi_int24align24msb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int24align24msb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int32align32lsb_int8align8 , 
			sb_cpp_interleave_to_multi_int32align32lsb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int16align16msb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int24align24msb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int32align32msb , 
			sb_cpp_interleave_to_multi_int32align32lsb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int32align32lsb_float32align32msb , 
			sb_cpp_interleave_to_multi_int32align32lsb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int32align32lsb_float64align64msb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int16align32msb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int18align32msb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int20align32msb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int32align32lsb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int32align32msb_int8align8 , 
			sb_cpp_interleave_to_multi_int32align32msb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int32align32msb_int16align16msb , 
			sb_cpp_interleave_to_multi_int32align32msb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int32align32msb_int24align24msb , 
			sb_cpp_interleave_to_multi_int32align32msb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int32align32msb_int32align32msb , 
			sb_cpp_interleave_to_multi_int32align32msb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int32align32msb_float32align32msb , 
			sb_cpp_interleave_to_multi_int32align32msb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int32align32msb_float64align64msb , 
			sb_cpp_interleave_to_multi_int32align32msb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int32align32msb_int16align32msb , 
			sb_cpp_interleave_to_multi_int32align32msb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int32align32msb_int18align32msb , 
			sb_cpp_interleave_to_multi_int32align32msb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int32align32msb_int20align32msb , 
			sb_cpp_interleave_to_multi_int32align32msb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int32align32msb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_float32align32lsb_int8align8 , 
			sb_cpp_interleave_to_multi_float32align32lsb_int16align16lsb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int16align16msb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int24align24lsb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int24align24msb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int32align32lsb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int32align32msb , 
			sb_cpp_interleave_to_multi_float32align32lsb_float32align32lsb , 
			sb_cpp_interleave_to_multi_float32align32lsb_float32align32msb , 
			sb_cpp_interleave_to_multi_float32align32lsb_float64align64lsb , 
			sb_cpp_interleave_to_multi_float32align32lsb_float64align64msb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int16align32lsb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int16align32msb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int18align32lsb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int18align32msb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int20align32lsb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int20align32msb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int24align32lsb , 
			sb_cpp_interleave_to_multi_float32align32lsb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_float32align32msb_int8align8 , 
			sb_cpp_interleave_to_multi_float32align32msb_int16align16lsb , 
			sb_cpp_interleave_to_multi_float32align32msb_int16align16msb , 
			sb_cpp_interleave_to_multi_float32align32msb_int24align24lsb , 
			sb_cpp_interleave_to_multi_float32align32msb_int24align24msb , 
			sb_cpp_interleave_to_multi_float32align32msb_int32align32lsb , 
			sb_cpp_interleave_to_multi_float32align32msb_int32align32msb , 
			sb_cpp_interleave_to_multi_float32align32msb_float32align32lsb , 
			sb_cpp_interleave_to_multi_float32align32msb_float32align32msb , 
			sb_cpp_interleave_to_multi_float32align32msb_float64align64lsb , 
			sb_cpp_interleave_to_multi_float32align32msb_float64align64msb , 
			sb_cpp_interleave_to_multi_float32align32msb_int16align32lsb , 
			sb_cpp_interleave_to_multi_float32align32msb_int16align32msb , 
			sb_cpp_interleave_to_multi_float32align32msb_int18align32lsb , 
			sb_cpp_interleave_to_multi_float32align32msb_int18align32msb , 
			sb_cpp_interleave_to_multi_float32align32msb_int20align32lsb , 
			sb_cpp_interleave_to_multi_float32align32msb_int20align32msb , 
			sb_cpp_interleave_to_multi_float32align32msb_int24align32lsb , 
			sb_cpp_interleave_to_multi_float32align32msb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_float64align64lsb_int8align8 , 
			sb_cpp_interleave_to_multi_float64align64lsb_int16align16lsb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int16align16msb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int24align24lsb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int24align24msb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int32align32lsb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int32align32msb , 
			sb_cpp_interleave_to_multi_float64align64lsb_float32align32lsb , 
			sb_cpp_interleave_to_multi_float64align64lsb_float32align32msb , 
			sb_cpp_interleave_to_multi_float64align64lsb_float64align64lsb , 
			sb_cpp_interleave_to_multi_float64align64lsb_float64align64msb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int16align32lsb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int16align32msb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int18align32lsb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int18align32msb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int20align32lsb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int20align32msb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int24align32lsb , 
			sb_cpp_interleave_to_multi_float64align64lsb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_float64align64msb_int8align8 , 
			sb_cpp_interleave_to_multi_float64align64msb_int16align16lsb , 
			sb_cpp_interleave_to_multi_float64align64msb_int16align16msb , 
			sb_cpp_interleave_to_multi_float64align64msb_int24align24lsb , 
			sb_cpp_interleave_to_multi_float64align64msb_int24align24msb , 
			sb_cpp_interleave_to_multi_float64align64msb_int32align32lsb , 
			sb_cpp_interleave_to_multi_float64align64msb_int32align32msb , 
			sb_cpp_interleave_to_multi_float64align64msb_float32align32lsb , 
			sb_cpp_interleave_to_multi_float64align64msb_float32align32msb , 
			sb_cpp_interleave_to_multi_float64align64msb_float64align64lsb , 
			sb_cpp_interleave_to_multi_float64align64msb_float64align64msb , 
			sb_cpp_interleave_to_multi_float64align64msb_int16align32lsb , 
			sb_cpp_interleave_to_multi_float64align64msb_int16align32msb , 
			sb_cpp_interleave_to_multi_float64align64msb_int18align32lsb , 
			sb_cpp_interleave_to_multi_float64align64msb_int18align32msb , 
			sb_cpp_interleave_to_multi_float64align64msb_int20align32lsb , 
			sb_cpp_interleave_to_multi_float64align64msb_int20align32msb , 
			sb_cpp_interleave_to_multi_float64align64msb_int24align32lsb , 
			sb_cpp_interleave_to_multi_float64align64msb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int16align32lsb_int8align8 , 
			sb_cpp_interleave_to_multi_int16align32lsb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int16align16msb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int24align24msb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int32align32msb , 
			sb_cpp_interleave_to_multi_int16align32lsb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int16align32lsb_float32align32msb , 
			sb_cpp_interleave_to_multi_int16align32lsb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int16align32lsb_float64align64msb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int16align32msb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int18align32msb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int20align32msb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int16align32lsb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int16align32msb_int8align8 , 
			sb_cpp_interleave_to_multi_int16align32msb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int16align32msb_int16align16msb , 
			sb_cpp_interleave_to_multi_int16align32msb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int16align32msb_int24align24msb , 
			sb_cpp_interleave_to_multi_int16align32msb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int16align32msb_int32align32msb , 
			sb_cpp_interleave_to_multi_int16align32msb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int16align32msb_float32align32msb , 
			sb_cpp_interleave_to_multi_int16align32msb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int16align32msb_float64align64msb , 
			sb_cpp_interleave_to_multi_int16align32msb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int16align32msb_int16align32msb , 
			sb_cpp_interleave_to_multi_int16align32msb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int16align32msb_int18align32msb , 
			sb_cpp_interleave_to_multi_int16align32msb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int16align32msb_int20align32msb , 
			sb_cpp_interleave_to_multi_int16align32msb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int16align32msb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int18align32lsb_int8align8 , 
			sb_cpp_interleave_to_multi_int18align32lsb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int16align16msb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int24align24msb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int32align32msb , 
			sb_cpp_interleave_to_multi_int18align32lsb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int18align32lsb_float32align32msb , 
			sb_cpp_interleave_to_multi_int18align32lsb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int18align32lsb_float64align64msb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int16align32msb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int18align32msb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int20align32msb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int18align32lsb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int18align32msb_int8align8 , 
			sb_cpp_interleave_to_multi_int18align32msb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int18align32msb_int16align16msb , 
			sb_cpp_interleave_to_multi_int18align32msb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int18align32msb_int24align24msb , 
			sb_cpp_interleave_to_multi_int18align32msb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int18align32msb_int32align32msb , 
			sb_cpp_interleave_to_multi_int18align32msb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int18align32msb_float32align32msb , 
			sb_cpp_interleave_to_multi_int18align32msb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int18align32msb_float64align64msb , 
			sb_cpp_interleave_to_multi_int18align32msb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int18align32msb_int16align32msb , 
			sb_cpp_interleave_to_multi_int18align32msb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int18align32msb_int18align32msb , 
			sb_cpp_interleave_to_multi_int18align32msb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int18align32msb_int20align32msb , 
			sb_cpp_interleave_to_multi_int18align32msb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int18align32msb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int20align32lsb_int8align8 , 
			sb_cpp_interleave_to_multi_int20align32lsb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int16align16msb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int24align24msb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int32align32msb , 
			sb_cpp_interleave_to_multi_int20align32lsb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int20align32lsb_float32align32msb , 
			sb_cpp_interleave_to_multi_int20align32lsb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int20align32lsb_float64align64msb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int16align32msb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int18align32msb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int20align32msb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int20align32lsb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int20align32msb_int8align8 , 
			sb_cpp_interleave_to_multi_int20align32msb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int20align32msb_int16align16msb , 
			sb_cpp_interleave_to_multi_int20align32msb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int20align32msb_int24align24msb , 
			sb_cpp_interleave_to_multi_int20align32msb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int20align32msb_int32align32msb , 
			sb_cpp_interleave_to_multi_int20align32msb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int20align32msb_float32align32msb , 
			sb_cpp_interleave_to_multi_int20align32msb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int20align32msb_float64align64msb , 
			sb_cpp_interleave_to_multi_int20align32msb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int20align32msb_int16align32msb , 
			sb_cpp_interleave_to_multi_int20align32msb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int20align32msb_int18align32msb , 
			sb_cpp_interleave_to_multi_int20align32msb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int20align32msb_int20align32msb , 
			sb_cpp_interleave_to_multi_int20align32msb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int20align32msb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int24align32lsb_int8align8 , 
			sb_cpp_interleave_to_multi_int24align32lsb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int16align16msb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int24align24msb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int32align32msb , 
			sb_cpp_interleave_to_multi_int24align32lsb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int24align32lsb_float32align32msb , 
			sb_cpp_interleave_to_multi_int24align32lsb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int24align32lsb_float64align64msb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int16align32msb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int18align32msb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int20align32msb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int24align32lsb_int24align32msb , 
		} , 
		{
			sb_cpp_interleave_to_multi_int24align32msb_int8align8 , 
			sb_cpp_interleave_to_multi_int24align32msb_int16align16lsb , 
			sb_cpp_interleave_to_multi_int24align32msb_int16align16msb , 
			sb_cpp_interleave_to_multi_int24align32msb_int24align24lsb , 
			sb_cpp_interleave_to_multi_int24align32msb_int24align24msb , 
			sb_cpp_interleave_to_multi_int24align32msb_int32align32lsb , 
			sb_cpp_interleave_to_multi_int24align32msb_int32align32msb , 
			sb_cpp_interleave_to_multi_int24align32msb_float32align32lsb , 
			sb_cpp_interleave_to_multi_int24align32msb_float32align32msb , 
			sb_cpp_interleave_to_multi_int24align32msb_float64align64lsb , 
			sb_cpp_interleave_to_multi_int24align32msb_float64align64msb , 
			sb_cpp_interleave_to_multi_int24align32msb_int16align32lsb , 
			sb_cpp_interleave_to_multi_int24align32msb_int16align32msb , 
			sb_cpp_interleave_to_multi_int24align32msb_int18align32lsb , 
			sb_cpp_interleave_to_multi_int24align32msb_int18align32msb , 
			sb_cpp_interleave_to_multi_int24align32msb_int20align32lsb , 
			sb_cpp_interleave_to_multi_int24align32msb_int20align32msb , 
			sb_cpp_interleave_to_multi_int24align32msb_int24align32lsb , 
			sb_cpp_interleave_to_multi_int24align32msb_int24align32msb , 
		} , 
	};
	( funclist[ src_fmt ][ dest_fmt ] )( channel , samplenum , src , dest );
}

//=================================================================================================
// interleave_to_multi( format )
//=================================================================================================
//=================================================================================================
cb_inline
void sb_cpp_multi_to_interleave
		(
		int					channel , 
		int					samplenum , 
		SampleFormat		src_fmt ,
		void const*const*	src , 
		SampleFormat		dest_fmt ,
		void*				dest
		)
{
	typedef void (*func)( int , int , void const*const* , void* );
	static
	const func	funclist[SampleFormatNum][SampleFormatNum] = 
	{
		{
			sb_cpp_multi_to_interleave_int8align8_int8align8 , 
			sb_cpp_multi_to_interleave_int8align8_int16align16lsb , 
			sb_cpp_multi_to_interleave_int8align8_int16align16msb , 
			sb_cpp_multi_to_interleave_int8align8_int24align24lsb , 
			sb_cpp_multi_to_interleave_int8align8_int24align24msb , 
			sb_cpp_multi_to_interleave_int8align8_int32align32lsb , 
			sb_cpp_multi_to_interleave_int8align8_int32align32msb , 
			sb_cpp_multi_to_interleave_int8align8_float32align32lsb , 
			sb_cpp_multi_to_interleave_int8align8_float32align32msb , 
			sb_cpp_multi_to_interleave_int8align8_float64align64lsb , 
			sb_cpp_multi_to_interleave_int8align8_float64align64msb , 
			sb_cpp_multi_to_interleave_int8align8_int16align32lsb , 
			sb_cpp_multi_to_interleave_int8align8_int16align32msb , 
			sb_cpp_multi_to_interleave_int8align8_int18align32lsb , 
			sb_cpp_multi_to_interleave_int8align8_int18align32msb , 
			sb_cpp_multi_to_interleave_int8align8_int20align32lsb , 
			sb_cpp_multi_to_interleave_int8align8_int20align32msb , 
			sb_cpp_multi_to_interleave_int8align8_int24align32lsb , 
			sb_cpp_multi_to_interleave_int8align8_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int16align16lsb_int8align8 , 
			sb_cpp_multi_to_interleave_int16align16lsb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int16align16msb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int24align24msb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int32align32msb , 
			sb_cpp_multi_to_interleave_int16align16lsb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int16align16lsb_float32align32msb , 
			sb_cpp_multi_to_interleave_int16align16lsb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int16align16lsb_float64align64msb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int16align32msb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int18align32msb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int20align32msb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int16align16lsb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int16align16msb_int8align8 , 
			sb_cpp_multi_to_interleave_int16align16msb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int16align16msb_int16align16msb , 
			sb_cpp_multi_to_interleave_int16align16msb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int16align16msb_int24align24msb , 
			sb_cpp_multi_to_interleave_int16align16msb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int16align16msb_int32align32msb , 
			sb_cpp_multi_to_interleave_int16align16msb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int16align16msb_float32align32msb , 
			sb_cpp_multi_to_interleave_int16align16msb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int16align16msb_float64align64msb , 
			sb_cpp_multi_to_interleave_int16align16msb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int16align16msb_int16align32msb , 
			sb_cpp_multi_to_interleave_int16align16msb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int16align16msb_int18align32msb , 
			sb_cpp_multi_to_interleave_int16align16msb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int16align16msb_int20align32msb , 
			sb_cpp_multi_to_interleave_int16align16msb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int16align16msb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int24align24lsb_int8align8 , 
			sb_cpp_multi_to_interleave_int24align24lsb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int16align16msb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int24align24msb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int32align32msb , 
			sb_cpp_multi_to_interleave_int24align24lsb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int24align24lsb_float32align32msb , 
			sb_cpp_multi_to_interleave_int24align24lsb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int24align24lsb_float64align64msb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int16align32msb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int18align32msb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int20align32msb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int24align24lsb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int24align24msb_int8align8 , 
			sb_cpp_multi_to_interleave_int24align24msb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int24align24msb_int16align16msb , 
			sb_cpp_multi_to_interleave_int24align24msb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int24align24msb_int24align24msb , 
			sb_cpp_multi_to_interleave_int24align24msb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int24align24msb_int32align32msb , 
			sb_cpp_multi_to_interleave_int24align24msb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int24align24msb_float32align32msb , 
			sb_cpp_multi_to_interleave_int24align24msb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int24align24msb_float64align64msb , 
			sb_cpp_multi_to_interleave_int24align24msb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int24align24msb_int16align32msb , 
			sb_cpp_multi_to_interleave_int24align24msb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int24align24msb_int18align32msb , 
			sb_cpp_multi_to_interleave_int24align24msb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int24align24msb_int20align32msb , 
			sb_cpp_multi_to_interleave_int24align24msb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int24align24msb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int32align32lsb_int8align8 , 
			sb_cpp_multi_to_interleave_int32align32lsb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int16align16msb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int24align24msb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int32align32msb , 
			sb_cpp_multi_to_interleave_int32align32lsb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int32align32lsb_float32align32msb , 
			sb_cpp_multi_to_interleave_int32align32lsb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int32align32lsb_float64align64msb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int16align32msb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int18align32msb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int20align32msb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int32align32lsb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int32align32msb_int8align8 , 
			sb_cpp_multi_to_interleave_int32align32msb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int32align32msb_int16align16msb , 
			sb_cpp_multi_to_interleave_int32align32msb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int32align32msb_int24align24msb , 
			sb_cpp_multi_to_interleave_int32align32msb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int32align32msb_int32align32msb , 
			sb_cpp_multi_to_interleave_int32align32msb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int32align32msb_float32align32msb , 
			sb_cpp_multi_to_interleave_int32align32msb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int32align32msb_float64align64msb , 
			sb_cpp_multi_to_interleave_int32align32msb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int32align32msb_int16align32msb , 
			sb_cpp_multi_to_interleave_int32align32msb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int32align32msb_int18align32msb , 
			sb_cpp_multi_to_interleave_int32align32msb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int32align32msb_int20align32msb , 
			sb_cpp_multi_to_interleave_int32align32msb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int32align32msb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_float32align32lsb_int8align8 , 
			sb_cpp_multi_to_interleave_float32align32lsb_int16align16lsb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int16align16msb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int24align24lsb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int24align24msb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int32align32lsb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int32align32msb , 
			sb_cpp_multi_to_interleave_float32align32lsb_float32align32lsb , 
			sb_cpp_multi_to_interleave_float32align32lsb_float32align32msb , 
			sb_cpp_multi_to_interleave_float32align32lsb_float64align64lsb , 
			sb_cpp_multi_to_interleave_float32align32lsb_float64align64msb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int16align32lsb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int16align32msb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int18align32lsb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int18align32msb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int20align32lsb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int20align32msb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int24align32lsb , 
			sb_cpp_multi_to_interleave_float32align32lsb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_float32align32msb_int8align8 , 
			sb_cpp_multi_to_interleave_float32align32msb_int16align16lsb , 
			sb_cpp_multi_to_interleave_float32align32msb_int16align16msb , 
			sb_cpp_multi_to_interleave_float32align32msb_int24align24lsb , 
			sb_cpp_multi_to_interleave_float32align32msb_int24align24msb , 
			sb_cpp_multi_to_interleave_float32align32msb_int32align32lsb , 
			sb_cpp_multi_to_interleave_float32align32msb_int32align32msb , 
			sb_cpp_multi_to_interleave_float32align32msb_float32align32lsb , 
			sb_cpp_multi_to_interleave_float32align32msb_float32align32msb , 
			sb_cpp_multi_to_interleave_float32align32msb_float64align64lsb , 
			sb_cpp_multi_to_interleave_float32align32msb_float64align64msb , 
			sb_cpp_multi_to_interleave_float32align32msb_int16align32lsb , 
			sb_cpp_multi_to_interleave_float32align32msb_int16align32msb , 
			sb_cpp_multi_to_interleave_float32align32msb_int18align32lsb , 
			sb_cpp_multi_to_interleave_float32align32msb_int18align32msb , 
			sb_cpp_multi_to_interleave_float32align32msb_int20align32lsb , 
			sb_cpp_multi_to_interleave_float32align32msb_int20align32msb , 
			sb_cpp_multi_to_interleave_float32align32msb_int24align32lsb , 
			sb_cpp_multi_to_interleave_float32align32msb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_float64align64lsb_int8align8 , 
			sb_cpp_multi_to_interleave_float64align64lsb_int16align16lsb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int16align16msb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int24align24lsb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int24align24msb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int32align32lsb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int32align32msb , 
			sb_cpp_multi_to_interleave_float64align64lsb_float32align32lsb , 
			sb_cpp_multi_to_interleave_float64align64lsb_float32align32msb , 
			sb_cpp_multi_to_interleave_float64align64lsb_float64align64lsb , 
			sb_cpp_multi_to_interleave_float64align64lsb_float64align64msb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int16align32lsb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int16align32msb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int18align32lsb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int18align32msb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int20align32lsb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int20align32msb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int24align32lsb , 
			sb_cpp_multi_to_interleave_float64align64lsb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_float64align64msb_int8align8 , 
			sb_cpp_multi_to_interleave_float64align64msb_int16align16lsb , 
			sb_cpp_multi_to_interleave_float64align64msb_int16align16msb , 
			sb_cpp_multi_to_interleave_float64align64msb_int24align24lsb , 
			sb_cpp_multi_to_interleave_float64align64msb_int24align24msb , 
			sb_cpp_multi_to_interleave_float64align64msb_int32align32lsb , 
			sb_cpp_multi_to_interleave_float64align64msb_int32align32msb , 
			sb_cpp_multi_to_interleave_float64align64msb_float32align32lsb , 
			sb_cpp_multi_to_interleave_float64align64msb_float32align32msb , 
			sb_cpp_multi_to_interleave_float64align64msb_float64align64lsb , 
			sb_cpp_multi_to_interleave_float64align64msb_float64align64msb , 
			sb_cpp_multi_to_interleave_float64align64msb_int16align32lsb , 
			sb_cpp_multi_to_interleave_float64align64msb_int16align32msb , 
			sb_cpp_multi_to_interleave_float64align64msb_int18align32lsb , 
			sb_cpp_multi_to_interleave_float64align64msb_int18align32msb , 
			sb_cpp_multi_to_interleave_float64align64msb_int20align32lsb , 
			sb_cpp_multi_to_interleave_float64align64msb_int20align32msb , 
			sb_cpp_multi_to_interleave_float64align64msb_int24align32lsb , 
			sb_cpp_multi_to_interleave_float64align64msb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int16align32lsb_int8align8 , 
			sb_cpp_multi_to_interleave_int16align32lsb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int16align16msb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int24align24msb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int32align32msb , 
			sb_cpp_multi_to_interleave_int16align32lsb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int16align32lsb_float32align32msb , 
			sb_cpp_multi_to_interleave_int16align32lsb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int16align32lsb_float64align64msb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int16align32msb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int18align32msb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int20align32msb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int16align32lsb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int16align32msb_int8align8 , 
			sb_cpp_multi_to_interleave_int16align32msb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int16align32msb_int16align16msb , 
			sb_cpp_multi_to_interleave_int16align32msb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int16align32msb_int24align24msb , 
			sb_cpp_multi_to_interleave_int16align32msb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int16align32msb_int32align32msb , 
			sb_cpp_multi_to_interleave_int16align32msb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int16align32msb_float32align32msb , 
			sb_cpp_multi_to_interleave_int16align32msb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int16align32msb_float64align64msb , 
			sb_cpp_multi_to_interleave_int16align32msb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int16align32msb_int16align32msb , 
			sb_cpp_multi_to_interleave_int16align32msb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int16align32msb_int18align32msb , 
			sb_cpp_multi_to_interleave_int16align32msb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int16align32msb_int20align32msb , 
			sb_cpp_multi_to_interleave_int16align32msb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int16align32msb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int18align32lsb_int8align8 , 
			sb_cpp_multi_to_interleave_int18align32lsb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int16align16msb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int24align24msb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int32align32msb , 
			sb_cpp_multi_to_interleave_int18align32lsb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int18align32lsb_float32align32msb , 
			sb_cpp_multi_to_interleave_int18align32lsb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int18align32lsb_float64align64msb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int16align32msb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int18align32msb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int20align32msb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int18align32lsb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int18align32msb_int8align8 , 
			sb_cpp_multi_to_interleave_int18align32msb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int18align32msb_int16align16msb , 
			sb_cpp_multi_to_interleave_int18align32msb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int18align32msb_int24align24msb , 
			sb_cpp_multi_to_interleave_int18align32msb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int18align32msb_int32align32msb , 
			sb_cpp_multi_to_interleave_int18align32msb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int18align32msb_float32align32msb , 
			sb_cpp_multi_to_interleave_int18align32msb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int18align32msb_float64align64msb , 
			sb_cpp_multi_to_interleave_int18align32msb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int18align32msb_int16align32msb , 
			sb_cpp_multi_to_interleave_int18align32msb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int18align32msb_int18align32msb , 
			sb_cpp_multi_to_interleave_int18align32msb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int18align32msb_int20align32msb , 
			sb_cpp_multi_to_interleave_int18align32msb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int18align32msb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int20align32lsb_int8align8 , 
			sb_cpp_multi_to_interleave_int20align32lsb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int16align16msb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int24align24msb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int32align32msb , 
			sb_cpp_multi_to_interleave_int20align32lsb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int20align32lsb_float32align32msb , 
			sb_cpp_multi_to_interleave_int20align32lsb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int20align32lsb_float64align64msb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int16align32msb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int18align32msb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int20align32msb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int20align32lsb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int20align32msb_int8align8 , 
			sb_cpp_multi_to_interleave_int20align32msb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int20align32msb_int16align16msb , 
			sb_cpp_multi_to_interleave_int20align32msb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int20align32msb_int24align24msb , 
			sb_cpp_multi_to_interleave_int20align32msb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int20align32msb_int32align32msb , 
			sb_cpp_multi_to_interleave_int20align32msb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int20align32msb_float32align32msb , 
			sb_cpp_multi_to_interleave_int20align32msb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int20align32msb_float64align64msb , 
			sb_cpp_multi_to_interleave_int20align32msb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int20align32msb_int16align32msb , 
			sb_cpp_multi_to_interleave_int20align32msb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int20align32msb_int18align32msb , 
			sb_cpp_multi_to_interleave_int20align32msb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int20align32msb_int20align32msb , 
			sb_cpp_multi_to_interleave_int20align32msb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int20align32msb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int24align32lsb_int8align8 , 
			sb_cpp_multi_to_interleave_int24align32lsb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int16align16msb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int24align24msb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int32align32msb , 
			sb_cpp_multi_to_interleave_int24align32lsb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int24align32lsb_float32align32msb , 
			sb_cpp_multi_to_interleave_int24align32lsb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int24align32lsb_float64align64msb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int16align32msb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int18align32msb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int20align32msb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int24align32lsb_int24align32msb , 
		} , 
		{
			sb_cpp_multi_to_interleave_int24align32msb_int8align8 , 
			sb_cpp_multi_to_interleave_int24align32msb_int16align16lsb , 
			sb_cpp_multi_to_interleave_int24align32msb_int16align16msb , 
			sb_cpp_multi_to_interleave_int24align32msb_int24align24lsb , 
			sb_cpp_multi_to_interleave_int24align32msb_int24align24msb , 
			sb_cpp_multi_to_interleave_int24align32msb_int32align32lsb , 
			sb_cpp_multi_to_interleave_int24align32msb_int32align32msb , 
			sb_cpp_multi_to_interleave_int24align32msb_float32align32lsb , 
			sb_cpp_multi_to_interleave_int24align32msb_float32align32msb , 
			sb_cpp_multi_to_interleave_int24align32msb_float64align64lsb , 
			sb_cpp_multi_to_interleave_int24align32msb_float64align64msb , 
			sb_cpp_multi_to_interleave_int24align32msb_int16align32lsb , 
			sb_cpp_multi_to_interleave_int24align32msb_int16align32msb , 
			sb_cpp_multi_to_interleave_int24align32msb_int18align32lsb , 
			sb_cpp_multi_to_interleave_int24align32msb_int18align32msb , 
			sb_cpp_multi_to_interleave_int24align32msb_int20align32lsb , 
			sb_cpp_multi_to_interleave_int24align32msb_int20align32msb , 
			sb_cpp_multi_to_interleave_int24align32msb_int24align32lsb , 
			sb_cpp_multi_to_interleave_int24align32msb_int24align32msb , 
		} , 
	};
	( funclist[ src_fmt ][ dest_fmt ] )( channel , samplenum , src , dest );
}


};	//namespace

#pragma pack( pop )			//release align
