/*************************************************************************************************/
/*!
   	@file		sb_cpp_convert_ary.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files




#pragma pack( push , 8 )		//set align

namespace icubic_audio
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
// convert
//=================================================================================================




//=================================================================================================
// convert
//=================================================================================================
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 1 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int16align16lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int16align16msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int24align24lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int24align24msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int32align32lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int32align32msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_float32align32lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_float32align32msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_float64align64lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_float64align64msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int16align32lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int16align32msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int18align32lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int18align32msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int20align32lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int20align32msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int24align32lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int8align8_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int8align8_to_int24align32msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int8align8( psrc , pdest );
		psrc	+= 2;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 2 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int8align8( psrc , pdest );
		psrc	+= 2;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 2 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int24align24msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int32align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_float32align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_float64align64msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int16align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int18align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int20align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align16msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align16msb_to_int24align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int8align8( psrc , pdest );
		psrc	+= 3;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 3 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int8align8( psrc , pdest );
		psrc	+= 3;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int16align16msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 3 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int32align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_float32align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_float64align64msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int16align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int18align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int20align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align24msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align24msb_to_int24align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 4 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 4 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int32align32msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int32align32msb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 4 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 4 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float32align32msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float32align32msb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int8align8( psrc , pdest );
		psrc	+= 8;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 8 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int8align8( psrc , pdest );
		psrc	+= 8;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int16align16msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int24align24msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int32align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_float32align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 8 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int16align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int18align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int20align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_float64align64msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_float64align64msb_to_int24align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 4 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 4 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int16align32msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int16align32msb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 4 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 4 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int18align32msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int18align32msb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 4 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 4 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int20align32msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int20align32msb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 4 );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_int24align32msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_int24align32msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	MemoryCopy( dest , src , samplenum * 4 );
}

//=================================================================================================
// convert_cp
//=================================================================================================
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int8align8( psrc , pdest );
		psrc	+= 1;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int16align16lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int16align16msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int24align24lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int24align24msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int32align32lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int32align32msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_float32align32lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_float32align32msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_float64align64lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_float64align64msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int16align32lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int16align32msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int18align32lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int18align32msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int20align32lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int20align32msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int24align32lsb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int8align8_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int8align8_to_int24align32msb( psrc , pdest );
		psrc	+= 1;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int8align8( psrc , pdest );
		psrc	+= 2;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int8align8( psrc , pdest );
		psrc	+= 2;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int16align16msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int24align24msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int32align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_float32align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_float64align64msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int16align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int18align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int20align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align16msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align16msb_to_int24align32msb( psrc , pdest );
		psrc	+= 2;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int8align8( psrc , pdest );
		psrc	+= 3;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int8align8( psrc , pdest );
		psrc	+= 3;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int16align16msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int24align24msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int32align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_float32align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_float64align64msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int16align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int18align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int20align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align24msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align24msb_to_int24align32msb( psrc , pdest );
		psrc	+= 3;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int32align32msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int32align32msb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float32align32msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float32align32msb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int8align8( psrc , pdest );
		psrc	+= 8;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int8align8( psrc , pdest );
		psrc	+= 8;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int16align16msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int24align24msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int32align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_float32align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_float64align64msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int16align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int18align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int20align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_float64align64msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_float64align64msb_to_int24align32msb( psrc , pdest );
		psrc	+= 8;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int16align32msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int16align32msb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int18align32msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int18align32msb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int20align32msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int20align32msb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32lsb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32lsb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int8align8
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int8align8( psrc , pdest );
		psrc	+= 4;
		pdest	+= 1;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int16align16lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int16align16lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int16align16msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int16align16msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 2;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int24align24lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int24align24lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int24align24msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int24align24msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 3;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_float32align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_float32align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_float32align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_float32align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_float64align64lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_float64align64lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_float64align64msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_float64align64msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 8;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int16align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int16align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int16align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int16align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int18align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int18align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int18align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int18align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int20align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int20align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int20align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int20align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int24align32lsb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int24align32lsb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp_int24align32msb_to_int24align32msb
		(
		const void*		src ,
		void*			dest ,
		int32			samplenum
		)
{
	const uint8*	psrc	= (const uint8*)src;
	uint8*			pdest	= (uint8*)dest;
	int32			sampleoff;
	for( sampleoff = 0 ; sampleoff < samplenum ; sampleoff++ )
	{
		sb_cpp_convert_cp_int24align32msb_to_int24align32msb( psrc , pdest );
		psrc	+= 4;
		pdest	+= 4;
	}
}

//=================================================================================================
// convert( format )
//=================================================================================================
//=================================================================================================
cb_inline
void sb_cpp_convert
		(
		SampleFormat	src_fmt ,
		const void*		src ,
		SampleFormat	dest_fmt ,
		void*			dest ,
		int32			samplenum
		)
{
	typedef void (*func)( const void* , void* , int32 );
	static
	const func	funclist[SampleFormatNum][SampleFormatNum] = 
	{
		{
			sb_cpp_convert_int8align8_to_int8align8 , 
			sb_cpp_convert_int8align8_to_int16align16lsb , 
			sb_cpp_convert_int8align8_to_int16align16msb , 
			sb_cpp_convert_int8align8_to_int24align24lsb , 
			sb_cpp_convert_int8align8_to_int24align24msb , 
			sb_cpp_convert_int8align8_to_int32align32lsb , 
			sb_cpp_convert_int8align8_to_int32align32msb , 
			sb_cpp_convert_int8align8_to_float32align32lsb , 
			sb_cpp_convert_int8align8_to_float32align32msb , 
			sb_cpp_convert_int8align8_to_float64align64lsb , 
			sb_cpp_convert_int8align8_to_float64align64msb , 
			sb_cpp_convert_int8align8_to_int16align32lsb , 
			sb_cpp_convert_int8align8_to_int16align32msb , 
			sb_cpp_convert_int8align8_to_int18align32lsb , 
			sb_cpp_convert_int8align8_to_int18align32msb , 
			sb_cpp_convert_int8align8_to_int20align32lsb , 
			sb_cpp_convert_int8align8_to_int20align32msb , 
			sb_cpp_convert_int8align8_to_int24align32lsb , 
			sb_cpp_convert_int8align8_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int16align16lsb_to_int8align8 , 
			sb_cpp_convert_int16align16lsb_to_int16align16lsb , 
			sb_cpp_convert_int16align16lsb_to_int16align16msb , 
			sb_cpp_convert_int16align16lsb_to_int24align24lsb , 
			sb_cpp_convert_int16align16lsb_to_int24align24msb , 
			sb_cpp_convert_int16align16lsb_to_int32align32lsb , 
			sb_cpp_convert_int16align16lsb_to_int32align32msb , 
			sb_cpp_convert_int16align16lsb_to_float32align32lsb , 
			sb_cpp_convert_int16align16lsb_to_float32align32msb , 
			sb_cpp_convert_int16align16lsb_to_float64align64lsb , 
			sb_cpp_convert_int16align16lsb_to_float64align64msb , 
			sb_cpp_convert_int16align16lsb_to_int16align32lsb , 
			sb_cpp_convert_int16align16lsb_to_int16align32msb , 
			sb_cpp_convert_int16align16lsb_to_int18align32lsb , 
			sb_cpp_convert_int16align16lsb_to_int18align32msb , 
			sb_cpp_convert_int16align16lsb_to_int20align32lsb , 
			sb_cpp_convert_int16align16lsb_to_int20align32msb , 
			sb_cpp_convert_int16align16lsb_to_int24align32lsb , 
			sb_cpp_convert_int16align16lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int16align16msb_to_int8align8 , 
			sb_cpp_convert_int16align16msb_to_int16align16lsb , 
			sb_cpp_convert_int16align16msb_to_int16align16msb , 
			sb_cpp_convert_int16align16msb_to_int24align24lsb , 
			sb_cpp_convert_int16align16msb_to_int24align24msb , 
			sb_cpp_convert_int16align16msb_to_int32align32lsb , 
			sb_cpp_convert_int16align16msb_to_int32align32msb , 
			sb_cpp_convert_int16align16msb_to_float32align32lsb , 
			sb_cpp_convert_int16align16msb_to_float32align32msb , 
			sb_cpp_convert_int16align16msb_to_float64align64lsb , 
			sb_cpp_convert_int16align16msb_to_float64align64msb , 
			sb_cpp_convert_int16align16msb_to_int16align32lsb , 
			sb_cpp_convert_int16align16msb_to_int16align32msb , 
			sb_cpp_convert_int16align16msb_to_int18align32lsb , 
			sb_cpp_convert_int16align16msb_to_int18align32msb , 
			sb_cpp_convert_int16align16msb_to_int20align32lsb , 
			sb_cpp_convert_int16align16msb_to_int20align32msb , 
			sb_cpp_convert_int16align16msb_to_int24align32lsb , 
			sb_cpp_convert_int16align16msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int24align24lsb_to_int8align8 , 
			sb_cpp_convert_int24align24lsb_to_int16align16lsb , 
			sb_cpp_convert_int24align24lsb_to_int16align16msb , 
			sb_cpp_convert_int24align24lsb_to_int24align24lsb , 
			sb_cpp_convert_int24align24lsb_to_int24align24msb , 
			sb_cpp_convert_int24align24lsb_to_int32align32lsb , 
			sb_cpp_convert_int24align24lsb_to_int32align32msb , 
			sb_cpp_convert_int24align24lsb_to_float32align32lsb , 
			sb_cpp_convert_int24align24lsb_to_float32align32msb , 
			sb_cpp_convert_int24align24lsb_to_float64align64lsb , 
			sb_cpp_convert_int24align24lsb_to_float64align64msb , 
			sb_cpp_convert_int24align24lsb_to_int16align32lsb , 
			sb_cpp_convert_int24align24lsb_to_int16align32msb , 
			sb_cpp_convert_int24align24lsb_to_int18align32lsb , 
			sb_cpp_convert_int24align24lsb_to_int18align32msb , 
			sb_cpp_convert_int24align24lsb_to_int20align32lsb , 
			sb_cpp_convert_int24align24lsb_to_int20align32msb , 
			sb_cpp_convert_int24align24lsb_to_int24align32lsb , 
			sb_cpp_convert_int24align24lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int24align24msb_to_int8align8 , 
			sb_cpp_convert_int24align24msb_to_int16align16lsb , 
			sb_cpp_convert_int24align24msb_to_int16align16msb , 
			sb_cpp_convert_int24align24msb_to_int24align24lsb , 
			sb_cpp_convert_int24align24msb_to_int24align24msb , 
			sb_cpp_convert_int24align24msb_to_int32align32lsb , 
			sb_cpp_convert_int24align24msb_to_int32align32msb , 
			sb_cpp_convert_int24align24msb_to_float32align32lsb , 
			sb_cpp_convert_int24align24msb_to_float32align32msb , 
			sb_cpp_convert_int24align24msb_to_float64align64lsb , 
			sb_cpp_convert_int24align24msb_to_float64align64msb , 
			sb_cpp_convert_int24align24msb_to_int16align32lsb , 
			sb_cpp_convert_int24align24msb_to_int16align32msb , 
			sb_cpp_convert_int24align24msb_to_int18align32lsb , 
			sb_cpp_convert_int24align24msb_to_int18align32msb , 
			sb_cpp_convert_int24align24msb_to_int20align32lsb , 
			sb_cpp_convert_int24align24msb_to_int20align32msb , 
			sb_cpp_convert_int24align24msb_to_int24align32lsb , 
			sb_cpp_convert_int24align24msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int32align32lsb_to_int8align8 , 
			sb_cpp_convert_int32align32lsb_to_int16align16lsb , 
			sb_cpp_convert_int32align32lsb_to_int16align16msb , 
			sb_cpp_convert_int32align32lsb_to_int24align24lsb , 
			sb_cpp_convert_int32align32lsb_to_int24align24msb , 
			sb_cpp_convert_int32align32lsb_to_int32align32lsb , 
			sb_cpp_convert_int32align32lsb_to_int32align32msb , 
			sb_cpp_convert_int32align32lsb_to_float32align32lsb , 
			sb_cpp_convert_int32align32lsb_to_float32align32msb , 
			sb_cpp_convert_int32align32lsb_to_float64align64lsb , 
			sb_cpp_convert_int32align32lsb_to_float64align64msb , 
			sb_cpp_convert_int32align32lsb_to_int16align32lsb , 
			sb_cpp_convert_int32align32lsb_to_int16align32msb , 
			sb_cpp_convert_int32align32lsb_to_int18align32lsb , 
			sb_cpp_convert_int32align32lsb_to_int18align32msb , 
			sb_cpp_convert_int32align32lsb_to_int20align32lsb , 
			sb_cpp_convert_int32align32lsb_to_int20align32msb , 
			sb_cpp_convert_int32align32lsb_to_int24align32lsb , 
			sb_cpp_convert_int32align32lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int32align32msb_to_int8align8 , 
			sb_cpp_convert_int32align32msb_to_int16align16lsb , 
			sb_cpp_convert_int32align32msb_to_int16align16msb , 
			sb_cpp_convert_int32align32msb_to_int24align24lsb , 
			sb_cpp_convert_int32align32msb_to_int24align24msb , 
			sb_cpp_convert_int32align32msb_to_int32align32lsb , 
			sb_cpp_convert_int32align32msb_to_int32align32msb , 
			sb_cpp_convert_int32align32msb_to_float32align32lsb , 
			sb_cpp_convert_int32align32msb_to_float32align32msb , 
			sb_cpp_convert_int32align32msb_to_float64align64lsb , 
			sb_cpp_convert_int32align32msb_to_float64align64msb , 
			sb_cpp_convert_int32align32msb_to_int16align32lsb , 
			sb_cpp_convert_int32align32msb_to_int16align32msb , 
			sb_cpp_convert_int32align32msb_to_int18align32lsb , 
			sb_cpp_convert_int32align32msb_to_int18align32msb , 
			sb_cpp_convert_int32align32msb_to_int20align32lsb , 
			sb_cpp_convert_int32align32msb_to_int20align32msb , 
			sb_cpp_convert_int32align32msb_to_int24align32lsb , 
			sb_cpp_convert_int32align32msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_float32align32lsb_to_int8align8 , 
			sb_cpp_convert_float32align32lsb_to_int16align16lsb , 
			sb_cpp_convert_float32align32lsb_to_int16align16msb , 
			sb_cpp_convert_float32align32lsb_to_int24align24lsb , 
			sb_cpp_convert_float32align32lsb_to_int24align24msb , 
			sb_cpp_convert_float32align32lsb_to_int32align32lsb , 
			sb_cpp_convert_float32align32lsb_to_int32align32msb , 
			sb_cpp_convert_float32align32lsb_to_float32align32lsb , 
			sb_cpp_convert_float32align32lsb_to_float32align32msb , 
			sb_cpp_convert_float32align32lsb_to_float64align64lsb , 
			sb_cpp_convert_float32align32lsb_to_float64align64msb , 
			sb_cpp_convert_float32align32lsb_to_int16align32lsb , 
			sb_cpp_convert_float32align32lsb_to_int16align32msb , 
			sb_cpp_convert_float32align32lsb_to_int18align32lsb , 
			sb_cpp_convert_float32align32lsb_to_int18align32msb , 
			sb_cpp_convert_float32align32lsb_to_int20align32lsb , 
			sb_cpp_convert_float32align32lsb_to_int20align32msb , 
			sb_cpp_convert_float32align32lsb_to_int24align32lsb , 
			sb_cpp_convert_float32align32lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_float32align32msb_to_int8align8 , 
			sb_cpp_convert_float32align32msb_to_int16align16lsb , 
			sb_cpp_convert_float32align32msb_to_int16align16msb , 
			sb_cpp_convert_float32align32msb_to_int24align24lsb , 
			sb_cpp_convert_float32align32msb_to_int24align24msb , 
			sb_cpp_convert_float32align32msb_to_int32align32lsb , 
			sb_cpp_convert_float32align32msb_to_int32align32msb , 
			sb_cpp_convert_float32align32msb_to_float32align32lsb , 
			sb_cpp_convert_float32align32msb_to_float32align32msb , 
			sb_cpp_convert_float32align32msb_to_float64align64lsb , 
			sb_cpp_convert_float32align32msb_to_float64align64msb , 
			sb_cpp_convert_float32align32msb_to_int16align32lsb , 
			sb_cpp_convert_float32align32msb_to_int16align32msb , 
			sb_cpp_convert_float32align32msb_to_int18align32lsb , 
			sb_cpp_convert_float32align32msb_to_int18align32msb , 
			sb_cpp_convert_float32align32msb_to_int20align32lsb , 
			sb_cpp_convert_float32align32msb_to_int20align32msb , 
			sb_cpp_convert_float32align32msb_to_int24align32lsb , 
			sb_cpp_convert_float32align32msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_float64align64lsb_to_int8align8 , 
			sb_cpp_convert_float64align64lsb_to_int16align16lsb , 
			sb_cpp_convert_float64align64lsb_to_int16align16msb , 
			sb_cpp_convert_float64align64lsb_to_int24align24lsb , 
			sb_cpp_convert_float64align64lsb_to_int24align24msb , 
			sb_cpp_convert_float64align64lsb_to_int32align32lsb , 
			sb_cpp_convert_float64align64lsb_to_int32align32msb , 
			sb_cpp_convert_float64align64lsb_to_float32align32lsb , 
			sb_cpp_convert_float64align64lsb_to_float32align32msb , 
			sb_cpp_convert_float64align64lsb_to_float64align64lsb , 
			sb_cpp_convert_float64align64lsb_to_float64align64msb , 
			sb_cpp_convert_float64align64lsb_to_int16align32lsb , 
			sb_cpp_convert_float64align64lsb_to_int16align32msb , 
			sb_cpp_convert_float64align64lsb_to_int18align32lsb , 
			sb_cpp_convert_float64align64lsb_to_int18align32msb , 
			sb_cpp_convert_float64align64lsb_to_int20align32lsb , 
			sb_cpp_convert_float64align64lsb_to_int20align32msb , 
			sb_cpp_convert_float64align64lsb_to_int24align32lsb , 
			sb_cpp_convert_float64align64lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_float64align64msb_to_int8align8 , 
			sb_cpp_convert_float64align64msb_to_int16align16lsb , 
			sb_cpp_convert_float64align64msb_to_int16align16msb , 
			sb_cpp_convert_float64align64msb_to_int24align24lsb , 
			sb_cpp_convert_float64align64msb_to_int24align24msb , 
			sb_cpp_convert_float64align64msb_to_int32align32lsb , 
			sb_cpp_convert_float64align64msb_to_int32align32msb , 
			sb_cpp_convert_float64align64msb_to_float32align32lsb , 
			sb_cpp_convert_float64align64msb_to_float32align32msb , 
			sb_cpp_convert_float64align64msb_to_float64align64lsb , 
			sb_cpp_convert_float64align64msb_to_float64align64msb , 
			sb_cpp_convert_float64align64msb_to_int16align32lsb , 
			sb_cpp_convert_float64align64msb_to_int16align32msb , 
			sb_cpp_convert_float64align64msb_to_int18align32lsb , 
			sb_cpp_convert_float64align64msb_to_int18align32msb , 
			sb_cpp_convert_float64align64msb_to_int20align32lsb , 
			sb_cpp_convert_float64align64msb_to_int20align32msb , 
			sb_cpp_convert_float64align64msb_to_int24align32lsb , 
			sb_cpp_convert_float64align64msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int16align32lsb_to_int8align8 , 
			sb_cpp_convert_int16align32lsb_to_int16align16lsb , 
			sb_cpp_convert_int16align32lsb_to_int16align16msb , 
			sb_cpp_convert_int16align32lsb_to_int24align24lsb , 
			sb_cpp_convert_int16align32lsb_to_int24align24msb , 
			sb_cpp_convert_int16align32lsb_to_int32align32lsb , 
			sb_cpp_convert_int16align32lsb_to_int32align32msb , 
			sb_cpp_convert_int16align32lsb_to_float32align32lsb , 
			sb_cpp_convert_int16align32lsb_to_float32align32msb , 
			sb_cpp_convert_int16align32lsb_to_float64align64lsb , 
			sb_cpp_convert_int16align32lsb_to_float64align64msb , 
			sb_cpp_convert_int16align32lsb_to_int16align32lsb , 
			sb_cpp_convert_int16align32lsb_to_int16align32msb , 
			sb_cpp_convert_int16align32lsb_to_int18align32lsb , 
			sb_cpp_convert_int16align32lsb_to_int18align32msb , 
			sb_cpp_convert_int16align32lsb_to_int20align32lsb , 
			sb_cpp_convert_int16align32lsb_to_int20align32msb , 
			sb_cpp_convert_int16align32lsb_to_int24align32lsb , 
			sb_cpp_convert_int16align32lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int16align32msb_to_int8align8 , 
			sb_cpp_convert_int16align32msb_to_int16align16lsb , 
			sb_cpp_convert_int16align32msb_to_int16align16msb , 
			sb_cpp_convert_int16align32msb_to_int24align24lsb , 
			sb_cpp_convert_int16align32msb_to_int24align24msb , 
			sb_cpp_convert_int16align32msb_to_int32align32lsb , 
			sb_cpp_convert_int16align32msb_to_int32align32msb , 
			sb_cpp_convert_int16align32msb_to_float32align32lsb , 
			sb_cpp_convert_int16align32msb_to_float32align32msb , 
			sb_cpp_convert_int16align32msb_to_float64align64lsb , 
			sb_cpp_convert_int16align32msb_to_float64align64msb , 
			sb_cpp_convert_int16align32msb_to_int16align32lsb , 
			sb_cpp_convert_int16align32msb_to_int16align32msb , 
			sb_cpp_convert_int16align32msb_to_int18align32lsb , 
			sb_cpp_convert_int16align32msb_to_int18align32msb , 
			sb_cpp_convert_int16align32msb_to_int20align32lsb , 
			sb_cpp_convert_int16align32msb_to_int20align32msb , 
			sb_cpp_convert_int16align32msb_to_int24align32lsb , 
			sb_cpp_convert_int16align32msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int18align32lsb_to_int8align8 , 
			sb_cpp_convert_int18align32lsb_to_int16align16lsb , 
			sb_cpp_convert_int18align32lsb_to_int16align16msb , 
			sb_cpp_convert_int18align32lsb_to_int24align24lsb , 
			sb_cpp_convert_int18align32lsb_to_int24align24msb , 
			sb_cpp_convert_int18align32lsb_to_int32align32lsb , 
			sb_cpp_convert_int18align32lsb_to_int32align32msb , 
			sb_cpp_convert_int18align32lsb_to_float32align32lsb , 
			sb_cpp_convert_int18align32lsb_to_float32align32msb , 
			sb_cpp_convert_int18align32lsb_to_float64align64lsb , 
			sb_cpp_convert_int18align32lsb_to_float64align64msb , 
			sb_cpp_convert_int18align32lsb_to_int16align32lsb , 
			sb_cpp_convert_int18align32lsb_to_int16align32msb , 
			sb_cpp_convert_int18align32lsb_to_int18align32lsb , 
			sb_cpp_convert_int18align32lsb_to_int18align32msb , 
			sb_cpp_convert_int18align32lsb_to_int20align32lsb , 
			sb_cpp_convert_int18align32lsb_to_int20align32msb , 
			sb_cpp_convert_int18align32lsb_to_int24align32lsb , 
			sb_cpp_convert_int18align32lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int18align32msb_to_int8align8 , 
			sb_cpp_convert_int18align32msb_to_int16align16lsb , 
			sb_cpp_convert_int18align32msb_to_int16align16msb , 
			sb_cpp_convert_int18align32msb_to_int24align24lsb , 
			sb_cpp_convert_int18align32msb_to_int24align24msb , 
			sb_cpp_convert_int18align32msb_to_int32align32lsb , 
			sb_cpp_convert_int18align32msb_to_int32align32msb , 
			sb_cpp_convert_int18align32msb_to_float32align32lsb , 
			sb_cpp_convert_int18align32msb_to_float32align32msb , 
			sb_cpp_convert_int18align32msb_to_float64align64lsb , 
			sb_cpp_convert_int18align32msb_to_float64align64msb , 
			sb_cpp_convert_int18align32msb_to_int16align32lsb , 
			sb_cpp_convert_int18align32msb_to_int16align32msb , 
			sb_cpp_convert_int18align32msb_to_int18align32lsb , 
			sb_cpp_convert_int18align32msb_to_int18align32msb , 
			sb_cpp_convert_int18align32msb_to_int20align32lsb , 
			sb_cpp_convert_int18align32msb_to_int20align32msb , 
			sb_cpp_convert_int18align32msb_to_int24align32lsb , 
			sb_cpp_convert_int18align32msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int20align32lsb_to_int8align8 , 
			sb_cpp_convert_int20align32lsb_to_int16align16lsb , 
			sb_cpp_convert_int20align32lsb_to_int16align16msb , 
			sb_cpp_convert_int20align32lsb_to_int24align24lsb , 
			sb_cpp_convert_int20align32lsb_to_int24align24msb , 
			sb_cpp_convert_int20align32lsb_to_int32align32lsb , 
			sb_cpp_convert_int20align32lsb_to_int32align32msb , 
			sb_cpp_convert_int20align32lsb_to_float32align32lsb , 
			sb_cpp_convert_int20align32lsb_to_float32align32msb , 
			sb_cpp_convert_int20align32lsb_to_float64align64lsb , 
			sb_cpp_convert_int20align32lsb_to_float64align64msb , 
			sb_cpp_convert_int20align32lsb_to_int16align32lsb , 
			sb_cpp_convert_int20align32lsb_to_int16align32msb , 
			sb_cpp_convert_int20align32lsb_to_int18align32lsb , 
			sb_cpp_convert_int20align32lsb_to_int18align32msb , 
			sb_cpp_convert_int20align32lsb_to_int20align32lsb , 
			sb_cpp_convert_int20align32lsb_to_int20align32msb , 
			sb_cpp_convert_int20align32lsb_to_int24align32lsb , 
			sb_cpp_convert_int20align32lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int20align32msb_to_int8align8 , 
			sb_cpp_convert_int20align32msb_to_int16align16lsb , 
			sb_cpp_convert_int20align32msb_to_int16align16msb , 
			sb_cpp_convert_int20align32msb_to_int24align24lsb , 
			sb_cpp_convert_int20align32msb_to_int24align24msb , 
			sb_cpp_convert_int20align32msb_to_int32align32lsb , 
			sb_cpp_convert_int20align32msb_to_int32align32msb , 
			sb_cpp_convert_int20align32msb_to_float32align32lsb , 
			sb_cpp_convert_int20align32msb_to_float32align32msb , 
			sb_cpp_convert_int20align32msb_to_float64align64lsb , 
			sb_cpp_convert_int20align32msb_to_float64align64msb , 
			sb_cpp_convert_int20align32msb_to_int16align32lsb , 
			sb_cpp_convert_int20align32msb_to_int16align32msb , 
			sb_cpp_convert_int20align32msb_to_int18align32lsb , 
			sb_cpp_convert_int20align32msb_to_int18align32msb , 
			sb_cpp_convert_int20align32msb_to_int20align32lsb , 
			sb_cpp_convert_int20align32msb_to_int20align32msb , 
			sb_cpp_convert_int20align32msb_to_int24align32lsb , 
			sb_cpp_convert_int20align32msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int24align32lsb_to_int8align8 , 
			sb_cpp_convert_int24align32lsb_to_int16align16lsb , 
			sb_cpp_convert_int24align32lsb_to_int16align16msb , 
			sb_cpp_convert_int24align32lsb_to_int24align24lsb , 
			sb_cpp_convert_int24align32lsb_to_int24align24msb , 
			sb_cpp_convert_int24align32lsb_to_int32align32lsb , 
			sb_cpp_convert_int24align32lsb_to_int32align32msb , 
			sb_cpp_convert_int24align32lsb_to_float32align32lsb , 
			sb_cpp_convert_int24align32lsb_to_float32align32msb , 
			sb_cpp_convert_int24align32lsb_to_float64align64lsb , 
			sb_cpp_convert_int24align32lsb_to_float64align64msb , 
			sb_cpp_convert_int24align32lsb_to_int16align32lsb , 
			sb_cpp_convert_int24align32lsb_to_int16align32msb , 
			sb_cpp_convert_int24align32lsb_to_int18align32lsb , 
			sb_cpp_convert_int24align32lsb_to_int18align32msb , 
			sb_cpp_convert_int24align32lsb_to_int20align32lsb , 
			sb_cpp_convert_int24align32lsb_to_int20align32msb , 
			sb_cpp_convert_int24align32lsb_to_int24align32lsb , 
			sb_cpp_convert_int24align32lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_int24align32msb_to_int8align8 , 
			sb_cpp_convert_int24align32msb_to_int16align16lsb , 
			sb_cpp_convert_int24align32msb_to_int16align16msb , 
			sb_cpp_convert_int24align32msb_to_int24align24lsb , 
			sb_cpp_convert_int24align32msb_to_int24align24msb , 
			sb_cpp_convert_int24align32msb_to_int32align32lsb , 
			sb_cpp_convert_int24align32msb_to_int32align32msb , 
			sb_cpp_convert_int24align32msb_to_float32align32lsb , 
			sb_cpp_convert_int24align32msb_to_float32align32msb , 
			sb_cpp_convert_int24align32msb_to_float64align64lsb , 
			sb_cpp_convert_int24align32msb_to_float64align64msb , 
			sb_cpp_convert_int24align32msb_to_int16align32lsb , 
			sb_cpp_convert_int24align32msb_to_int16align32msb , 
			sb_cpp_convert_int24align32msb_to_int18align32lsb , 
			sb_cpp_convert_int24align32msb_to_int18align32msb , 
			sb_cpp_convert_int24align32msb_to_int20align32lsb , 
			sb_cpp_convert_int24align32msb_to_int20align32msb , 
			sb_cpp_convert_int24align32msb_to_int24align32lsb , 
			sb_cpp_convert_int24align32msb_to_int24align32msb , 
		} , 
	};
	( funclist[ src_fmt ][ dest_fmt ] )( src , dest , samplenum );
}
//=================================================================================================
cb_inline
void sb_cpp_convert_cp
		(
		SampleFormat	src_fmt ,
		const void*		src ,
		SampleFormat	dest_fmt ,
		void*			dest ,
		int32			samplenum
		)
{
	typedef void (*func)( const void* , void* , int32 );
	static
	const func	funclist[SampleFormatNum][SampleFormatNum] = 
	{
		{
			sb_cpp_convert_cp_int8align8_to_int8align8 , 
			sb_cpp_convert_cp_int8align8_to_int16align16lsb , 
			sb_cpp_convert_cp_int8align8_to_int16align16msb , 
			sb_cpp_convert_cp_int8align8_to_int24align24lsb , 
			sb_cpp_convert_cp_int8align8_to_int24align24msb , 
			sb_cpp_convert_cp_int8align8_to_int32align32lsb , 
			sb_cpp_convert_cp_int8align8_to_int32align32msb , 
			sb_cpp_convert_cp_int8align8_to_float32align32lsb , 
			sb_cpp_convert_cp_int8align8_to_float32align32msb , 
			sb_cpp_convert_cp_int8align8_to_float64align64lsb , 
			sb_cpp_convert_cp_int8align8_to_float64align64msb , 
			sb_cpp_convert_cp_int8align8_to_int16align32lsb , 
			sb_cpp_convert_cp_int8align8_to_int16align32msb , 
			sb_cpp_convert_cp_int8align8_to_int18align32lsb , 
			sb_cpp_convert_cp_int8align8_to_int18align32msb , 
			sb_cpp_convert_cp_int8align8_to_int20align32lsb , 
			sb_cpp_convert_cp_int8align8_to_int20align32msb , 
			sb_cpp_convert_cp_int8align8_to_int24align32lsb , 
			sb_cpp_convert_cp_int8align8_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int16align16lsb_to_int8align8 , 
			sb_cpp_convert_cp_int16align16lsb_to_int16align16lsb , 
			sb_cpp_convert_cp_int16align16lsb_to_int16align16msb , 
			sb_cpp_convert_cp_int16align16lsb_to_int24align24lsb , 
			sb_cpp_convert_cp_int16align16lsb_to_int24align24msb , 
			sb_cpp_convert_cp_int16align16lsb_to_int32align32lsb , 
			sb_cpp_convert_cp_int16align16lsb_to_int32align32msb , 
			sb_cpp_convert_cp_int16align16lsb_to_float32align32lsb , 
			sb_cpp_convert_cp_int16align16lsb_to_float32align32msb , 
			sb_cpp_convert_cp_int16align16lsb_to_float64align64lsb , 
			sb_cpp_convert_cp_int16align16lsb_to_float64align64msb , 
			sb_cpp_convert_cp_int16align16lsb_to_int16align32lsb , 
			sb_cpp_convert_cp_int16align16lsb_to_int16align32msb , 
			sb_cpp_convert_cp_int16align16lsb_to_int18align32lsb , 
			sb_cpp_convert_cp_int16align16lsb_to_int18align32msb , 
			sb_cpp_convert_cp_int16align16lsb_to_int20align32lsb , 
			sb_cpp_convert_cp_int16align16lsb_to_int20align32msb , 
			sb_cpp_convert_cp_int16align16lsb_to_int24align32lsb , 
			sb_cpp_convert_cp_int16align16lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int16align16msb_to_int8align8 , 
			sb_cpp_convert_cp_int16align16msb_to_int16align16lsb , 
			sb_cpp_convert_cp_int16align16msb_to_int16align16msb , 
			sb_cpp_convert_cp_int16align16msb_to_int24align24lsb , 
			sb_cpp_convert_cp_int16align16msb_to_int24align24msb , 
			sb_cpp_convert_cp_int16align16msb_to_int32align32lsb , 
			sb_cpp_convert_cp_int16align16msb_to_int32align32msb , 
			sb_cpp_convert_cp_int16align16msb_to_float32align32lsb , 
			sb_cpp_convert_cp_int16align16msb_to_float32align32msb , 
			sb_cpp_convert_cp_int16align16msb_to_float64align64lsb , 
			sb_cpp_convert_cp_int16align16msb_to_float64align64msb , 
			sb_cpp_convert_cp_int16align16msb_to_int16align32lsb , 
			sb_cpp_convert_cp_int16align16msb_to_int16align32msb , 
			sb_cpp_convert_cp_int16align16msb_to_int18align32lsb , 
			sb_cpp_convert_cp_int16align16msb_to_int18align32msb , 
			sb_cpp_convert_cp_int16align16msb_to_int20align32lsb , 
			sb_cpp_convert_cp_int16align16msb_to_int20align32msb , 
			sb_cpp_convert_cp_int16align16msb_to_int24align32lsb , 
			sb_cpp_convert_cp_int16align16msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int24align24lsb_to_int8align8 , 
			sb_cpp_convert_cp_int24align24lsb_to_int16align16lsb , 
			sb_cpp_convert_cp_int24align24lsb_to_int16align16msb , 
			sb_cpp_convert_cp_int24align24lsb_to_int24align24lsb , 
			sb_cpp_convert_cp_int24align24lsb_to_int24align24msb , 
			sb_cpp_convert_cp_int24align24lsb_to_int32align32lsb , 
			sb_cpp_convert_cp_int24align24lsb_to_int32align32msb , 
			sb_cpp_convert_cp_int24align24lsb_to_float32align32lsb , 
			sb_cpp_convert_cp_int24align24lsb_to_float32align32msb , 
			sb_cpp_convert_cp_int24align24lsb_to_float64align64lsb , 
			sb_cpp_convert_cp_int24align24lsb_to_float64align64msb , 
			sb_cpp_convert_cp_int24align24lsb_to_int16align32lsb , 
			sb_cpp_convert_cp_int24align24lsb_to_int16align32msb , 
			sb_cpp_convert_cp_int24align24lsb_to_int18align32lsb , 
			sb_cpp_convert_cp_int24align24lsb_to_int18align32msb , 
			sb_cpp_convert_cp_int24align24lsb_to_int20align32lsb , 
			sb_cpp_convert_cp_int24align24lsb_to_int20align32msb , 
			sb_cpp_convert_cp_int24align24lsb_to_int24align32lsb , 
			sb_cpp_convert_cp_int24align24lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int24align24msb_to_int8align8 , 
			sb_cpp_convert_cp_int24align24msb_to_int16align16lsb , 
			sb_cpp_convert_cp_int24align24msb_to_int16align16msb , 
			sb_cpp_convert_cp_int24align24msb_to_int24align24lsb , 
			sb_cpp_convert_cp_int24align24msb_to_int24align24msb , 
			sb_cpp_convert_cp_int24align24msb_to_int32align32lsb , 
			sb_cpp_convert_cp_int24align24msb_to_int32align32msb , 
			sb_cpp_convert_cp_int24align24msb_to_float32align32lsb , 
			sb_cpp_convert_cp_int24align24msb_to_float32align32msb , 
			sb_cpp_convert_cp_int24align24msb_to_float64align64lsb , 
			sb_cpp_convert_cp_int24align24msb_to_float64align64msb , 
			sb_cpp_convert_cp_int24align24msb_to_int16align32lsb , 
			sb_cpp_convert_cp_int24align24msb_to_int16align32msb , 
			sb_cpp_convert_cp_int24align24msb_to_int18align32lsb , 
			sb_cpp_convert_cp_int24align24msb_to_int18align32msb , 
			sb_cpp_convert_cp_int24align24msb_to_int20align32lsb , 
			sb_cpp_convert_cp_int24align24msb_to_int20align32msb , 
			sb_cpp_convert_cp_int24align24msb_to_int24align32lsb , 
			sb_cpp_convert_cp_int24align24msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int32align32lsb_to_int8align8 , 
			sb_cpp_convert_cp_int32align32lsb_to_int16align16lsb , 
			sb_cpp_convert_cp_int32align32lsb_to_int16align16msb , 
			sb_cpp_convert_cp_int32align32lsb_to_int24align24lsb , 
			sb_cpp_convert_cp_int32align32lsb_to_int24align24msb , 
			sb_cpp_convert_cp_int32align32lsb_to_int32align32lsb , 
			sb_cpp_convert_cp_int32align32lsb_to_int32align32msb , 
			sb_cpp_convert_cp_int32align32lsb_to_float32align32lsb , 
			sb_cpp_convert_cp_int32align32lsb_to_float32align32msb , 
			sb_cpp_convert_cp_int32align32lsb_to_float64align64lsb , 
			sb_cpp_convert_cp_int32align32lsb_to_float64align64msb , 
			sb_cpp_convert_cp_int32align32lsb_to_int16align32lsb , 
			sb_cpp_convert_cp_int32align32lsb_to_int16align32msb , 
			sb_cpp_convert_cp_int32align32lsb_to_int18align32lsb , 
			sb_cpp_convert_cp_int32align32lsb_to_int18align32msb , 
			sb_cpp_convert_cp_int32align32lsb_to_int20align32lsb , 
			sb_cpp_convert_cp_int32align32lsb_to_int20align32msb , 
			sb_cpp_convert_cp_int32align32lsb_to_int24align32lsb , 
			sb_cpp_convert_cp_int32align32lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int32align32msb_to_int8align8 , 
			sb_cpp_convert_cp_int32align32msb_to_int16align16lsb , 
			sb_cpp_convert_cp_int32align32msb_to_int16align16msb , 
			sb_cpp_convert_cp_int32align32msb_to_int24align24lsb , 
			sb_cpp_convert_cp_int32align32msb_to_int24align24msb , 
			sb_cpp_convert_cp_int32align32msb_to_int32align32lsb , 
			sb_cpp_convert_cp_int32align32msb_to_int32align32msb , 
			sb_cpp_convert_cp_int32align32msb_to_float32align32lsb , 
			sb_cpp_convert_cp_int32align32msb_to_float32align32msb , 
			sb_cpp_convert_cp_int32align32msb_to_float64align64lsb , 
			sb_cpp_convert_cp_int32align32msb_to_float64align64msb , 
			sb_cpp_convert_cp_int32align32msb_to_int16align32lsb , 
			sb_cpp_convert_cp_int32align32msb_to_int16align32msb , 
			sb_cpp_convert_cp_int32align32msb_to_int18align32lsb , 
			sb_cpp_convert_cp_int32align32msb_to_int18align32msb , 
			sb_cpp_convert_cp_int32align32msb_to_int20align32lsb , 
			sb_cpp_convert_cp_int32align32msb_to_int20align32msb , 
			sb_cpp_convert_cp_int32align32msb_to_int24align32lsb , 
			sb_cpp_convert_cp_int32align32msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_float32align32lsb_to_int8align8 , 
			sb_cpp_convert_cp_float32align32lsb_to_int16align16lsb , 
			sb_cpp_convert_cp_float32align32lsb_to_int16align16msb , 
			sb_cpp_convert_cp_float32align32lsb_to_int24align24lsb , 
			sb_cpp_convert_cp_float32align32lsb_to_int24align24msb , 
			sb_cpp_convert_cp_float32align32lsb_to_int32align32lsb , 
			sb_cpp_convert_cp_float32align32lsb_to_int32align32msb , 
			sb_cpp_convert_cp_float32align32lsb_to_float32align32lsb , 
			sb_cpp_convert_cp_float32align32lsb_to_float32align32msb , 
			sb_cpp_convert_cp_float32align32lsb_to_float64align64lsb , 
			sb_cpp_convert_cp_float32align32lsb_to_float64align64msb , 
			sb_cpp_convert_cp_float32align32lsb_to_int16align32lsb , 
			sb_cpp_convert_cp_float32align32lsb_to_int16align32msb , 
			sb_cpp_convert_cp_float32align32lsb_to_int18align32lsb , 
			sb_cpp_convert_cp_float32align32lsb_to_int18align32msb , 
			sb_cpp_convert_cp_float32align32lsb_to_int20align32lsb , 
			sb_cpp_convert_cp_float32align32lsb_to_int20align32msb , 
			sb_cpp_convert_cp_float32align32lsb_to_int24align32lsb , 
			sb_cpp_convert_cp_float32align32lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_float32align32msb_to_int8align8 , 
			sb_cpp_convert_cp_float32align32msb_to_int16align16lsb , 
			sb_cpp_convert_cp_float32align32msb_to_int16align16msb , 
			sb_cpp_convert_cp_float32align32msb_to_int24align24lsb , 
			sb_cpp_convert_cp_float32align32msb_to_int24align24msb , 
			sb_cpp_convert_cp_float32align32msb_to_int32align32lsb , 
			sb_cpp_convert_cp_float32align32msb_to_int32align32msb , 
			sb_cpp_convert_cp_float32align32msb_to_float32align32lsb , 
			sb_cpp_convert_cp_float32align32msb_to_float32align32msb , 
			sb_cpp_convert_cp_float32align32msb_to_float64align64lsb , 
			sb_cpp_convert_cp_float32align32msb_to_float64align64msb , 
			sb_cpp_convert_cp_float32align32msb_to_int16align32lsb , 
			sb_cpp_convert_cp_float32align32msb_to_int16align32msb , 
			sb_cpp_convert_cp_float32align32msb_to_int18align32lsb , 
			sb_cpp_convert_cp_float32align32msb_to_int18align32msb , 
			sb_cpp_convert_cp_float32align32msb_to_int20align32lsb , 
			sb_cpp_convert_cp_float32align32msb_to_int20align32msb , 
			sb_cpp_convert_cp_float32align32msb_to_int24align32lsb , 
			sb_cpp_convert_cp_float32align32msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_float64align64lsb_to_int8align8 , 
			sb_cpp_convert_cp_float64align64lsb_to_int16align16lsb , 
			sb_cpp_convert_cp_float64align64lsb_to_int16align16msb , 
			sb_cpp_convert_cp_float64align64lsb_to_int24align24lsb , 
			sb_cpp_convert_cp_float64align64lsb_to_int24align24msb , 
			sb_cpp_convert_cp_float64align64lsb_to_int32align32lsb , 
			sb_cpp_convert_cp_float64align64lsb_to_int32align32msb , 
			sb_cpp_convert_cp_float64align64lsb_to_float32align32lsb , 
			sb_cpp_convert_cp_float64align64lsb_to_float32align32msb , 
			sb_cpp_convert_cp_float64align64lsb_to_float64align64lsb , 
			sb_cpp_convert_cp_float64align64lsb_to_float64align64msb , 
			sb_cpp_convert_cp_float64align64lsb_to_int16align32lsb , 
			sb_cpp_convert_cp_float64align64lsb_to_int16align32msb , 
			sb_cpp_convert_cp_float64align64lsb_to_int18align32lsb , 
			sb_cpp_convert_cp_float64align64lsb_to_int18align32msb , 
			sb_cpp_convert_cp_float64align64lsb_to_int20align32lsb , 
			sb_cpp_convert_cp_float64align64lsb_to_int20align32msb , 
			sb_cpp_convert_cp_float64align64lsb_to_int24align32lsb , 
			sb_cpp_convert_cp_float64align64lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_float64align64msb_to_int8align8 , 
			sb_cpp_convert_cp_float64align64msb_to_int16align16lsb , 
			sb_cpp_convert_cp_float64align64msb_to_int16align16msb , 
			sb_cpp_convert_cp_float64align64msb_to_int24align24lsb , 
			sb_cpp_convert_cp_float64align64msb_to_int24align24msb , 
			sb_cpp_convert_cp_float64align64msb_to_int32align32lsb , 
			sb_cpp_convert_cp_float64align64msb_to_int32align32msb , 
			sb_cpp_convert_cp_float64align64msb_to_float32align32lsb , 
			sb_cpp_convert_cp_float64align64msb_to_float32align32msb , 
			sb_cpp_convert_cp_float64align64msb_to_float64align64lsb , 
			sb_cpp_convert_cp_float64align64msb_to_float64align64msb , 
			sb_cpp_convert_cp_float64align64msb_to_int16align32lsb , 
			sb_cpp_convert_cp_float64align64msb_to_int16align32msb , 
			sb_cpp_convert_cp_float64align64msb_to_int18align32lsb , 
			sb_cpp_convert_cp_float64align64msb_to_int18align32msb , 
			sb_cpp_convert_cp_float64align64msb_to_int20align32lsb , 
			sb_cpp_convert_cp_float64align64msb_to_int20align32msb , 
			sb_cpp_convert_cp_float64align64msb_to_int24align32lsb , 
			sb_cpp_convert_cp_float64align64msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int16align32lsb_to_int8align8 , 
			sb_cpp_convert_cp_int16align32lsb_to_int16align16lsb , 
			sb_cpp_convert_cp_int16align32lsb_to_int16align16msb , 
			sb_cpp_convert_cp_int16align32lsb_to_int24align24lsb , 
			sb_cpp_convert_cp_int16align32lsb_to_int24align24msb , 
			sb_cpp_convert_cp_int16align32lsb_to_int32align32lsb , 
			sb_cpp_convert_cp_int16align32lsb_to_int32align32msb , 
			sb_cpp_convert_cp_int16align32lsb_to_float32align32lsb , 
			sb_cpp_convert_cp_int16align32lsb_to_float32align32msb , 
			sb_cpp_convert_cp_int16align32lsb_to_float64align64lsb , 
			sb_cpp_convert_cp_int16align32lsb_to_float64align64msb , 
			sb_cpp_convert_cp_int16align32lsb_to_int16align32lsb , 
			sb_cpp_convert_cp_int16align32lsb_to_int16align32msb , 
			sb_cpp_convert_cp_int16align32lsb_to_int18align32lsb , 
			sb_cpp_convert_cp_int16align32lsb_to_int18align32msb , 
			sb_cpp_convert_cp_int16align32lsb_to_int20align32lsb , 
			sb_cpp_convert_cp_int16align32lsb_to_int20align32msb , 
			sb_cpp_convert_cp_int16align32lsb_to_int24align32lsb , 
			sb_cpp_convert_cp_int16align32lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int16align32msb_to_int8align8 , 
			sb_cpp_convert_cp_int16align32msb_to_int16align16lsb , 
			sb_cpp_convert_cp_int16align32msb_to_int16align16msb , 
			sb_cpp_convert_cp_int16align32msb_to_int24align24lsb , 
			sb_cpp_convert_cp_int16align32msb_to_int24align24msb , 
			sb_cpp_convert_cp_int16align32msb_to_int32align32lsb , 
			sb_cpp_convert_cp_int16align32msb_to_int32align32msb , 
			sb_cpp_convert_cp_int16align32msb_to_float32align32lsb , 
			sb_cpp_convert_cp_int16align32msb_to_float32align32msb , 
			sb_cpp_convert_cp_int16align32msb_to_float64align64lsb , 
			sb_cpp_convert_cp_int16align32msb_to_float64align64msb , 
			sb_cpp_convert_cp_int16align32msb_to_int16align32lsb , 
			sb_cpp_convert_cp_int16align32msb_to_int16align32msb , 
			sb_cpp_convert_cp_int16align32msb_to_int18align32lsb , 
			sb_cpp_convert_cp_int16align32msb_to_int18align32msb , 
			sb_cpp_convert_cp_int16align32msb_to_int20align32lsb , 
			sb_cpp_convert_cp_int16align32msb_to_int20align32msb , 
			sb_cpp_convert_cp_int16align32msb_to_int24align32lsb , 
			sb_cpp_convert_cp_int16align32msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int18align32lsb_to_int8align8 , 
			sb_cpp_convert_cp_int18align32lsb_to_int16align16lsb , 
			sb_cpp_convert_cp_int18align32lsb_to_int16align16msb , 
			sb_cpp_convert_cp_int18align32lsb_to_int24align24lsb , 
			sb_cpp_convert_cp_int18align32lsb_to_int24align24msb , 
			sb_cpp_convert_cp_int18align32lsb_to_int32align32lsb , 
			sb_cpp_convert_cp_int18align32lsb_to_int32align32msb , 
			sb_cpp_convert_cp_int18align32lsb_to_float32align32lsb , 
			sb_cpp_convert_cp_int18align32lsb_to_float32align32msb , 
			sb_cpp_convert_cp_int18align32lsb_to_float64align64lsb , 
			sb_cpp_convert_cp_int18align32lsb_to_float64align64msb , 
			sb_cpp_convert_cp_int18align32lsb_to_int16align32lsb , 
			sb_cpp_convert_cp_int18align32lsb_to_int16align32msb , 
			sb_cpp_convert_cp_int18align32lsb_to_int18align32lsb , 
			sb_cpp_convert_cp_int18align32lsb_to_int18align32msb , 
			sb_cpp_convert_cp_int18align32lsb_to_int20align32lsb , 
			sb_cpp_convert_cp_int18align32lsb_to_int20align32msb , 
			sb_cpp_convert_cp_int18align32lsb_to_int24align32lsb , 
			sb_cpp_convert_cp_int18align32lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int18align32msb_to_int8align8 , 
			sb_cpp_convert_cp_int18align32msb_to_int16align16lsb , 
			sb_cpp_convert_cp_int18align32msb_to_int16align16msb , 
			sb_cpp_convert_cp_int18align32msb_to_int24align24lsb , 
			sb_cpp_convert_cp_int18align32msb_to_int24align24msb , 
			sb_cpp_convert_cp_int18align32msb_to_int32align32lsb , 
			sb_cpp_convert_cp_int18align32msb_to_int32align32msb , 
			sb_cpp_convert_cp_int18align32msb_to_float32align32lsb , 
			sb_cpp_convert_cp_int18align32msb_to_float32align32msb , 
			sb_cpp_convert_cp_int18align32msb_to_float64align64lsb , 
			sb_cpp_convert_cp_int18align32msb_to_float64align64msb , 
			sb_cpp_convert_cp_int18align32msb_to_int16align32lsb , 
			sb_cpp_convert_cp_int18align32msb_to_int16align32msb , 
			sb_cpp_convert_cp_int18align32msb_to_int18align32lsb , 
			sb_cpp_convert_cp_int18align32msb_to_int18align32msb , 
			sb_cpp_convert_cp_int18align32msb_to_int20align32lsb , 
			sb_cpp_convert_cp_int18align32msb_to_int20align32msb , 
			sb_cpp_convert_cp_int18align32msb_to_int24align32lsb , 
			sb_cpp_convert_cp_int18align32msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int20align32lsb_to_int8align8 , 
			sb_cpp_convert_cp_int20align32lsb_to_int16align16lsb , 
			sb_cpp_convert_cp_int20align32lsb_to_int16align16msb , 
			sb_cpp_convert_cp_int20align32lsb_to_int24align24lsb , 
			sb_cpp_convert_cp_int20align32lsb_to_int24align24msb , 
			sb_cpp_convert_cp_int20align32lsb_to_int32align32lsb , 
			sb_cpp_convert_cp_int20align32lsb_to_int32align32msb , 
			sb_cpp_convert_cp_int20align32lsb_to_float32align32lsb , 
			sb_cpp_convert_cp_int20align32lsb_to_float32align32msb , 
			sb_cpp_convert_cp_int20align32lsb_to_float64align64lsb , 
			sb_cpp_convert_cp_int20align32lsb_to_float64align64msb , 
			sb_cpp_convert_cp_int20align32lsb_to_int16align32lsb , 
			sb_cpp_convert_cp_int20align32lsb_to_int16align32msb , 
			sb_cpp_convert_cp_int20align32lsb_to_int18align32lsb , 
			sb_cpp_convert_cp_int20align32lsb_to_int18align32msb , 
			sb_cpp_convert_cp_int20align32lsb_to_int20align32lsb , 
			sb_cpp_convert_cp_int20align32lsb_to_int20align32msb , 
			sb_cpp_convert_cp_int20align32lsb_to_int24align32lsb , 
			sb_cpp_convert_cp_int20align32lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int20align32msb_to_int8align8 , 
			sb_cpp_convert_cp_int20align32msb_to_int16align16lsb , 
			sb_cpp_convert_cp_int20align32msb_to_int16align16msb , 
			sb_cpp_convert_cp_int20align32msb_to_int24align24lsb , 
			sb_cpp_convert_cp_int20align32msb_to_int24align24msb , 
			sb_cpp_convert_cp_int20align32msb_to_int32align32lsb , 
			sb_cpp_convert_cp_int20align32msb_to_int32align32msb , 
			sb_cpp_convert_cp_int20align32msb_to_float32align32lsb , 
			sb_cpp_convert_cp_int20align32msb_to_float32align32msb , 
			sb_cpp_convert_cp_int20align32msb_to_float64align64lsb , 
			sb_cpp_convert_cp_int20align32msb_to_float64align64msb , 
			sb_cpp_convert_cp_int20align32msb_to_int16align32lsb , 
			sb_cpp_convert_cp_int20align32msb_to_int16align32msb , 
			sb_cpp_convert_cp_int20align32msb_to_int18align32lsb , 
			sb_cpp_convert_cp_int20align32msb_to_int18align32msb , 
			sb_cpp_convert_cp_int20align32msb_to_int20align32lsb , 
			sb_cpp_convert_cp_int20align32msb_to_int20align32msb , 
			sb_cpp_convert_cp_int20align32msb_to_int24align32lsb , 
			sb_cpp_convert_cp_int20align32msb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int24align32lsb_to_int8align8 , 
			sb_cpp_convert_cp_int24align32lsb_to_int16align16lsb , 
			sb_cpp_convert_cp_int24align32lsb_to_int16align16msb , 
			sb_cpp_convert_cp_int24align32lsb_to_int24align24lsb , 
			sb_cpp_convert_cp_int24align32lsb_to_int24align24msb , 
			sb_cpp_convert_cp_int24align32lsb_to_int32align32lsb , 
			sb_cpp_convert_cp_int24align32lsb_to_int32align32msb , 
			sb_cpp_convert_cp_int24align32lsb_to_float32align32lsb , 
			sb_cpp_convert_cp_int24align32lsb_to_float32align32msb , 
			sb_cpp_convert_cp_int24align32lsb_to_float64align64lsb , 
			sb_cpp_convert_cp_int24align32lsb_to_float64align64msb , 
			sb_cpp_convert_cp_int24align32lsb_to_int16align32lsb , 
			sb_cpp_convert_cp_int24align32lsb_to_int16align32msb , 
			sb_cpp_convert_cp_int24align32lsb_to_int18align32lsb , 
			sb_cpp_convert_cp_int24align32lsb_to_int18align32msb , 
			sb_cpp_convert_cp_int24align32lsb_to_int20align32lsb , 
			sb_cpp_convert_cp_int24align32lsb_to_int20align32msb , 
			sb_cpp_convert_cp_int24align32lsb_to_int24align32lsb , 
			sb_cpp_convert_cp_int24align32lsb_to_int24align32msb , 
		} , 
		{
			sb_cpp_convert_cp_int24align32msb_to_int8align8 , 
			sb_cpp_convert_cp_int24align32msb_to_int16align16lsb , 
			sb_cpp_convert_cp_int24align32msb_to_int16align16msb , 
			sb_cpp_convert_cp_int24align32msb_to_int24align24lsb , 
			sb_cpp_convert_cp_int24align32msb_to_int24align24msb , 
			sb_cpp_convert_cp_int24align32msb_to_int32align32lsb , 
			sb_cpp_convert_cp_int24align32msb_to_int32align32msb , 
			sb_cpp_convert_cp_int24align32msb_to_float32align32lsb , 
			sb_cpp_convert_cp_int24align32msb_to_float32align32msb , 
			sb_cpp_convert_cp_int24align32msb_to_float64align64lsb , 
			sb_cpp_convert_cp_int24align32msb_to_float64align64msb , 
			sb_cpp_convert_cp_int24align32msb_to_int16align32lsb , 
			sb_cpp_convert_cp_int24align32msb_to_int16align32msb , 
			sb_cpp_convert_cp_int24align32msb_to_int18align32lsb , 
			sb_cpp_convert_cp_int24align32msb_to_int18align32msb , 
			sb_cpp_convert_cp_int24align32msb_to_int20align32lsb , 
			sb_cpp_convert_cp_int24align32msb_to_int20align32msb , 
			sb_cpp_convert_cp_int24align32msb_to_int24align32lsb , 
			sb_cpp_convert_cp_int24align32msb_to_int24align32msb , 
		} , 
	};
	( funclist[ src_fmt ][ dest_fmt ] )( src , dest , samplenum );
}

};	//namespace

#pragma pack( pop )			//release align
