/*************************************************************************************************/
/*!
   	@file		sb_cpp_cast.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic_audio
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define


//=================================================================================================
// cast
//=================================================================================================
//=================================================================================================
#define		cb_cast_none( src_fmt , tgt_fmt )														\
cb_inline																							\
void sb_cpp_cast_##src_fmt##_to_##tgt_fmt																	\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
}
//=================================================================================================
#define		cb_cast_int32_up( src_fmt , tgt_fmt )													\
cb_inline																							\
void sb_cpp_cast_##src_fmt##_to_##tgt_fmt															\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
	static const int32	scale[2] =																	\
	{																								\
		cb_##tgt_fmt##_min / cb_##src_fmt##_min , 													\
		cb_##tgt_fmt##_max / cb_##src_fmt##_max														\
	};																								\
	value.m_int32 *= scale[ value.m_int32 < 0 ? 0 : 1 ];											\
}
//=================================================================================================
#define		cb_cast_int32_down( src_fmt , tgt_fmt )													\
cb_inline																							\
void sb_cpp_cast_##src_fmt##_to_##tgt_fmt															\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
	static const int32	scale[2] =																	\
	{																								\
		cb_##src_fmt##_min / cb_##tgt_fmt##_min , 													\
		cb_##src_fmt##_max / cb_##tgt_fmt##_max														\
	};																								\
	value.m_int32 /= scale[ value.m_int32 < 0 ? 0 : 1 ];											\
}
//=================================================================================================
#define		cb_cast_int32_to_float32( src_fmt , tgt_fmt )											\
cb_inline																							\
void sb_cpp_cast_##src_fmt##_to_##tgt_fmt															\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
	static const double	scale[2] =																	\
	{																								\
		-1.0 / cb_##src_fmt##_min , 																\
		1.0 / cb_##src_fmt##_max																	\
	};																								\
	value.m_float32	= (float)( (double)value.m_int32 * scale[ value.m_int32 < 0 ? 0 : 1 ] );		\
}
//=================================================================================================
#define		cb_cast_float32_to_int32( src_fmt , tgt_fmt )											\
cb_inline																							\
void sb_cpp_cast_##src_fmt##_to_##tgt_fmt															\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
	static const double	scale[2] =																	\
	{																								\
		-(double)cb_##tgt_fmt##_min , 																\
		(double)cb_##tgt_fmt##_max																	\
	};																								\
	value.m_int32	= (int32)( value.m_float32 * scale[ value.m_float32 < 0.0f ? 0 : 1 ] );			\
}
//=================================================================================================
#define		cb_cast_int32_to_float64( src_fmt , tgt_fmt )											\
cb_inline																							\
void sb_cpp_cast_##src_fmt##_to_##tgt_fmt															\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
	static const double	scale[2] =																	\
	{																								\
		-1.0 / cb_##src_fmt##_min , 																\
		1.0 / cb_##src_fmt##_max																	\
	};																								\
	value.m_float64	= (double)value.m_int32 * scale[ value.m_int32 < 0 ? 0 : 1 ];					\
}
//=================================================================================================
#define		cb_cast_float64_to_int32( src_fmt , tgt_fmt )											\
cb_inline																							\
void sb_cpp_cast_##src_fmt##_to_##tgt_fmt															\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
	static const double	scale[2] =																	\
	{																								\
		-(double)cb_##tgt_fmt##_min , 																\
		(double)cb_##tgt_fmt##_max																	\
	};																								\
	value.m_int32	= (int32)( value.m_float64 * scale[ value.m_float64 < 0.0 ? 0 : 1 ] );			\
}
//=================================================================================================
#define		cb_cast_float32_to_float64( src_fmt , tgt_fmt )											\
cb_inline																							\
void sb_cpp_cast_##src_fmt##_to_##tgt_fmt															\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
	value.m_float64	= (double)value.m_float32;														\
}
//=================================================================================================
#define		cb_cast_float64_to_float32( src_fmt , tgt_fmt )											\
cb_inline																							\
void sb_cpp_cast_##src_fmt##_to_##tgt_fmt															\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
	value.m_float32	= (float)value.m_float64;														\
}

// int8
cb_cast_none				( int8 , int8 );
cb_cast_int32_up			( int8 , int16 );
cb_cast_int32_up			( int8 , int18 );
cb_cast_int32_up			( int8 , int20 );
cb_cast_int32_up			( int8 , int24 );
cb_cast_int32_up			( int8 , int32 );
cb_cast_int32_to_float32	( int8 , float32 );
cb_cast_int32_to_float64	( int8 , float64 );

// int16
cb_cast_int32_down			( int16 , int8 );
cb_cast_none				( int16 , int16 );
cb_cast_int32_up			( int16 , int18 );
cb_cast_int32_up			( int16 , int20 );
cb_cast_int32_up			( int16 , int24 );
cb_cast_int32_up			( int16 , int32 );
cb_cast_int32_to_float32	( int16 , float32 );
cb_cast_int32_to_float64	( int16 , float64 );

// int18
cb_cast_int32_down			( int18 , int8 );
cb_cast_int32_down			( int18 , int16 );
cb_cast_none				( int18 , int18 );
cb_cast_int32_up			( int18 , int20 );
cb_cast_int32_up			( int18 , int24 );
cb_cast_int32_up			( int18 , int32 );
cb_cast_int32_to_float32	( int18 , float32 );
cb_cast_int32_to_float64	( int18 , float64 );

// int20
cb_cast_int32_down			( int20 , int8 );
cb_cast_int32_down			( int20 , int16 );
cb_cast_int32_down			( int20 , int18 );
cb_cast_none				( int20 , int20 );
cb_cast_int32_up			( int20 , int24 );
cb_cast_int32_up			( int20 , int32 );
cb_cast_int32_to_float32	( int20 , float32 );
cb_cast_int32_to_float64	( int20 , float64 );

// int24
cb_cast_int32_down			( int24 , int8 );
cb_cast_int32_down			( int24 , int16 );
cb_cast_int32_down			( int24 , int18 );
cb_cast_int32_down			( int24 , int20 );
cb_cast_none				( int24 , int24 );
cb_cast_int32_up			( int24 , int32 );
cb_cast_int32_to_float32	( int24 , float32 );
cb_cast_int32_to_float64	( int24 , float64 );

// int32
cb_cast_int32_down			( int32 , int8 );
cb_cast_int32_down			( int32 , int16 );
cb_cast_int32_down			( int32 , int18 );
cb_cast_int32_down			( int32 , int20 );
cb_cast_int32_down			( int32 , int24 );
cb_cast_none				( int32 , int32 );
cb_cast_int32_to_float32	( int32 , float32 );
cb_cast_int32_to_float64	( int32 , float64 );

// float32
cb_cast_float32_to_int32	( float32 , int8 );
cb_cast_float32_to_int32	( float32 , int16 );
cb_cast_float32_to_int32	( float32 , int18 );
cb_cast_float32_to_int32	( float32 , int20 );
cb_cast_float32_to_int32	( float32 , int24 );
cb_cast_float32_to_int32	( float32 , int32 );
cb_cast_none				( float32 , float32 );
cb_cast_float32_to_float64	( float32 , float64 );

// float64
cb_cast_float64_to_int32	( float64 , int8 );
cb_cast_float64_to_int32	( float64 , int16 );
cb_cast_float64_to_int32	( float64 , int18 );
cb_cast_float64_to_int32	( float64 , int20 );
cb_cast_float64_to_int32	( float64 , int24 );
cb_cast_float64_to_int32	( float64 , int32 );
cb_cast_float64_to_float32	( float64 , float32 );
cb_cast_none				( float64 , float64 );


//=================================================================================================
// clip
//=================================================================================================
//=================================================================================================
#define		cb_clip_none( fmt )																		\
cb_inline																							\
void sb_cpp_clip_##fmt																				\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
}
//=================================================================================================
#define		cb_clip_int32( fmt )																	\
cb_inline																							\
void sb_cpp_clip_##fmt																				\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
	value.m_int32	= ( value.m_int32 < cb_##fmt##_min ) ? cb_##fmt##_min : ( ( value.m_int32 > cb_##fmt##_max ) ? cb_##fmt##_max : value.m_int32 );	\
}
//=================================================================================================
#define		cb_clip_float32( fmt )																	\
cb_inline																							\
void sb_cpp_clip_##fmt																				\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
	value.m_float32	= ( value.m_float32 < -1.0f ) ? -1.0f : ( ( value.m_float32 > 1.0f ) ? 1.0f : value.m_float32 );	\
}
//=================================================================================================
#define		cb_clip_float64( fmt )																	\
cb_inline																							\
void sb_cpp_clip_##fmt																				\
		(																							\
		sb_value&	value																			\
		)																							\
{																									\
	value.m_float64	= ( value.m_float64 < -1.0 ) ? -1.0 : ( ( value.m_float64 > 1.0 ) ? 1.0 : value.m_float64 );	\
}
cb_clip_int32	( int8 );
cb_clip_int32	( int16 );
cb_clip_int32	( int18 );
cb_clip_int32	( int20 );
cb_clip_int32	( int24 );
cb_clip_none	( int32 );
cb_clip_float32	( float32 );
cb_clip_float64	( float64 );


};	//namespace

#pragma pack( pop )			//release align
