/*************************************************************************************************/
/*!
   	@file		SourceGenSolidColorCfgView.h
	@author 	Fanzo
 	@date 		2008/6/4
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"SourceGenSolidColorCfgView" class 
**************************************************************************************************/
class SourceGenSolidColorCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<ColorCfgView>			m_color;
	instance<SourcePaintSolidColor>	m_source_paint;
	instance<SourceTextureSolidColor>m_source_tex;
	
	rControlMsg							m_msg;
	int									m_id;
	

// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_color->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Size().width , p->m_rect.Size().height ) )
			);
	m_color->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
SourceGenSolidColorCfgView() : 
		m_id( 0 ) 
{
	m_color->SetValue( rgba( 127 , 191 , 121 , 255 ) );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iPaint GetSourcePaint()
{
	m_source_paint->SetColor( m_color->GetValue() );
	return (iPaint)m_source_paint;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iTexture GetSourceTexture()
{
	m_source_tex->SetColor( m_color->GetValue() );
	return (iTexture)m_source_tex;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace SourceGenSolidColorCfgView;		

#pragma pack( pop )			//release align
