/*************************************************************************************************/
/*!
   	@file		CoordLayer.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iCoordLayer.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"CoordLayer" class 
**************************************************************************************************/
template<class t_interface>
class CoordLayer : 
	virtual public object_base , 
	public t_interface
{
// query
	query_begin();
	iface_hook( ICoordLayer , ICoordLayer_IID )
	query_end( object_base );

// variable
protected:
	rCoordLayer						m_parent;
	Array<iCoordLayer>				m_children;
	
// protected functions
protected:
//=================================================================================================
PPL UnitToPPL
		(
		const DPI&		dpi , 
		const unit_ip&	unit 
		)const
{
	PPL		ppl;
	if( unit.x.m_unit == value_ip::inch )
		ppl.SetPPL_x( dpi.ItoD_x( unit.x.m_value ) );
	else if( unit.x.m_unit == value_ip::px )
		ppl.SetPPL_x( unit.x.m_value );
	if( unit.y.m_unit == value_ip::inch )
		ppl.SetPPL_y( dpi.ItoD_y( unit.y.m_value ) );
	else if( unit.y.m_unit == value_ip::px )
		ppl.SetPPL_y( unit.y.m_value );
	return ppl;
}
//=================================================================================================
float ValueToDevice_x
		(
		const Coord_ld&		dc , 
		const fsize&		vp , 
		const value_iplr&	p	
		)const
{
	float	r = 0.0f;
	if( p.m_unit == value_iplr::inch )
		r	= dc.GetLogical().ItoD_x( p.m_value );
	else if( p.m_unit == value_iplr::px )
		r	= p.m_value;
	else if( p.m_unit == value_iplr::logical )
		r	= dc.GetLogical().LtoD_x( p.m_value );
	else if( p.m_unit == value_iplr::ratio )
		r	= vp.width * p.m_value;
	return r;
}
//=================================================================================================
float ValueToDevice_y
		(
		const Coord_ld&		dc , 
		const fsize&		vp , 
		const value_iplr&	p	
		)const
{
	float	r = 0.0f;
	if( p.m_unit == value_iplr::inch )
		r	= dc.GetLogical().ItoD_y( p.m_value );
	else if( p.m_unit == value_iplr::px )
		r	= p.m_value;
	else if( p.m_unit == value_iplr::logical )
		r	= dc.GetLogical().LtoD_y( p.m_value );
	else if( p.m_unit == value_iplr::ratio )
		r	= vp.height * p.m_value;
	return r;
}
//=================================================================================================
fvector2 ValueToDevice
		(
		const Coord_ld&		dc , 
		const fsize&		vp , 
		const point_iplr&	p	
		)const
{
	return fvector2( ValueToDevice_x( dc , vp , p.x ) , ValueToDevice_y( dc , vp , p.y ) );
}
//=================================================================================================
frect ValueToDevice
		(
		const Coord_ld&		dc , 
		const fsize&		vp , 
		const rect_iplr&	p	
		)const
{
	return frect
			( 
			ValueToDevice_x( dc , vp , p.x ) , 
			ValueToDevice_y( dc , vp , p.y ) , 
			ValueToDevice_x( dc , vp , p.x ) + ValueToDevice_x( dc , vp , p.w ) , 
			ValueToDevice_y( dc , vp , p.y ) + ValueToDevice_y( dc , vp , p.h ) 
			).Normalize();
//	return frect( ValueToDevice_x( dc , vp , p.xmin ) , ValueToDevice_y( dc , vp , p.ymin ) , ValueToDevice_x( dc , vp , p.xmax ) , ValueToDevice_y( dc , vp , p.ymax ) ).Normalize();
}
//=================================================================================================
float ValueToDevice_x
		(
		const DPI&			dpi , 
		const value_ip&		p	
		)const
{
	float	r = 0.0f;
	if( p.m_unit == value_iplr::inch )
		r	= dpi.ItoD_x( p.m_value );
	else if( p.m_unit == value_iplr::px )
		r	= p.m_value;
	return r;
}
//=================================================================================================
float ValueToDevice_y
		(
		const DPI&			dpi , 
		const value_ip&		p	
		)const
{
	float	r = 0.0f;
	if( p.m_unit == value_iplr::inch )
		r	= dpi.ItoD_y( p.m_value );
	else if( p.m_unit == value_iplr::px )
		r	= p.m_value;
	return r;
}
//=================================================================================================
fsize ValueToDevice
		(
		const DPI&			dpi , 
		const size_ip&		p	
		)const
{
	return fsize( ValueToDevice_x( dpi , p.width ) , ValueToDevice_y( dpi , p.height ) );
}

// "ICoordLayer" interface functions
public:
//=================================================================================================
/*
virtual
iCoordLayer cb_call CopyItem() = 0;
*/
//=================================================================================================
iCoordLayer cb_call Copy()
{
	iCoordLayer	n = CopyItem();
	int	c_off , c_num = GetChildnum();
	for( c_off = 0 ; c_off < c_num ; c_off++ )
		n->AddChild( GetChild( c_off ) );	
	return (iCoordLayer)n;		
}
//=================================================================================================
iCoordLayer cb_call Copy
		(
		iCoordLayer&	end , 
		iCoordLayer*	endpos
		)
{
	
	if( end == false )
		return iCoordLayer();
	if( this_object() == end )
		return store( endpos , CopyItem() );
	else
	{
		iCoordLayer	pend;
		iCoordLayer c = Copy( end->GetParent() , &pend );
		if( c == false )
			return iCoordLayer();
		store( endpos , pend->AddChild( end , end ) );
		return c;
	}
}
//=================================================================================================
iCoordLayer cb_call GetRoot()
{
	iCoordLayer	r	= this_object();
	iCoordLayer	p	= GetParent();
	while( p == true )
	{
		r	= p;
		p	= p->GetParent();
	}
	return r;
}
//=================================================================================================
void cb_call SetParent
		(
		iCoordLayer&	parent
		)
{
	m_parent	= parent;
}
//=================================================================================================
iCoordLayer cb_call GetParent()
{
	return (iCoordLayer)m_parent.lock();
}
//=================================================================================================
iCoordLayer cb_call AddChild
		(
		iCoordLayer&	layer , 
		int				insertpos	= -1
		)
{
	if( insertpos == -1 )
		insertpos = m_children.GetDatanum();
	if( insertpos < 0 || insertpos > m_children.GetDatanum() )
		return 0;
	iCoordLayer			child = layer->Copy();
	if( child == false )
		return iCoordLayer();
	
	m_children.Insert( insertpos );
	m_children[ insertpos ] = child;
	child->SetParent( (iCoordLayer)this_object() );
	return child;
}
//=================================================================================================
iCoordLayer cb_call AddChild
		(
		iCoordLayer&	layer , 
		iCoordLayer&	end_layer , 
		iCoordLayer*	enspos		= 0 , 
		int				insertpos	= -1
		)
{
	if( insertpos == -1 )
		insertpos = m_children.GetDatanum();
	if( insertpos < 0 || insertpos > m_children.GetDatanum() )
		return 0;
	iCoordLayer			child = layer->Copy( end_layer , enspos );
	if( child == false )
		return iCoordLayer();
	
	m_children.Insert( insertpos );
	m_children[ insertpos ] = child;
	child->SetParent( (iCoordLayer)this_object() );
	return child;
}
//=================================================================================================
bool cb_call RemoveChild
		(
		iCoordLayer&	child
		)
{
	int		off , num = m_children.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( (object)m_children[ off ] == child )
		{
			m_children[off]->SetParent( iCoordLayer() );
			m_children.Delete( off );
			return true;
		}
	}
	return false;
}
//=================================================================================================
void cb_call Remove()
{
	iCoordLayer		parent = GetParent();
	if( parent == false )
		return;
	parent->RemoveChild( (iCoordLayer)this_object() );
}
//=================================================================================================
int cb_call GetChildnum()
{
	return m_children.GetDatanum();
}
//=================================================================================================
iCoordLayer cb_call GetChild
		(
		int		off
		)
{
	if( off < 0 || off >= m_children.GetDatanum() )
		return iCoordLayer();
	return m_children[off];
}
//=================================================================================================
/*
virtual
bool cb_call GetCoord_l
		(
		Coord_l*		coord
		) = 0;
*/
//=================================================================================================
/*
bool cb_call GetCoord_ld
		(
		Coord_ld*	coord , 
		frect*		clip , 
		frect*		view
		) = 0;
*/
//=================================================================================================
faffine cb_call LtoD()
{
	Coord_ld	coord;
	if( false == GetCoord_ld( &coord , 0 , 0 ) )
		return faffine();
	return coord.LtoPD();
}
//=================================================================================================
faffine cb_call CtoC
		(
		value_ipl::Unit		dest_unit , 
		value_ipl::Unit		src_unit , 
		iCoordLayer&		src_layer
		)
{
	Coord_ld	sc , tc;
	if( false == src_layer->GetCoord_ld( &sc , 0 , 0 ) )
		return faffine();
	if( false == GetCoord_ld( &tc , 0 , 0 ) )
		return faffine();
	
	faffine		r;
	if( value_ipl::inch == src_unit )
		r	= sc.GetLogical().ItoD_xy();
	else if( value_ipl::px == src_unit )
		r	= faffine();
	else
		r	= sc.GetLogical().LtoD_xy();

	r = tc.PDtoD() * sc.DtoPD() * r;

	if( value_ipl::inch == dest_unit )
		r	= tc.GetLogical().DtoI_xy() * r;
	else if( value_ipl::px == dest_unit )
		r	= r;
	else
		r	= tc.GetLogical().DtoL_xy() * r;
	return r;
}

// public functions
public:
//=================================================================================================
CoordLayer()
{
}
//=================================================================================================
~CoordLayer()
{
}
};
/**************************************************************************************************
"ViewCoordLayer" class 
**************************************************************************************************/
class ViewCoordLayer : 
		public CoordLayer<IViewCoordLayer>
{
// query
	query_begin();
	iface_hook( IViewCoordLayer , IViewCoordLayer_IID )
	query_end( CoordLayer<IViewCoordLayer> );
	
// private functions	
private:
//=================================================================================================
frect Aspect
		(
		AspectRatio		aspect , 
		Align			horz , 
		Align			vert , 
		const frect&	dr , 
		const fsize&	ss
		)const
{
	frect		r;
	if( aspect == Adjust )
		r	= dr;
	else
	{
		float	s[2]	= { dr.Width() / ss.width , dr.Height() / ss.height };
		fsize	ts		= ( aspect == AspectMin ) ? ( ss * min( s[0],s[1]) ) : ( ss * max( s[0],s[1] ) );
		if( horz == MinAlign )
		{
			r.xmin = dr.xmin; 
			r.xmax = dr.xmin + ts.width; 
		}
		else if( horz == MidAlign )
		{
			r.xmin = dr.xmin + ( dr.Width() - ts.width ) / 2.0f; 
			r.xmax = dr.xmin + ( dr.Width() + ts.width ) / 2.0f;
		}
		else
		{
			r.xmin = dr.xmax - ts.width;
			r.xmax = dr.xmax; 
		}
		if( vert == MinAlign )
		{
			r.ymin = dr.ymin; 
			r.ymax = dr.ymin + ts.height; 
		}
		else if( vert == MidAlign )
		{
			r.ymin = dr.ymin + ( dr.Height() - ts.height ) / 2.0f; 
			r.ymax = dr.ymin + ( dr.Height() + ts.height ) / 2.0f;
		}
		else
		{
			r.ymin = dr.ymax - ts.height;
			r.ymax = dr.ymax; 
		}
	}
	return r;
}

// "IViewCoordLayer" interface functions
public:
//=================================================================================================
iCoordLayer cb_call CopyItem()
{
	instance<ViewCoordLayer>	n;
	n->m_dest_view	= m_dest_view;
	n->m_view		= m_view;
	n->m_dpi		= m_dpi;
	n->m_unit		= m_unit;
	n->m_aspect		= m_aspect;
	n->m_horz		= m_horz;
	n->m_vert		= m_vert;
	return (iCoordLayer)n;		
}
//=================================================================================================
bool cb_call GetCoord_l
		(
		Coord_l*		coord
		)
{
	store( coord , Coord_l( m_dpi , UnitToPPL( m_dpi , m_unit ) ) );
	return true;
}
//=================================================================================================
bool cb_call GetCoord_ld
		(
		Coord_ld*		coord ,
		fsize*			local ,  
		frect*			view
		)
{
	iCoordLayer	parent = m_parent.lock();
	if( parent == false )
		return false;

	Coord_ld	pcoord;
	fsize		plocal;
	if( false == parent->GetCoord_ld( &pcoord , &plocal , view ) )
		return false;
		
	fsize		view_size	= ValueToDevice( m_dpi , m_view );
	fsize		dest_size	= pcoord.GetLogical().GetDPI().DtoD( m_dpi , view_size );
	frect		dest_rect	= Aspect( m_aspect , m_horz , m_vert , ValueToDevice( pcoord , plocal , m_dest_view ) , dest_size );
	store
		( 
		coord , 
		Coord_ld
				( 
				pcoord.GetDtoPD() * faffine::GetMove( dest_rect.Min() ) * faffine::GetScale( view_size.width / dest_rect.Width() , view_size.height / dest_rect.Height() ) , 
				Coord_l( m_dpi , UnitToPPL( m_dpi , m_unit ) ) 
				) 
		);
	store( local , view_size );
	return true;
}

// public functions
public:
//=================================================================================================
ViewCoordLayer()
{
	m_aspect	= Adjust;
	m_horz		= MidAlign;
	m_vert		= MidAlign;
}
};
/**************************************************************************************************
"SubCoordLayer" class 
**************************************************************************************************/
class SubCoordLayer : 
	public CoordLayer<ISubCoordLayer>
{
// query
	query_begin();
	iface_hook( ISubCoordLayer , ISubCoordLayer_IID )
	query_end( CoordLayer<ISubCoordLayer> );
	
// "ICoordLayer" interface functions
public:
//=================================================================================================
iCoordLayer cb_call CopyItem()
{
	instance<SubCoordLayer>	n;
	n->m_org	= m_org;
	n->m_unit	= m_unit;
	n->m_rotate	= m_rotate;
	return (iCoordLayer)n;		
}
//=================================================================================================
bool cb_call GetCoord_l
		(
		Coord_l*		coord
		)
{
	iCoordLayer	parent = m_parent.lock();
	if( parent == false )
		return false;
		
	Coord_l		pcoord;
	if( false == parent->GetCoord_l( &pcoord ) )
		return false;
	store
		(
		coord , 
		Coord_l( pcoord.GetDPI() , UnitToPPL( pcoord.GetDPI() , m_unit ) ) 
		);
	return true;				
}
//=================================================================================================
bool cb_call GetCoord_ld
		(
		Coord_ld*		coord , 
		fsize*			local , 
		frect*			view
		)
{
	iCoordLayer	parent = m_parent.lock();
	if( parent == false )
		return false;

	Coord_ld	pcoord;
	fsize		plocal;
	if( false == parent->GetCoord_ld( &pcoord , &plocal , view ) )
		return false;
	store
		(
		coord , 
		Coord_ld
				( 
				pcoord.GetDtoPD() * faffine::GetMove( ValueToDevice( pcoord , plocal , m_org ) ) * faffine::GetRotate( m_rotate ) , 
				Coord_l( pcoord.GetLogical().GetDPI() , UnitToPPL( pcoord.GetLogical().GetDPI() , m_unit ) ) 
				)
		);
	store( local , plocal );
	return true;
}
// "ISubCoordLayer" interface functions
// public functions
public:
//=================================================================================================
SubCoordLayer()
{
	m_rotate	= 0.0f;
}
};
/**************************************************************************************************
"DeviceCoordLayer" class 
**************************************************************************************************/
class DeviceCoordLayer : 
	public CoordLayer<IDeviceCoordLayer>
{
// query
	query_begin();
	iface_hook( IDeviceCoordLayer , IDeviceCoordLayer_IID )
	query_end( CoordLayer<IDeviceCoordLayer> );
	
// "ICoordLayer" interface functions
public:
//=================================================================================================
iCoordLayer cb_call CopyItem()
{
	instance<DeviceCoordLayer>	n;
	n->m_dpi	= m_dpi;
	n->m_view	= m_view;
	return (iCoordLayer)n;		
}
//=================================================================================================
bool cb_call GetCoord_l
		(
		Coord_l*		coord
		)
{
	store( coord , Coord_l( m_dpi , PPL() ) );
	return true;
}
//=================================================================================================
bool cb_call GetCoord_ld
		(
		Coord_ld*		coord , 
		fsize*			local , 
		frect*			view
		)
{
	store
			( 
			coord , 
			Coord_ld
				( 
				faffine() ,  
				Coord_l( m_dpi , PPL() ) 
				) 
			);
	store( local , m_view.Size() );
	store( view , m_view );
	return true;
}
// public functions
public:
//=================================================================================================
DeviceCoordLayer()
{
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
