/*************************************************************************************************/
/*!
   	@file		iMemAlloc.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IMemAlloc" interface 
***************************************************************************************************/
cb_guid_define( IMemAlloc_IID , 0xB5407790 , 0x7980415b , 0xA94D5879 , 0x6232F518 );
class IMemAlloc;
typedef icubic::iface_object< IMemAlloc , IMemAlloc_IID >		iMemAlloc;
typedef icubic::iface_reference< IMemAlloc , IMemAlloc_IID >	rMemAlloc;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IMemAlloc
{
public:
//=================================================================================================
//!	allocate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void* cb_call Allocate
		(
		uint32		size
		) = 0;
//=================================================================================================
//!	deallocate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Deallocate
		(
		void*	p
		) = 0;
};
/**************************************************************************************************
 "IMemAllocLump" interface 
***************************************************************************************************/
cb_guid_define( IMemAllocLump_IID , 0x4F56F9BA , 0xA4954ab5 , 0xA50285CA , 0xAD0C7B7F );
class IMemAllocLump;
typedef icubic::iface_object< IMemAllocLump , IMemAlloc_IID >			iMemAllocLump;
typedef icubic::iface_reference< IMemAllocLump , IMemAllocLump_IID >	rMemAllocLump;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IMemAllocLump
{
public:
//=================================================================================================
//!	allocate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void* cb_call Allocate
		(
		uint32		size
		) = 0;
//=================================================================================================
//!	deallocate all
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call DeallocateAll() = 0;
};
/**************************************************************************************************
 "IMemAllocStack" interface 
***************************************************************************************************/
cb_guid_define( IMemAllocStack_IID , 0x91DDD755 , 0x2A1F4b0b , 0xB91E36CB , 0x9C6FFEFD );
class IMemAllocStack;
typedef icubic::iface_object< IMemAllocStack , IMemAllocStack_IID >		iMemAllocStack;
typedef icubic::iface_reference< IMemAllocStack , IMemAllocStack_IID >	rMemAllocStack;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IMemAllocStack
{
public:
//=================================================================================================
//!	allocate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void* cb_call Allocate
		(
		uint32		size
		) = 0;
//=================================================================================================
//!	deallocate last
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Deallocate
		(
		uint32		size
		) = 0;
//=================================================================================================
//!	deallocate all
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call DeallocateAll() = 0;
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
