/*************************************************************************************************/
/*!
   	@file		Listdata.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iListdata.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"ListNode_bs" class 
**************************************************************************************************/
template<class t_interface>
class t_ListNode : 
	virtual public object_base , 
	public t_interface
{
// query
	query_begin();
	iface_hook( IListNode , IListNode_IID )
	query_end( object_base );
	
// variable member
protected:
	rListNode					m_prev;
	iListNode					m_next;

// "IListNode" interface functions
public:
//=================================================================================================
//!	set prev
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call SetPrevWithoutLink
		(
		iListNode&		prev
		)
{
	m_prev	= prev;
	return true;
}
//=================================================================================================
//!	get prev
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iListNode cb_call GetPrev()
{
	return m_prev.lock();
}
//=================================================================================================
//!	get next
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iListNode cb_call GetNext()
{
	return m_next;
}
//=================================================================================================
//!	insert next
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call InsertNext
		(
		iListNode&		next
		)
{
	if( next == false )
		return;
	next->Remove();

	iListNode	a_next = m_next;
	if( a_next == true )
		a_next->Remove();
	
	next->SetPrevWithoutLink( (iListNode)this_object() );
	m_next	= next;
	
	if( a_next == false )
		return;

	while( true == next->GetNext() )
	{
		next	= next->GetNext();
	}
	next->InsertNext( a_next );
}
//=================================================================================================
//!	remove next
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call RemoveNext()
{
	if( m_next == false )
		return;
	m_next->SetPrevWithoutLink( iListNode() );
	m_next.release();
}
//=================================================================================================
//!	remove
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call Remove()
{
	iListNode	prev = GetPrev();
	if( prev == false )
		return;
	prev->RemoveNext();
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
t_ListNode()
{
}
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
