/*************************************************************************************************/
/*!
   	@file		PathArc.h
	@author 	Fanzo
 	@date 		2008/5/3
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iPathSegment.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"PathArc_bs" class 
**************************************************************************************************/
class PathArc_bs :
	public IPathSegment
{
	cb_copy_impossible( PathArc_bs );

// variable member
private:
	// x = a0 * sin( angle * t + b0 ) + c0
	// y = a1 * sin( angle * t + b1 ) + c1
	
	float	m_samplenum;
	float	m_angle;
	float	m_a[2] , m_b[2] , m_c[2];
	
// private functions
private:
//=================================================================================================
//!	get optimum samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call UpdateSamplenum()
{
	float	h	= sqrtf( 8.0f * cb_pathsegment_max_accident_error / ( m_angle * m_angle * sqrtf( m_a[0]*m_a[0]+m_a[1]*m_a[1] ) ) );
	m_samplenum	= 1.0f / h;
}
	
// "IPath" interface functions
public:
//=================================================================================================
//!	IsExist
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call IsExist()
{
	if( m_angle == 0.0f || ( m_a[0]==0.0f && m_a[1]==0.0f ) )
		return false;
	return true;
}
//=================================================================================================
//!	get optimum samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int cb_call GetOptimumSample
		(
		float		samplescale
		)
{
	int		num = ( int )( samplescale * m_samplenum );
	return num < 2 ? 2 : num;
}
//=================================================================================================
//!	get optimum length samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int cb_call GetOptimumLengthSample()
{
	int	num = ( int )ceilf( fabs( m_angle ) / PI_2_f ) * 8;
	num = num < 2 ? 2 : num;
	return num;
}
//=================================================================================================
//!	value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 cb_call Value
		(
		float	t
		)
{
	// x = a0 * sin( angle * t + b0 ) + c0
	// y = a1 * sin( angle * t + b1 ) + c1
	return fvector2
			(
			m_a[0] * sinf( m_angle * t + m_b[0] ) + m_c[0] , 
			m_a[1] * sinf( m_angle * t + m_b[1] ) + m_c[1]
			);
}
//=================================================================================================
//!	Differential
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 cb_call Differential
		(
		float	t
		)
{
	// x = a0 * angle * cos( angle * t + b0 )
	// y = a1 * angle * cos( angle * t + b1 )
	return fvector2
			(
			m_angle * m_a[0] * cosf( m_angle * t + m_b[0] ) , 
			m_angle * m_a[1] * cosf( m_angle * t + m_b[1] )
			);
}
//=================================================================================================
//!	SecondOrderDifferential
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
fvector2 cb_call SecondOrderDifferential
		(
		float	t
		)
{
	// x = -a0 * angle * angle * sin( angle * t + b0 )
	// y = -a1 * angle * angle * sin( angle * t + b1 )
	float	pa	= m_angle * m_angle;
	return fvector2
			(
			-pa * m_a[0] * sinf( m_angle * t + m_b[0] ) , 
			-pa * m_a[1] * sinf( m_angle * t + m_b[1] )
			);
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PathArc_bs() : 
		m_angle( 0.0f ) , 
		m_samplenum( 0.0f )
{
	m_a[0]	= 0.0f;
	m_a[1]	= 0.0f;
	m_b[0]	= 0.0f;
	m_b[1]	= 0.0f;
	m_c[0]	= 0.0f;
	m_c[1]	= 0.0f;
}
//=================================================================================================
//! x = a0*cos( sr + r*t ) + b0
//! y = -a1*sin( sr + r*t ) + b1
//-------------------------------------------------------------------------------------------------
void InitializeParam
		(
		float			start_angle , 
		float			angle , 
		float			a0 , 
		float			b0 , 
		float			a1 , 
		float			b1 , 
		const faffine&	affine
		)
{
	// 0 - 4PI
	{
		int		l = angle >= 0.0f ? ( int )floorf( angle / PI_2_f ) : ( int )ceil( angle / PI_2_f );
		m_angle		= angle - l * PI_2_f;
		m_angle	+= ( l == 0 ? 0.0f : ( l > 0 ? PI_2_f : -PI_2_f ) );
	}
	int		i;
	for( i = 0 ; i < 2 ; i++ )
	{
		float		t0	= affine.m[i][0] * a0;
		float		t1	= affine.m[i][1] * a1;
		m_a[i]	= sqrtf( t0 * t0 + t1 * t1 );
		m_c[i]	= affine.m[i][0]*b0 + affine.m[i][1]*b1 + affine.m[i][2];
		if( m_a[i] == 0.0f )
			m_b[i] = 0.0f;
		else
		{
			m_b[i]	= acosf( clip( t1 / m_a[i] , -1.0f , 1.0f ) );
			m_b[i]	= t0 < 0.0f ? -m_b[i] : m_b[i];
		}
		m_b[i] += start_angle;
	}
	UpdateSamplenum();
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializeCircleAngle
		(
		const fvector2&		sp , 
		const fvector2&		cp , 
		float				angle , 
		const faffine&		affine
		)
{
	fvector2	ds	= sp - cp;
	float	r	= ds.Length();
	float	sa	= acosf( clip( ds.x / r , -1.0f , 1.0f ) );//ds.GetAngle_f( fvector2( 1.0f , 0.0f ) );
	if( ds.y < 0.0f )
		sa	= -sa;

	InitializeParam( sa , angle , r , cp.x , r , cp.y , affine );
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializeEllipseAngle
		(
		const fvector2&		sp , 
		const fvector2&		cp , 
		float				ry ,
		float				angle , 
		const faffine&		affine
		)
{
	ry	= max( ry , 0.000001f );
	fvector2	ds	= sp - cp;
	float	r	= sqrtf( ry * ry * ds.x * ds.x + ds.y * ds.y ) / ry;
	float	sa	= acosf( clip( ds.x / r , -1.0f , 1.0f ) );
	if( ds.y < 0.0f )
		sa	= -sa;

	InitializeParam( sa , angle , r , cp.x , ry * r , cp.y , affine );
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializeCirclePosition
		(
		const fvector2&		sp , 
		const fvector2&		tp , 
		const fvector2&		cp , 
		const faffine&		affine
		)
{
	fvector2	ds	= sp - cp;
	fvector2	dt	= tp - cp;
	float	sa			= ds.GetAngle_f( fvector2( 1.0f , 0.0f ) );
	float	angle		= dt.GetAngle_f( ds );
	float	r			= ds.Length();

	InitializeParam( sa , angle , r , cp.x , r , cp.y , affine );
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializeHalfCircle
		(
		const fvector2&		sp , 
		const fvector2&		tp , 
		const fvector2&		vec , 
		const faffine&		affine
		)
{
	fvector2	cp		= ( sp + tp ) / 2.0f;
	fvector2	sp_vec	= sp - cp;
	float		angle	= PI_f;
	if( sp_vec.Outer( vec ) < 0.0f )
		angle	= -angle;
	float		r	= sp_vec.Length();
	float		sa	= sp_vec.GetAngle_f( fvector2( 1.0f , 0.0f ) );
	
	InitializeParam( sa , angle , r , cp.x , r , cp.y , affine );
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool InitializeArc
		(
		const fvector2&		sp , 
		const fvector2&		tp , 
		float				rx , 
		float				ry , 
		float				x_axis_rot , 
		bool				large , 
		bool				sweep , 
		const faffine&		affine
		)
{
	rx	= fabs( rx );
	ry	= fabs( ry );
	if( rx == 0.0f || ry == 0.0f || sp == tp )
		return false;
	
	// rotate
	faffine		rot			= faffine::GetRotate( -x_axis_rot );
	faffine		rot_inv		= rot.Inverse();
	
	// scale
	faffine		scale		= faffine::GetScale( ry / rx , 1.0f );
	faffine		scale_inv	= scale.Inverse();
	
	// conv
	faffine		trans		= scale * rot;
	faffine		trans_inv	= trans.Inverse();

	float		r		= ry;
	fvector2	p1		= trans.Transform( sp );
	fvector2	p2		= trans.Transform( tp );
	fvector2	p12		= p2 - p1;
	fvector2	pc		= (p1+p2)/2.0f;
	float		p1c_p2	= (p12.x * p12.x + p12.y * p12.y)/4.0f;
	float		rr		= r * r;
	fvector2	cp1 , cp2;
	float		angle;
	
	if( rr <= p1c_p2 )
	{
		cp1	= pc;
		cp2 = pc;
		angle	= PI_f;
	}
	else
	{
		float		l = sqrtf( rr - p1c_p2 );
		fvector2	n = p12.GetRotate90();
		n		= l / n.Length() * n;
		cp1		= pc + n;
		cp2		= pc - n;
		angle	= (p2-cp1).GetAngle_f(p1-cp1);
		cb_assert( 0.0f <= angle && angle <= PI_2_f , L"algorithm error." );
	}
	if( large == false && sweep == true )
		angle	= angle;	
	else if( large == true && sweep == false )
		angle	= -(PI_2_f - angle );	
	else if( large == false && sweep == false )
	{
		angle	= -angle;
		swap( &cp1 , &cp2 );
	}
	else if( large == true && sweep == true )
	{
		angle	= PI_2_f - angle;	
		swap( &cp1 , &cp2 );
	}
	InitializeCircleAngle( p1 , cp1 , angle , affine * trans_inv );
	return true;
}
};
/**************************************************************************************************
"PathArc" class 
**************************************************************************************************/
class PathArc : 
	virtual public object_base , 
	public PathArc_bs
{
// query
	query_begin();
	iface_hook( IPathSegment , IPathSegment_IID )
	query_end( object_base );
	
// variable member
private:

// private functions
private:

// "IPathArc" interface functions
public:

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PathArc()
{
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
