/*************************************************************************************************/
/*!
   	@file		AudioDevice.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iAudioDevice.h"

#pragma pack( push , 8 )		//set align

namespace icubic_audio
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"AudioDeviceId" class 
**************************************************************************************************/
class AudioDeviceId : 
	virtual public object_base , 
	public IAudioDeviceId
{
	query_begin();
	iface_hook( IAudioDeviceId , IAudioDeviceId_IID )
	query_end( object_base );
	
// variable member
private:
	Array<uint8>	m_buffer;
	
// "IAudioDeviceId" interface functions
public:
//=================================================================================================
void cb_call SetData
		(
		const void*		data , 
		int32			size
		)
{
	m_buffer.Resize( size );
	MemoryCopy( m_buffer.GetPtr() , data , size );
}
//=================================================================================================
const void* cb_call GetDataPtr()
{
	return m_buffer.GetConstPtr();
}
//=================================================================================================
int cb_call GetDataSize()
{
	return m_buffer.GetDatanum();
}

// public functions
public:
//=================================================================================================
AudioDeviceId()
{
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
