/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.peer.command.send;

import iax.protocol.frame.ProtocolControlFrame;
import iax.protocol.peer.Peer;
import iax.protocol.peer.command.send.PeerCommandSend;
import iax.protocol.util.Converter;
import iax.protocol.util.FrameUtil;

public class RegReq
implements PeerCommandSend {
    private Peer peer;
    private ProtocolControlFrame regauthFrame;

    public RegReq(Peer peer) {
        this.peer = peer;
        this.regauthFrame = null;
    }

    public RegReq(Peer peer, ProtocolControlFrame regauthFrame) {
        this.peer = peer;
        this.regauthFrame = regauthFrame;
    }

    public void execute() {
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        try {
            if (this.regauthFrame != null) {
                String userName = this.regauthFrame.getUserName();
                int auth = this.regauthFrame.getAuthMethods();
                String challenge = this.regauthFrame.getChallenge();
                if (userName.equals(this.peer.getUserName())) {
                    String password = this.peer.getPassword();
                    ProtocolControlFrame regreqFrame = new ProtocolControlFrame(1, false, this.regauthFrame.getSrcCallNo(), this.peer.getTimestamp(), this.regauthFrame.getIseqno(), this.regauthFrame.getOseqno() + 1, false, 13);
                    regreqFrame.setUserName(userName);
                    regreqFrame.setRefresh(60);
                    switch (auth) {
                        case 2: 
                        case 3: {
                            password = Converter.byteArrayToHexString(FrameUtil.md5(challenge.getBytes(), password.getBytes()));
                            regreqFrame.setMD5Result(password);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 1: {
                            regreqFrame.setMD5Result(password);
                            break;
                        }
                    }
                    this.peer.handleSendFrame(regreqFrame);
                }
            } else {
                ProtocolControlFrame regreqFrame = new ProtocolControlFrame(1, false, 0, this.peer.getTimestamp(), 0, 0, false, 13);
                regreqFrame.setUserName(this.peer.getUserName());
                regreqFrame.setRefresh(60);
                this.peer.handleSendFrame(regreqFrame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

