/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.frame;

import iax.protocol.frame.FrameException;
import iax.protocol.frame.FullFrame;
import iax.protocol.util.ByteBuffer;
import java.util.Enumeration;
import java.util.Hashtable;

public class ProtocolControlFrame
extends FullFrame {
    public static final int NEW_SC = 1;
    public static final int PING_SC = 2;
    public static final int PONG_SC = 3;
    public static final int ACK_SC = 4;
    public static final int HANGUP_SC = 5;
    public static final int REJECT_SC = 6;
    public static final int ACCEPT_SC = 7;
    public static final int AUTHREQ_SC = 8;
    public static final int AUTHREP_SC = 9;
    public static final int INVAL_SC = 10;
    public static final int LAGRQ_SC = 11;
    public static final int LAGRP_SC = 12;
    public static final int REGREQ_SC = 13;
    public static final int REGAUTH_SC = 14;
    public static final int REGACK_SC = 15;
    public static final int REGREJ_SC = 16;
    public static final int REGREL_SC = 17;
    public static final int VNAK_SC = 18;
    public static final int DIAL_SC = 21;
    public static final int QUELCH_SC = 28;
    public static final int UNQUELCH_SC = 29;
    public static final int POKE_SC = 30;
    public static final int UNSUPPORT_SC = 33;
    public static final int TRANSFER_SC = 34;
    private Hashtable infoElements;

    protected ProtocolControlFrame() {
    }

    public ProtocolControlFrame(int srcCallNo, boolean retry, int destCallNo, long timeStamp, int oSeqno, int iSeqno, boolean subclassValueFormat, int subclass) {
        super(3, srcCallNo, retry, destCallNo, timeStamp, oSeqno, iSeqno, 6, subclassValueFormat, subclass);
        this.infoElements = new Hashtable();
    }

    public ProtocolControlFrame(byte[] buffer) throws FrameException {
        super(3, buffer);
        this.infoElements = new Hashtable();
        try {
            byte[] iesBuffer = new byte[buffer.length - 12];
            System.arraycopy(buffer, 12, iesBuffer, 0, iesBuffer.length);
            int bytesRemaining = iesBuffer.length;
            while (bytesRemaining > 0) {
                byte[] aux = new byte[bytesRemaining];
                System.arraycopy(iesBuffer, iesBuffer.length - bytesRemaining, aux, 0, aux.length);
                ByteBuffer byteBuffer = new ByteBuffer(aux);
                int id = byteBuffer.get8bits();
                int dataLength = byteBuffer.get8bits();
                byte[] data = new byte[dataLength];
                System.arraycopy(byteBuffer.getByteArray(), 0, data, 0, data.length);
                this.infoElements.put(id, data);
                bytesRemaining -= 2 + dataLength;
            }
            int i = 1;
            ++i;
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public int getAuthMethods() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(14);
            ByteBuffer byteBuffer = new ByteBuffer(data);
            return byteBuffer.get16bits();
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setAuthMethods(int authMethods) throws FrameException {
        try {
            ByteBuffer byteBuffer = new ByteBuffer(2);
            byteBuffer.put16bits(authMethods);
            this.infoElements.put(14, byteBuffer.getBuffer());
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public String getCalledNumber() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(1);
            return new String(data);
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setCalledNumber(String calledNumber) {
        this.infoElements.put(1, calledNumber.getBytes());
    }

    public String getCallingName() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(4);
            return new String(data);
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setCallingName(String callingName) {
        this.infoElements.put(4, callingName.getBytes());
    }

    public String getCallingNumber() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(2);
            return new String(data);
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setCallingNumber(String callingNumber) {
        this.infoElements.put(2, callingNumber.getBytes());
    }

    public long getCapability() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(8);
            ByteBuffer byteBuffer = new ByteBuffer(data);
            return byteBuffer.get32bits();
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setCapability(long capability) throws FrameException {
        try {
            ByteBuffer byteBuffer = new ByteBuffer(4);
            byteBuffer.put32bits(capability);
            this.infoElements.put(8, byteBuffer.getBuffer());
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public String getCause() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(22);
            return new String(data);
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setCause(String cause) {
        this.infoElements.put(22, cause.getBytes());
    }

    public int getCauseCode() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(42);
            ByteBuffer byteBuffer = new ByteBuffer(data);
            return byteBuffer.get16bits();
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setCauseCode(int causeCode) throws FrameException {
        try {
            ByteBuffer byteBuffer = new ByteBuffer(2);
            byteBuffer.put16bits(causeCode);
            this.infoElements.put(42, byteBuffer.getBuffer());
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public String getChallenge() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(15);
            return new String(data);
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setChallenge(String challenge) {
        this.infoElements.put(15, challenge.getBytes());
    }

    public long getFormat() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(9);
            ByteBuffer byteBuffer = new ByteBuffer(data);
            return byteBuffer.get32bits();
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setFormat(long format) throws FrameException {
        try {
            ByteBuffer byteBuffer = new ByteBuffer(4);
            byteBuffer.put32bits(format);
            this.infoElements.put(9, byteBuffer.getBuffer());
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public String getMD5Result() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(16);
            return new String(data);
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setMD5Result(String md5) throws FrameException {
        this.infoElements.put(16, md5.getBytes());
    }

    public void setMusicOnHold() throws FrameException {
        this.infoElements.put(26, new byte[0]);
    }

    public int getRefresh() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(19);
            ByteBuffer byteBuffer = new ByteBuffer(data);
            return byteBuffer.get16bits();
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setRefresh(int refresh) throws FrameException {
        try {
            ByteBuffer byteBuffer = new ByteBuffer(2);
            byteBuffer.put16bits(refresh);
            this.infoElements.put(19, byteBuffer.getBuffer());
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public int getUnknown() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(23);
            ByteBuffer byteBuffer = new ByteBuffer(data);
            return byteBuffer.get16bits();
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setUnknown(int subclass) throws FrameException {
        try {
            ByteBuffer byteBuffer = new ByteBuffer(1);
            byteBuffer.put8bits(subclass);
            this.infoElements.put(23, byteBuffer.getBuffer());
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public String getUserName() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(6);
            return new String(data);
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setUserName(String userName) {
        this.infoElements.put(6, userName.getBytes());
    }

    public int getVersion() throws FrameException {
        try {
            byte[] data = (byte[])this.infoElements.get(11);
            ByteBuffer byteBuffer = new ByteBuffer(data);
            return byteBuffer.get16bits();
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public void setVersion(int version) throws FrameException {
        try {
            ByteBuffer byteBuffer = new ByteBuffer(2);
            byteBuffer.put16bits(version);
            this.infoElements.put(11, byteBuffer.getBuffer());
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public byte[] serialize() {
        try {
            byte[] superInBytes = super.serialize();
            int iesBufferMaxSize = this.infoElements.size() * 2 * 255;
            byte[] iesBuffer = new byte[iesBufferMaxSize];
            Enumeration keys = this.infoElements.keys();
            int iesBufferSize = 0;
            while (keys.hasMoreElements()) {
                Integer id = (Integer)keys.nextElement();
                byte[] data = (byte[])this.infoElements.get(id);
                int ieLength = 2 + data.length;
                ByteBuffer byteBuffer = new ByteBuffer(ieLength);
                byteBuffer.put8bits(id.byteValue());
                byteBuffer.put8bits(data.length);
                byteBuffer.putByteArray(data);
                System.arraycopy(byteBuffer.getBuffer(), 0, iesBuffer, iesBufferSize, ieLength);
                iesBufferSize += ieLength;
            }
            byte[] result = new byte[superInBytes.length + iesBufferSize];
            System.arraycopy(superInBytes, 0, result, 0, superInBytes.length);
            System.arraycopy(iesBuffer, 0, result, superInBytes.length, iesBufferSize);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

