/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.frame;

import iax.protocol.frame.FrameException;
import iax.protocol.util.ByteBuffer;

public abstract class Frame {
    public static final int F_SHORTMASK = 32768;
    public static final int SRCCALLNO_SHORTMASK = Short.MAX_VALUE;
    public static final int FRAME_HEADER_LENGTH = 2;
    public static final int UNKNOWNFRAME_T = 0;
    public static final int MINIFRAME_T = 1;
    public static final int CONTROLFRAME_T = 2;
    public static final int PROTOCOLCONTROLFRAME_T = 3;
    public static final int VOICEFRAME_T = 4;
    public static final int DTMFFRAME_T = 5;
    protected boolean full;
    protected int srcCallNo;
    protected int type;

    protected Frame() {
    }

    protected Frame(int type, boolean full, int srcCallNo) {
        this.full = full;
        this.srcCallNo = srcCallNo;
        this.type = type;
    }

    protected Frame(int type, byte[] buffer) throws FrameException {
        this.type = type;
        try {
            ByteBuffer byteBuffer = new ByteBuffer(buffer);
            int aux16bits = byteBuffer.get16bits();
            this.full = (aux16bits & 0x8000) != 0;
            this.srcCallNo = aux16bits & Short.MAX_VALUE;
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public int getType() {
        return this.type;
    }

    public boolean getFull() {
        return this.full;
    }

    public int getSrcCallNo() {
        return this.srcCallNo;
    }

    public byte[] serialize() throws FrameException {
        try {
            ByteBuffer byteBuffer = new ByteBuffer(2);
            int aux16bits = (this.full ? 32768 : 0) + (this.srcCallNo & Short.MAX_VALUE);
            byteBuffer.put16bits(aux16bits);
            return byteBuffer.getBuffer();
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }
}

