/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.call.state;

import iax.protocol.call.Call;
import iax.protocol.call.command.recv.CallCommandRecvFacade;
import iax.protocol.call.state.CallState;
import iax.protocol.call.state.Initial;
import iax.protocol.call.state.Linked;
import iax.protocol.frame.Frame;
import iax.protocol.frame.ProtocolControlFrame;

public class Waiting
extends CallState {
    private static Waiting instance;

    private Waiting() {
        instance = this;
    }

    public static Waiting getInstance() {
        if (instance != null) {
            return instance;
        }
        return new Waiting();
    }

    public void handleRecvFrame(Call call, Frame frame) {
        try {
            if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 7: {
                        CallCommandRecvFacade.accept(call, protocolControlFrame);
                        call.setState(Linked.getInstance());
                        break;
                    }
                    case 8: {
                        CallCommandRecvFacade.authReq(call, protocolControlFrame);
                        call.bindCall(protocolControlFrame.getSrcCallNo());
                        break;
                    }
                    case 6: {
                        CallCommandRecvFacade.reject(call, protocolControlFrame);
                        call.setState(Initial.getInstance());
                        call.endCall();
                        break;
                    }
                    default: {
                        super.handleRecvFrame(call, frame);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleSendFrame(Call call, Frame frame) {
        try {
            if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 9: {
                        call.sendFullFrameAndWaitForRep(protocolControlFrame);
                        break;
                    }
                    default: {
                        super.handleSendFrame(call, frame);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

