/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.call.command.send;

import iax.protocol.call.Call;
import iax.protocol.call.command.send.CallCommandSend;
import iax.protocol.frame.ProtocolControlFrame;
import iax.protocol.util.Converter;
import iax.protocol.util.FrameUtil;

public class AuthRep
implements CallCommandSend {
    private static final int MD5_SIZE = 16;
    private Call call;
    private ProtocolControlFrame authReqFrame;

    public AuthRep(Call call, ProtocolControlFrame authReqFrame) {
        this.call = call;
        this.authReqFrame = authReqFrame;
    }

    public void execute() {
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        try {
            String userName = this.authReqFrame.getUserName();
            int auth = this.authReqFrame.getAuthMethods();
            String challenge = this.authReqFrame.getChallenge();
            if (userName.equals(this.call.getPeer().getUserName())) {
                String password = this.call.getPeer().getPassword();
                ProtocolControlFrame authRepFrame = new ProtocolControlFrame(this.call.getSrcCallNo(), false, this.call.getDestCallNo(), this.call.getTimestamp(), this.call.getOseqno(), this.call.getIseqno(), false, 9);
                authRepFrame.setUserName(userName);
                switch (auth) {
                    case 2: 
                    case 3: {
                        password = Converter.byteArrayToHexString(FrameUtil.md5(challenge.getBytes(), password.getBytes()));
                        authRepFrame.setMD5Result(password);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        authRepFrame.setMD5Result(password);
                        break;
                    }
                }
                this.call.handleSendFrame(authRepFrame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

