/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ShapeUtilities;
import org.opengion.hayabusa.io.HybsCategoryAxis;
import org.opengion.hayabusa.io.HybsDrawItem;
import org.opengion.hayabusa.io.HybsJDBCCategoryDataset2;
import org.opengion.hayabusa.io.ValueMarkOverColors;

public class HybsLineRenderer
extends LineAndShapeRenderer
implements HybsDrawItem {
    private static final long serialVersionUID = 4110L;
    private transient ValueMarkOverColors overColors = null;
    private Color[] shapeColors = null;
    private double visibleLimit = Double.NEGATIVE_INFINITY;
    private int dynamicOCNo = -1;
    private String shapeScale = null;
    private boolean isItemLabelLastVisible = false;
    private final int hsCode = Long.valueOf(System.nanoTime()).hashCode();

    public HybsLineRenderer() {
        super(true, true);
    }

    public HybsLineRenderer(boolean bl, boolean bl2) {
        super(bl, bl2);
    }

    protected void setShapeColors(Color[] colorArray) {
        this.shapeColors = colorArray;
    }

    protected void setShapeScale(String string) {
        this.shapeScale = string;
    }

    protected void setValueMarkOverColors(ValueMarkOverColors valueMarkOverColors, int n) {
        this.overColors = valueMarkOverColors;
        this.dynamicOCNo = n;
    }

    protected void setVisibleLimit(double d) {
        this.visibleLimit = d;
    }

    @Override
    public void setItemLabelLastVisible(boolean bl) {
        this.isItemLabelLastVisible = bl;
    }

    @Override
    public void drawItem2(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n) {
        Stroke stroke;
        int n2 = categoryDataset.getColumnCount();
        int n3 = categoryDataset.getRowCount();
        RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
        boolean bl = this.getBaseShapesVisible();
        HybsCategoryAxis hybsCategoryAxis = null;
        if (categoryAxis instanceof HybsCategoryAxis) {
            hybsCategoryAxis = (HybsCategoryAxis)categoryAxis;
            hybsCategoryAxis.setItemLabelLastVisible(this.isItemLabelLastVisible);
        }
        int n4 = this.shapeColors == null ? 1 : this.shapeColors.length;
        int n5 = 0;
        AffineTransform affineTransform = null;
        if (this.shapeScale != null) {
            double d = Double.parseDouble(this.shapeScale);
            affineTransform = AffineTransform.getScaleInstance(d, d);
        }
        if ((stroke = this.getBaseStroke()) != null) {
            graphics2D.setStroke(stroke);
        }
        for (int i = 0; i <= n3; ++i) {
            Stroke stroke2;
            if (i == n) continue;
            if (i >= n3) {
                if (n < 0) break;
                i = n;
                n3 = -1;
            }
            if ((stroke2 = this.getSeriesStroke(i)) != null) {
                graphics2D.setStroke(stroke2);
            }
            Paint paint = this.lookupSeriesPaint(i);
            Shape shape = this.lookupSeriesShape(n5);
            if (affineTransform != null) {
                shape = affineTransform.createTransformedShape(shape);
            }
            Paint paint2 = paint;
            boolean bl2 = false;
            if (i == this.dynamicOCNo) {
                if (this.overColors != null) {
                    paint2 = this.overColors.getDynamicColor();
                }
            } else if (bl || i == n || this.dynamicOCNo >= 0 && i == 0) {
                bl2 = true;
                ++n5;
            }
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            boolean bl3 = this.isSeriesItemLabelsVisible(i);
            int n6 = 0;
            for (int j = 0; j < n2; ++j) {
                Object object;
                Number number = categoryDataset.getValue(i, j);
                if (number == null) continue;
                double d4 = number.doubleValue();
                double d5 = categoryAxis.getCategoryMiddle(j, n2, rectangle2D, rectangleEdge);
                double d6 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge2);
                if (j > 0 && d >= this.visibleLimit && d4 >= this.visibleLimit) {
                    Line2D.Double double_ = new Line2D.Double(d2, d3, d5, d6);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(double_);
                }
                if (bl2) {
                    Paint paint3;
                    if (hybsCategoryAxis != null && hybsCategoryAxis.isLabelBreak(j)) {
                        n6 = 0;
                    }
                    int n7 = n6 % n4;
                    ++n6;
                    Paint paint4 = paint3 = this.shapeColors == null ? paint : this.shapeColors[n7];
                    if (this.overColors != null) {
                        paint3 = this.dynamicOCNo >= 0 ? this.overColors.getColor(d4, categoryDataset.getValue(this.dynamicOCNo, j)) : this.overColors.getColor(d4);
                    }
                    graphics2D.setPaint(paint3);
                    object = ShapeUtilities.createTranslatedShape((Shape)shape, (double)d5, (double)d6);
                    graphics2D.fill((Shape)object);
                    graphics2D.setPaint(paint);
                    EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
                    if (entityCollection != null) {
                        this.addItemEntity(entityCollection, categoryDataset, i, j, (Shape)object);
                    }
                }
                if (bl3 && hybsCategoryAxis != null && hybsCategoryAxis.isViewItemLabel(j)) {
                    double d7 = d;
                    if (j + 1 < n2 && (object = categoryDataset.getValue(i, j + 1)) != null) {
                        d7 = ((Number)object).doubleValue();
                    }
                    boolean bl4 = d4 < d7;
                    double d8 = bl4 && d < d4 || !bl4 && d > d4 ? d5 + 10.0 : d5;
                    this.drawItemLabel(graphics2D, PlotOrientation.VERTICAL, categoryDataset, i, j, d8, d6, bl4);
                }
                d = d4;
                d2 = d5;
                d3 = d6;
            }
        }
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return this.hsCode == ((HybsLineRenderer)object).hsCode;
        }
        return false;
    }

    public int hashCode() {
        return this.hsCode;
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (categoryDataset instanceof HybsJDBCCategoryDataset2) {
            return ((HybsJDBCCategoryDataset2)categoryDataset).getRange();
        }
        return DatasetUtilities.findRangeBounds((CategoryDataset)categoryDataset);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

