/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_TABLE;
import org.opengion.fukurou.util.StringUtil;

/**
 * アンケート回答  (OP1003A) の 業務ロジックです。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class OP1003A extends BizLogic_TABLE {

	private int	mcnt	= 1;

	/**
	 * メインカーソルの各行(変更区分の各処理の後)で呼ばれるチェックロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean allchk( final int row ) {
		return true;
	}

	/**
	 * メインカーソルの一番初めで呼ばれるロジックを定義します。
	 * ここでは何も実装されていません。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean first() {
		return true;
	}

	/**
	 * メインカーソルの各行(変更区分の各処理の後)で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean allrow( final int row ) {
		if( row == 0 ) {
			sql( "select nextval('AN11S01') PGSEQ" );
			set( "NOKAITO", "K" + StringUtil.intFill( var( "PGSEQ" ), 9 ) );

			String insAN11 = "insert into AN11("
				+ "NOKAITO,USERID,CDANK,KIPADDR,DYKAITO,KUID"
				+ ",FGJ,DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD"
				+ ") values ("
				+ "'{@NOKAITO}',[USERID],[CDANK],'{@IPADDRESS}','{@CON.YMDH}','{@CON.USERID}'"
				+ ",'1','{@CON.YMDH}','{@CON.USERID}','{@CON.PGID}','{@CON.PGPID}','{@CON.YMDH}','{@CON.USERID}','{@CON.PGID}','{@CON.PGPID}'"
				+ ")";

			sql( insAN11 );
		}

		String[] kvalArr = StringUtil.csv2Array( var( "AN_" + line( "CDANK" ) + "_" + line( "CDSITSU" ) ) );
		for( String kval : kvalArr ) {
			if( kval == null || kval.length() == 0 ) { continue; }

			set( "KVAL", kval );
			set( "KNAME", null );
			set( "IMGKVAL", null );
			set( "FGOTHER", "0" );

			set( "KVAL_TMP", null );

			// その他で、自由入力された回答の処理
			String sql = "select count(*) CNT from AN03"
				+ " where USERID = [USERID]"
				+ " and CDANK = [CDANK]"
				+ " and CDSITSU = [CDSITSU]"
				+ " and FGJ = '1'";
			sql( sql );

			sql = "select KVAL KVAL_TMP,KNAME,IMGKVAL from AN03"
				+ " where USERID = [USERID]"
				+ " and CDANK = [CDANK]"
				+ " and CDSITSU = [CDSITSU]"
				+ " and KVAL = '{@KVAL}'"
				+ " and FGJ = '1'";
			sql( sql );

			// 選択項目で定義されている質問 かつ 回答内容の値が選択項目として定義されていない場合は、その他とみなす
			if( vari( "CNT" ) > 0 && ( var( "KVAL_TMP" ) == null || var( "KVAL_TMP" ).length() == 0 ) ) {
				set( "FGOTHER", "1" );
			}

			set( "NOMEISAI", mcnt );
			String insAN12 = "insert into AN12("
				+ "NOKAITO,NOMEISAI,USERID,CDANK,CDSITSU,KVAL,KNAME,FGOTHER"
				+ ",FGJ,DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD"
				+ ") values ("
				+ "'{@NOKAITO}','{@NOMEISAI}',[USERID],[CDANK],[CDSITSU],'{@KVAL}','{@KNAME}','{@FGOTHER}'"
				+ ",'1','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}'"
				+ ")";
			sql( insAN12 );
			mcnt++;
		}

		return true;
	}
}
