/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_TABLE;
import org.opengion.fukurou.util.StringUtil;

/**
 * アンケート項目詳細登録  (AN0004) の 業務ロジックです。
 * 
 * ここでは、アンケート項目詳細マスタ(AN03)の追加・変更・削除を行っています。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class AN0004A extends BizLogic_TABLE {

	/**
	 * メインカーソルの各行(変更区分="A")で呼ばれるチェックロジックを定義します。
	 * ここでは何も実装されていません。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean inschk( final int row ) {
		return true;
	}

	/**
	 * メインカーソルの各行(変更区分="C")で呼ばれるチェックロジックを定義します。
	 * ここでは何も実装されていません。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean modchk( final int row ) {
		return true;
	}

	/**
	 * メインカーソルの各行(変更区分="D")で呼ばれるチェックロジックを定義します。
	 * ここでは何も実装されていません。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean delchk( final int row ) {
		return true;
	}

	/**
	 * メインカーソルの各行(変更区分="A")で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean insert( final int row ) {
		sql( "select nextval('AN03S01') PGSEQ" );
		set( "KVAL", "V" + StringUtil.intFill( var( "PGSEQ" ), 9 ) );

		String sql = "insert into AN03("
			+ "USERID,CDANK,CDSITSU,KVAL,SEQNO,KNAME,IMGKVAL,FGOTHER"
			+ ",BIKO,FGJ,DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD"
			+ ") values ("
			+ "'{@CON.USERID}','{@CDANK}',[CDSITSU],'{@KVAL}',[SEQNO],[KNAME],[IMGKVAL],[FGOTHER]"
			+ ",'','1','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}'"
			+ ")";
		sql( sql );

		return true;
	}

	/**
	 * メインカーソルの各行(変更区分="C")で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean modify( final int row ) {
		String sql = "update AN03 set"
			+ " SEQNO = [SEQNO]"
			+ ",KNAME = [KNAME]"
			+ ",IMGKVAL = [IMGKVAL]"
			+ ",FGOTHER = [FGOTHER]"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGPID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ "where UNIQ = [UNIQ]";
		sql( sql );
		return true;
	}

	/**
	 * メインカーソルの各行(変更区分="D")で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean delete( final int row ) {
		String sql = "update AN03 set"
			+ " FGJ = '9'"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGPID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ "where UNIQ = [UNIQ]";
		sql( sql );
		return true;
	}
}

