/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import java.io.File;

import org.opengion.fukurou.business.BizLogic_TABLE;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.hayabusa.common.HybsSystem;

/**
 * アンケート情報登録  (AN0001) の 業務ロジックです。
 * 
 * ここでは、仮登録されたデータ・ファイルの削除を行っています。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class AN0001D extends BizLogic_TABLE {

	/**
	 * メインカーソルの各行(変更区分の各処理の後)で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean allrow( final int row ) {

		// アンケートマスタの削除
		String sql = "delete from AN01 where USERID='{@CON.USERID}' and CDANK=[CDANK] and FGJ='0'";
		sql( sql );

		// アンケート項目マスタの削除
		sql = "delete from AN02 where USERID='{@CON.USERID}' and CDANK=[CDANK] and FGJ='0'";
		sql( sql );

		// アンケート項目明細マスタの削除
		sql = "delete from AN03 where USERID='{@CON.USERID}' and CDANK=[CDANK] and FGJ='0'";
		sql( sql );

		// リソース(カラム、ラベル)の削除
		boolean rtn = call( "an.ColumnRes", "CDANK,CDKH", "[CDANK],X" );
		if( !rtn ) { return false; }

		// 画像ファイルの削除
		FileUtil.deleteFiles(
			new File (
				HybsSystem.sys( "REAL_PATH" ) + "ankimages" + File.separator + line( "CDANK" )
			)
		);

		return true;
	}
}
