/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_ENTRY;

/**
 * アンケート情報登録  (AN0001) の 業務ロジックです。
 * 
 * ここでは、仮登録されたデータを確定(FGJ='1')に更新しています。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */

public class AN0001A2 extends BizLogic_ENTRY {

	/**
	 * チェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean check() {
		return must( "CDANK" );
	}

	/**
	 * メイン処理を定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean logic() {
		String sql = "update AN01 set"
			+ " NMANK = '{@NMANK}'"
			+ ",FGKOKAI = '{@FGKOKAI}'"
			+ ",DYKSTR = '{@DYKSTR}'"
			+ ",DYKEND = '{@DYKEND}'"
			+ ",FGJ = '1'"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ "where CDANK = '{@CDANK}'";
		sql( sql );

		sql = "update AN02 set"
			+ " FGJ = '1'"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ "where CDANK = '{@CDANK}'";
		sql( sql );

		sql = "update AN03 set"
			+ " FGJ = '1'"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ "where CDANK = '{@CDANK}'";
		sql( sql );

		return true;
	}
}

