var notInit = false;

/**
 * イベントカラムが設定されたタグ(spanタグ)を検索し、親カラムにイベントを登録します。
 *
 * @og.rev 5.1.7.0 (2010/06/01) 新規作成(動的プルダウン実装見直し)
 *
**/
function setColEvnets() {
	var jEvElm = $(".h_evElm")
	jEvElm.each( function(i) {
		var jTag = $(this);
		var cid = $(this).attr("h_evCid");
		var cname = cid.split("__")[0];
		var suffix = ( cid == cname ? "" : "__" + cid.split("__")[1] );
		var writable = $(this).attr("h_evWrtbl");

		var evColArr = eval( "EC_" + cname + "_EVCOL" ).split(",");
		for( var i=0; i<evColArr.length; i++ ) {
			var evColId = evColArr[i] + suffix;
			var isFireEvent = true;
			if( evColId.charAt(0) == "_" ) {
				isFireEvent = false;
				evColId = evColId.substring(1);
			}

			var jEvCol = $("#"+evColId);
			$("#"+evColId).filter("select,input[type=text],textarea")
				.change( function(){
					makeColumn( $(this), jTag, cid, cname, suffix, writable );
				}).filter(function(){ return isFireEvent; })
				.addClass( "h_evDummyChange" );
			$("#"+evColId).filter("input[type=checkbox],input[type=radio]")
				.click( function(){
					makeColumn( $(this), jTag, cid, cname, suffix, writable );
				}).filter(function(){ return isFireEvent; })
				.addClass( "h_evDummyClick" );
//			$("#"+evColId).filter("")
//				.blur( function(){
//					var curval = $(this).val();
//					var oldval = $(this).attr("oldval");
//					$(this).attr("oldval",curval);
//					if( !curval || !oldval || curval != oldval ) {
//						makeColumn( $(this), jTag, cid, cname, suffix, writable );
//					}
//				}).addClass( "h_evDummyBlur" );
		}
	});

// 5.1.7.0 (2010/06/01) カラム指定で初回イベント発行を対応させる必要があるか?...要検討
	if( jEvElm.length > 0 ) {
		$(".h_evDummyChange").change();
		$(".h_evDummyClick").click();
//		$(".h_evDummyBlur").blur();
		$('table#viewTable').resizeView();
	}
	notInit = true;
}

/**
 * Ajax動的カラム変更用の共通JavaScript
 * 
 * カラムにeventColumnをセットした時に親側にID指定でChangeイベントとして登録されます。
 * ※イベント処理用のJSP用に送られるパラメーターに関しては、jsp/common/eventColumnMaker.jspの
 *   コメントを参照して下さい。
 *
 * @og.rev 5.1.7.0 (2010/06/01) 動的プルダウン実装見直し
 *
 * @param jEvCol	イベントが発生した親カラムのjQueryオブジェクト
 * @param jTag		置き換え要素をラップしたspanタグのjQueryオブジェクト
 * @param cid		変更対象の子要素(inputタグなど)のID
 * @param cname		子のカラム名
 * @param suffix	__ + 行番号(一覧表示の場合のみ)
 * @param writable	書き込み可能かどうか
**/
function makeColumn( jEvCol, jTag, cid, cname, suffix, writable ){
	if( !jTag || jTag.length == 0 ) {
		alert( "[SYSTEM_ERROR] : イベントカラムで置き換え対象の要素が存在しません" );
		return;
	}

//	if( cid == null || cid == "" || cname == null || cname == "" ) {
//		alert( "[SYSTEM_ERROR] : 子要素のIDまたはNAMEがセットされていません" );
//		return;
//	}

	if( !notInit ) {
		var evVal = jEvCol.val();
		if( !evVal || evVal == null || evVal == "" ) { return; }
	}

	try {
		var url = eval( "EC_" + cname + "_URL" );
	}
	catch( e ) {
		alert( "[SYSTEM_ERROR] : イベントを処理するURLが指定されていません。(変数未定義)" );
		return;
	}
	if( !url || url == "" ) {
		alert( "[SYSTEM_ERROR] : イベントを処理するURLが指定されていません。" );
		return;
	}

	// SQL文をパースして{@xxx}をxxxのvalue値に変更する。一覧での利用では同一行のカラムになる。
	//（リクエスト変数はテキストボックスで一度受ける必要がある）
	// 又、パースして得られたvalue値をJSPのリクエスト変数としてURLの後ろに付ける
	var param = "";
	try { param = ( writable ? eval( "EC_" + cname + "_EDITPARAM" ) : eval( "EC_" + cname + "_RENDPARAM" ) ); } catch( e ) {}
	if( param != null && param != "" ) {
		url += "?";
		var _pos1 = 0, _pos2 = 0, _repClm, _rep, _clm;
		while( (_pos1 = param.indexOf("{@",_pos2)) != -1){
			_pos2 = param.indexOf("}",_pos1);
			_clm = param.substring(_pos1+2,_pos2);
			if( _clm.indexOf(".") < 0 ) {
				_repClm = "{@"+_clm+"}";
				_rep = suffix == "" ? $('#'+_clm).val() : $('#'+_clm+suffix).val();
				_rep = ( _rep == null ? "" : _rep );
				param = param.replace(_repClm,_rep);
				url += _clm + "=" +  encodeURIComponent(_rep) +"&";
			}
			_pos2 = _pos1+1; // 4.3.6.2 (2009/04/15)
		}
	}

	// 子がSelectタグの場合、最上部に空のoptionが存在すればEC_NOVALUEをtrueで送る
	var noVal = function(){
		_firstOption = jCol.children('option').get(0);
		if( _firstOption == null || _firstOption.value != "" ){ return false; }
		return true;
	}

	// 4.3.6.5 (2009/05/08) must,mustAnyを引数でJSPに送る。
//	var mustOrMustAny = function(){
//		var _haveClasses = jCol.attr("class");
//		if( _haveClasses && _haveClasses.indexOf("must") >= 0 ){
//			if( _haveClasses.indexOf("mustAny") >= 0 )	{ return "mustAny"; }
//			else										{ return "must"; }
//			return "";
//		}
//	}

	var columnFocus = function() {
		jCol.attr("isfocus","true");
	}

	if( cid != null && cid != "" ) {
		var jCol = jTag.find( "#"+cid );
	}
	else {
		var jCol = new Array(0)
	}

	if( jCol.length > 0 && notInit ) {
		jCol.bind("focus",columnFocus);
	}

	var val = "";
	if( jCol.length > 0 ) {
		if( notInit )	{ val = ( jCol.val() == null ? "" : jCol.val() ); }
		else			{ val = ( jTag.attr( "h_evVal" ) == null ? "" : jTag.attr( "h_evVal" ) ); }
	}

	var renderer = "";
	try { renderer = eval( "EC_" + cname + "_RENDERER" ); } catch( e ) {}

	var editor = "";
	try { editor = eval( "EC_" + cname + "_EDITOR" ); } catch( e ) {}

	// JSPを呼び出して処理する
	$.ajax({
		url: url,
		data: {
			"EC_CID"		: ( cid == null ? "" : cid ),
			"EC_CNAME"		: ( cname == null ? "" : cname ),
			"EC_RENDERER"	:renderer,
			"EC_EDITOR"		: editor,
			"EC_PARAM"		: param,
			"EC_SQL"		: param,
			"EC_WRITABLE"	: ( writable == null ? "" : writable ),
			"EC_CVALUE"		: val,
			"EC_NOVALUE"	: ( jCol.length == 0 ? "" : noVal() ),
//			"EC_MUST"		: ( jCol.length == 0 ? "" : mustOrMustAny() ),
			"EC_CLASS"		: ( jCol.length == 0 ? "" : jCol.attr("class") ),
			"EC_STYLE"		: ( jCol.length == 0 ? "" : jCol.attr("style") ),
			"EC_SIZE"		: ( jCol.length == 0 ? "" : jCol.attr("size") ),
			"EC_MAXLENGTH"	: ( jCol.length == 0 ? "" : jCol.attr("maxlength") )
		},
		type: 'POST',
		dataType: 'html',
		async : notInit,
		error: function(r,s,e){
			alert('EventColumnError:'+r+':'+s+':'+e+':'+cname);
		},
		success: function(data,status){
			var jNewCol = $(data);

			if( jCol.length > 0 ) {
				if( notInit ) {
					jCol.unbind("focus",columnFocus);
				}
				bindOldEvents( jNewCol.get(0), jQuery.data( jCol.clone(true).get(0),"events" ) );
			}

			jTag.empty().append( jNewCol );

			if( jCol.length > 0 ) {
				jTag.find("input,select,textarea").attr( "name", cid ).attr( "id", cid );

				if( notInit ) {
					// 置き換え先の要素にフォーカスが当たっていた場合は、フォーカスを復活
					if( jCol.attr("isfocus") ) {
//						jNewCol.focus();
						jNewCol.get(0).focus();
						// IEの場合、置き換え先の要素がテキストボックスの場合は、もう１度フォーカスする必要がある。
						if( $.browser.msie ) {
							jNewCol.get(0).focus();
						}
					}
				}
				// 初回読み込み時に置き換えられた要素はchangeイベントを発行
				if( !notInit ) {
					jNewCol.change();
				}
			}

			// ヘッダー固定再計算(処理が重いので、見直しの必要あり)
			if( suffix != null && suffix != "" ) {
				$('table#viewTable').resizeView();
			}
		}
	});
}

function bindOldEvents( newCol, oldEvents ) {
	for ( var type in oldEvents ) {
		for ( var handler in oldEvents[type] ) {
			jQuery.event.add( newCol, type, oldEvents[type][handler], oldEvents[type][handler].data );
		}
	}
}
