/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.WeakHashMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.jdbc.JDBCCategoryDataset;
import org.jfree.data.jdbc.JDBCPieDataset;
import org.jfree.data.jdbc.JDBCXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.TableOrder;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class JFreeChartTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private static final Map<String, FileCache> cache = new WeakHashMap<String, FileCache>();
    private static final String[] CHART_LIST = new String[]{"Bar", "XYLine", "Pie", "Pie3D", "Area", "Bar3D", "Line", "Line3D", "MultiplePie", "MultiplePie3D", "Polar", "StackedArea", "StackedBar", "StackedBar3D", "TimeSeries", "Waterfall", "XYArea", "XYStepArea", "XYStep"};
    private final String FILE_URL = HybsSystem.sys("CHART_TEMP_DIR");
    private String dbid = null;
    private String chartClass = null;
    private String title = null;
    private String width = "200";
    private String height = "200";
    private boolean legend = true;
    private boolean tooltips = true;
    private boolean urls = true;
    private String sql = null;
    private String xlabel = null;
    private String ylabel = null;
    private String orientation = "VERTICAL";
    private int cacheTime = -1;

    @Override
    public int doStartTag() {
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.sql = this.getBodyString();
        if (this.sql != null && this.sql.length() > 0) {
            this.sql = this.sql.trim();
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        Object object;
        this.debugPrint();
        String string = null;
        String string2 = null;
        if (this.cacheTime > 0 && (object = cache.get(string2 = this.chartClass + this.sql)) != null && (string = ((FileCache)object).getFileURL()) == null) {
            cache.remove(string2);
        }
        if (string == null) {
            object = this.getTempFile(this.FILE_URL);
            this.create((File)object, this.sql);
            string = this.getContextPath() + "/" + this.FILE_URL + ((File)object).getName();
            if (this.cacheTime > 0) {
                FileCache fileCache = new FileCache(string, this.cacheTime);
                cache.put(string2, fileCache);
            }
        }
        this.jspPrint(this.makeTag(string));
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.dbid = null;
        this.chartClass = null;
        this.title = null;
        this.width = "200";
        this.height = "200";
        this.legend = true;
        this.tooltips = true;
        this.urls = true;
        this.orientation = "VERTICAL";
        this.sql = null;
        this.xlabel = null;
        this.ylabel = null;
        this.cacheTime = -1;
    }

    protected String makeTag(String string) {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<img width = \"").append(this.width).append("\"");
        stringBuilder.append(" height = \"").append(this.height).append("\"");
        stringBuilder.append(" src=\"").append(string).append("\" /> ");
        return stringBuilder.toString();
    }

    private void create(File file, String string) {
        JFreeChart jFreeChart = null;
        Connection connection = null;
        boolean bl = true;
        PlotOrientation plotOrientation = this.orientation.startsWith("V") ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL;
        try {
            JDBCCategoryDataset jDBCCategoryDataset;
            connection = ConnectionFactory.connection((String)this.dbid, (ApplicationInfo)this.getApplicationInfo());
            if ("Area".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCCategoryDataset(connection, this.sql);
                jFreeChart = ChartFactory.createAreaChart((String)this.title, (String)this.xlabel, (String)this.ylabel, (CategoryDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            }
            if ("StackedArea".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCCategoryDataset(connection, this.sql);
                jFreeChart = ChartFactory.createStackedAreaChart((String)this.title, (String)this.xlabel, (String)this.ylabel, (CategoryDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("Bar".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCCategoryDataset(connection, this.sql);
                jFreeChart = ChartFactory.createBarChart((String)this.title, (String)this.xlabel, (String)this.ylabel, (CategoryDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("Bar3D".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCCategoryDataset(connection, this.sql);
                jFreeChart = ChartFactory.createBarChart3D((String)this.title, (String)this.xlabel, (String)this.ylabel, (CategoryDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("StackedBar".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCCategoryDataset(connection, this.sql);
                jFreeChart = ChartFactory.createStackedBarChart((String)this.title, (String)this.xlabel, (String)this.ylabel, (CategoryDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("StackedBar3D".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCCategoryDataset(connection, this.sql);
                jFreeChart = ChartFactory.createStackedBarChart3D((String)this.title, (String)this.xlabel, (String)this.ylabel, (CategoryDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("Line".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCCategoryDataset(connection, this.sql);
                jFreeChart = ChartFactory.createLineChart((String)this.title, (String)this.xlabel, (String)this.ylabel, (CategoryDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("Line3D".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCCategoryDataset(connection, this.sql);
                jFreeChart = ChartFactory.createLineChart3D((String)this.title, (String)this.xlabel, (String)this.ylabel, (CategoryDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("Line3D".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCCategoryDataset(connection, this.sql);
                jFreeChart = ChartFactory.createLineChart3D((String)this.title, (String)this.xlabel, (String)this.ylabel, (CategoryDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("Waterfall".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCCategoryDataset(connection, this.sql);
                jFreeChart = ChartFactory.createWaterfallChart((String)this.title, (String)this.xlabel, (String)this.ylabel, (CategoryDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("MultiplePie".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCCategoryDataset(connection, this.sql);
                jFreeChart = ChartFactory.createMultiplePieChart((String)this.title, (CategoryDataset)jDBCCategoryDataset, (TableOrder)TableOrder.BY_COLUMN, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("MultiplePie3D".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCCategoryDataset(connection, this.sql);
                jFreeChart = ChartFactory.createMultiplePieChart3D((String)this.title, (CategoryDataset)jDBCCategoryDataset, (TableOrder)TableOrder.BY_COLUMN, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("Pie".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCPieDataset(connection, this.sql);
                jFreeChart = ChartFactory.createPieChart((String)this.title, (PieDataset)jDBCCategoryDataset, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("Pie3D".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCPieDataset(connection, this.sql);
                jFreeChart = ChartFactory.createPieChart3D((String)this.title, (PieDataset)jDBCCategoryDataset, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("XYLine".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCXYDataset(connection, this.sql);
                jFreeChart = ChartFactory.createXYLineChart((String)this.title, (String)this.xlabel, (String)this.ylabel, (XYDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("XYArea".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCXYDataset(connection, this.sql);
                jFreeChart = ChartFactory.createXYAreaChart((String)this.title, (String)this.xlabel, (String)this.ylabel, (XYDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("XYStepArea".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCXYDataset(connection, this.sql);
                jFreeChart = ChartFactory.createXYStepAreaChart((String)this.title, (String)this.xlabel, (String)this.ylabel, (XYDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("XYStep".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCXYDataset(connection, this.sql);
                jFreeChart = ChartFactory.createXYStepChart((String)this.title, (String)this.xlabel, (String)this.ylabel, (XYDataset)jDBCCategoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("TimeSeries".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCXYDataset(connection, this.sql);
                jFreeChart = ChartFactory.createTimeSeriesChart((String)this.title, (String)this.xlabel, (String)this.ylabel, (XYDataset)jDBCCategoryDataset, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            } else if ("Polar".equalsIgnoreCase(this.chartClass)) {
                jDBCCategoryDataset = new JDBCXYDataset(connection, this.sql);
                jFreeChart = ChartFactory.createPolarChart((String)this.title, (XYDataset)jDBCCategoryDataset, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            }
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)TaglibUtil.changeInt(this.width), (int)TaglibUtil.changeInt(this.height));
            bl = false;
        }
        catch (SQLException sQLException) {
            String string2 = "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u51e6\u7406\u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + string + HybsSystem.CR + "err=[" + sQLException.getSQLState() + "]" + sQLException.getMessage();
            throw new HybsSystemException(string2, sQLException);
        }
        catch (IOException iOException) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb I/O \u304c\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + file + HybsSystem.CR + iOException.getMessage();
            throw new HybsSystemException(string3, iOException);
        }
        finally {
            if (bl) {
                ConnectionFactory.remove((Connection)connection, (String)this.dbid);
            } else {
                ConnectionFactory.close((Connection)connection, (String)this.dbid);
            }
        }
    }

    private File getTempFile(String string) {
        File file;
        String string2 = HybsSystem.url2dir(string);
        File file2 = new File(string2);
        if (!file2.exists() && !file2.mkdirs()) {
            String string3 = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string2 + "]";
            throw new HybsSystemException(string3);
        }
        try {
            file = File.createTempFile("JFree", ".png", file2);
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            String string4 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002 Url:" + string + HybsSystem.CR + iOException.getMessage();
            throw new HybsSystemException(string4, iOException);
        }
        return file;
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setChartClass(String string) {
        this.chartClass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.chartClass);
        if (!this.check(this.chartClass, CHART_LIST)) {
            String string2 = "\u6307\u5b9a\u306e\u30af\u30e9\u30b9\u306f\u3001\u73fe\u5728\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002[" + string + "]" + HybsSystem.CR + "Chart Class List=[" + StringUtil.array2csv((String[])CHART_LIST) + "]";
            throw new HybsSystemException(string2);
        }
    }

    public void setTitle(String string) {
        this.title = StringUtil.nval((String)this.getRequestParameter(string), (String)this.title);
    }

    public void setWidth(String string) {
        this.width = StringUtil.nval((String)this.getRequestParameter(string), (String)this.width);
    }

    public void setHeight(String string) {
        this.height = StringUtil.nval((String)this.getRequestParameter(string), (String)this.height);
    }

    public void setLegend(String string) {
        this.legend = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.legend);
    }

    public void setTooltips(String string) {
        this.tooltips = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.tooltips);
    }

    public void setUrls(String string) {
        this.urls = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.urls);
    }

    public void setOrientation(String string) {
        this.orientation = StringUtil.nval((String)this.getRequestParameter(string), (String)this.orientation);
    }

    public void setXlabel(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.xlabel);
        if (string2 != null) {
            this.xlabel = this.getLabel(string2);
        }
    }

    public void setYlabel(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.ylabel);
        if (string2 != null) {
            this.ylabel = this.getLabel(string2);
        }
    }

    public void setCacheTime(String string) {
        this.cacheTime = StringUtil.nval((String)this.getRequestParameter(string), (int)this.cacheTime);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("dbid", (Object)this.dbid).println("chartClass", (Object)this.chartClass).println("title", (Object)this.title).println("width", (Object)this.width).println("height", (Object)this.height).println("legend", (Object)this.legend).println("tooltips", (Object)this.tooltips).println("urls", (Object)this.urls).println("sql", (Object)this.sql).println("xlabel", (Object)this.xlabel).println("ylabel", (Object)this.ylabel).println("orientation", (Object)this.orientation).println("cacheTime", (Object)this.cacheTime).println("CHART_LIST", (Object[])CHART_LIST).println("FILE_URL", (Object)this.FILE_URL).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    private static final class FileCache {
        private final long timeLimit;
        private final String fileUrl;

        FileCache(String string, int n) {
            this.fileUrl = string;
            this.timeLimit = (long)n * 1000L + System.currentTimeMillis();
        }

        String getFileURL() {
            if (this.timeLimit > System.currentTimeMillis()) {
                return this.fileUrl;
            }
            return null;
        }
    }
}

