/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;
import org.opengion.fukurou.util.LogWriter;

public class TestCometServlet
extends HttpServlet
implements CometProcessor {
    private static final long serialVersionUID = 400020070911L;
    private static final int TIMEOUT = 1800000;
    private static final String CONTENT_TYPE = "text/html;charset=UTF-8";
    private static final String HTML_HEADER = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<head><title>TestCometServlet Message</title></head>\n<body>";
    private static final String HTML_FOOTER = "</body></html>";
    private transient List<HttpServletResponse> responses = new ArrayList<HttpServletResponse>();

    public void event(CometEvent cometEvent) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = cometEvent.getHttpServletRequest();
        System.out.println(httpServletRequest.getMethod() + " : " + cometEvent.getEventType());
        if ("POST".equals(httpServletRequest.getMethod())) {
            this.callPOST(httpServletRequest);
            cometEvent.close();
        } else {
            HttpServletResponse httpServletResponse = cometEvent.getHttpServletResponse();
            httpServletResponse.setContentType(CONTENT_TYPE);
            PrintWriter printWriter = httpServletResponse.getWriter();
            switch (cometEvent.getEventType()) {
                case BEGIN: {
                    cometEvent.setTimeout(1800000);
                    this.callBEGIN(printWriter);
                    this.addResponce(httpServletResponse);
                    this.callPOST(httpServletRequest);
                    break;
                }
                case READ: {
                    this.removeResponce(httpServletResponse);
                    this.callREAD(printWriter);
                    cometEvent.close();
                    break;
                }
                case END: {
                    this.removeResponce(httpServletResponse);
                    this.callEND(printWriter);
                    cometEvent.close();
                    break;
                }
                case ERROR: {
                    this.removeResponce(httpServletResponse);
                    this.callERROR(printWriter);
                    cometEvent.close();
                    break;
                }
                default: {
                    this.removeResponce(httpServletResponse);
                    cometEvent.close();
                }
            }
        }
    }

    private void callPOST(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("user");
        String string2 = httpServletRequest.getParameter("message");
        System.out.println(string + "> " + string2);
        if (string != null) {
            this.sendMessage(string + "> " + string2 + "<br/>");
        }
    }

    private void callBEGIN(PrintWriter printWriter) {
        System.out.println("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u78ba\u7acb");
        printWriter.println(HTML_HEADER);
        printWriter.println("\u3088\u3046\u3053\u305d\u3001\u304a\u8d8a\u3057\u304f\u3060\u3055\u3044\u307e\u3057\u305f\u3002comet \u306e\u5b9f\u9a13\u30b3\u30fc\u30ca\u30fc\u3067\u3059\u3002<br/>");
        printWriter.println("\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u306f\u3001\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u6210\u7acb\u30e6\u30fc\u30b6\u30fc\u306b\u306e\u307f\u3001\u8fd4\u4fe1\u3057\u3066\u3044\u307e\u3059\u3002<br/>");
        printWriter.flush();
    }

    private void callREAD(PrintWriter printWriter) {
        System.out.println("\u30c7\u30fc\u30bf\u5165\u529b");
        printWriter.println(HTML_FOOTER);
    }

    private void callEND(PrintWriter printWriter) {
        System.out.println("\u30ea\u30af\u30a8\u30b9\u30c8\u7d42\u4e86");
        printWriter.println(HTML_FOOTER);
    }

    private void callERROR(PrintWriter printWriter) {
        System.out.println("\u30a8\u30e9\u30fc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResponce(HttpServletResponse httpServletResponse) {
        List<HttpServletResponse> list = this.responses;
        synchronized (list) {
            this.responses.add(httpServletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeResponce(HttpServletResponse httpServletResponse) {
        List<HttpServletResponse> list = this.responses;
        synchronized (list) {
            this.responses.remove(httpServletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String string) {
        HttpServletResponse[] httpServletResponseArray;
        Object object = this.responses;
        synchronized (object) {
            httpServletResponseArray = this.responses.toArray(new HttpServletResponse[this.responses.size()]);
        }
        if (httpServletResponseArray != null) {
            for (int i = 0; i < httpServletResponseArray.length; ++i) {
                try {
                    object = httpServletResponseArray[i].getWriter();
                    ((PrintWriter)object).println(string);
                    ((PrintWriter)object).flush();
                    continue;
                }
                catch (IOException iOException) {
                    LogWriter.log((Throwable)iOException);
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.responses = new ArrayList<HttpServletResponse>();
    }
}

