/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.util.ArrayList;
import java.util.List;
import org.opengion.fukurou.xml.OGElement;
import org.opengion.fukurou.xml.OGNodeType;

public class OGNode {
    private static final String TABS = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    private final List<OGNode> nodes = new ArrayList<OGNode>();
    private final String text;
    private OGNodeType nodeType;
    private OGNode parentNode = null;

    public OGNode() {
        this.text = null;
        this.nodeType = OGNodeType.List;
    }

    public OGNode(String string) {
        this.text = string == null ? "" : string;
        this.nodeType = OGNodeType.Text;
    }

    public OGNode addNode(String string) {
        OGNode oGNode = new OGNode(string);
        oGNode.parentNode = this;
        this.nodes.add(oGNode);
        return this;
    }

    public OGNode addNode(OGNode oGNode) {
        oGNode.parentNode = this;
        this.nodes.add(oGNode);
        return this;
    }

    public OGNode addTabNode(int n) {
        this.nodes.add(new OGNode(TABS.substring(0, n)));
        return this;
    }

    public OGNode addTabNode(int n, OGNode oGNode) {
        this.nodes.add(new OGNode(TABS.substring(0, n)));
        oGNode.parentNode = this;
        this.nodes.add(oGNode);
        return this;
    }

    public int nodeSize() {
        return this.nodes.size();
    }

    public OGNode getNode(int n) {
        return this.nodes.get(n);
    }

    public void setNode(int n, OGNode oGNode) {
        this.nodes.set(n, oGNode);
    }

    public OGNode getParentNode() {
        return this.parentNode;
    }

    public OGNode removeNode(int n) {
        return this.nodes.remove(n);
    }

    public void clearNode() {
        this.nodes.clear();
    }

    public void changeNode(OGNode oGNode, OGNode oGNode2) {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            OGNode oGNode3 = this.nodes.get(i);
            if (oGNode3.equals(oGNode)) {
                this.nodes.set(i, oGNode2);
                continue;
            }
            oGNode3.changeNode(oGNode, oGNode2);
        }
    }

    public List<OGElement> getChildElementList() {
        ArrayList<OGElement> arrayList = new ArrayList<OGElement>();
        for (OGNode oGNode : this.nodes) {
            if (oGNode.nodeType != OGNodeType.Element) continue;
            arrayList.add((OGElement)oGNode);
        }
        return arrayList;
    }

    public List<OGElement> getElementList(String string) {
        ArrayList<OGElement> arrayList = new ArrayList<OGElement>();
        for (OGNode oGNode : this.nodes) {
            if (oGNode.nodeType != OGNodeType.Element) continue;
            OGElement oGElement = (OGElement)oGNode;
            if (string.equals(oGElement.getTagName())) {
                arrayList.add(oGElement);
            }
            arrayList.addAll(oGElement.getElementList(string));
        }
        return arrayList;
    }

    public String getText() {
        String string;
        if (this.text != null) {
            string = this.text;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (OGNode oGNode : this.nodes) {
                stringBuilder.append(oGNode.toString());
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public void setNodeType(OGNodeType oGNodeType) {
        if (oGNodeType != null) {
            this.nodeType = oGNodeType;
        }
    }

    public OGNodeType getNodeType() {
        return this.nodeType;
    }

    public String toString() {
        String string;
        switch (this.nodeType) {
            case Comment: {
                string = "<!--" + this.getText() + "-->";
                break;
            }
            case Cdata: {
                string = "<![CDATA[" + this.getText() + "]]>";
                break;
            }
            default: {
                string = this.getText();
            }
        }
        return string;
    }
}

