/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.opengion.fukurou.util.Closer;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.plugin.io.HeaderData;
import org.opengion.plugin.io.TableReader_Default;

public class TableReader_Excel
extends TableReader_Default {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private String sheetName = null;
    private String filename = null;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void readDBTable() {
        FileInputStream fileInputStream = null;
        try {
            Sheet sheet;
            fileInputStream = new FileInputStream(this.filename);
            Workbook workbook = WorkbookFactory.create((InputStream)fileInputStream);
            if (this.sheetName == null || this.sheetName.length() == 0) {
                sheet = workbook.getSheetAt(0);
            } else {
                sheet = workbook.getSheet(this.sheetName);
                if (sheet == null) {
                    String string = "\u5bfe\u5fdc\u3059\u308b\u30b7\u30fc\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 Sheet=[" + this.sheetName + "]";
                    throw new HybsSystemException(string);
                }
            }
            boolean bl = true;
            this.table = DBTableModelUtil.newDBTable();
            int n = 0;
            HeaderData headerData = new HeaderData();
            headerData.setUseNumber(this.isUseNumber());
            if (headerData.setColumns(this.columns)) {
                bl = false;
                this.table.init(headerData.getColumnSize());
                this.setTableDBColumn(headerData.getNames());
            }
            int n2 = this.getSkipRowCount();
            int n3 = sheet.getFirstRowNum();
            if (n3 < n2) {
                n3 = n2;
            }
            int n4 = sheet.getLastRowNum();
            for (int i = n3; i <= n4; ++i) {
                Row row = sheet.getRow(i);
                if (headerData.isSkip(row)) continue;
                if (bl) {
                    bl = false;
                    this.table.init(headerData.getColumnSize());
                    this.setTableDBColumn(headerData.getNames());
                }
                if (n < this.getMaxRowCount()) {
                    this.table.addColumnValues(headerData.row2Array(row));
                    ++n;
                    continue;
                }
                this.table.setOverflow(true);
            }
            if (bl) {
                String string = "\u6700\u5f8c\u307e\u3067\u3001#NAME \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + "\u30d5\u30a1\u30a4\u30eb\u304c\u7a7a\u304b\u3001\u3082\u3057\u304f\u306f\u640d\u50b7\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + HybsSystem.CR;
                throw new HybsSystemException(string);
            }
        }
        catch (IOException iOException) {
            try {
                String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + this.filename + "]";
                throw new HybsSystemException(string, (Throwable)iOException);
                catch (InvalidFormatException invalidFormatException) {
                    String string2 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + this.filename + "]";
                    throw new HybsSystemException(string2, (Throwable)invalidFormatException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(fileInputStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)fileInputStream);
    }

    @Override
    public void readDBTable(BufferedReader bufferedReader) {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public void setSheetName(String string) {
        this.sheetName = string;
    }

    @Override
    public boolean isExcel() {
        return true;
    }

    @Override
    public void setFilename(String string) {
        this.filename = string;
        if (string == null) {
            String string2 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string2);
        }
    }
}

