/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterData;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.factory.AddMibInfo;

/**
 * @ejb.bean name="MibLoaderController"
 *           jndi-name="MibLoaderController"
 *           type="Stateless"
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorInfo"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=SnmpTrapMaster"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=SnmpTrapMibMaster"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 */
public abstract class MibLoaderControllerBean implements SessionBean {
	
	protected static Log m_log = LogFactory.getLog( MibLoaderControllerBean.class );
	
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="SnmptrapMonitorWrite"
	 *     method-intf="Remote"
	 * 
	 * @param mib
	 * @param traps
	 * @return true/false
	 * @throws NamingException 
	 * @throws CreateException 
	 */
	public void AddMib(SnmpTrapMibMasterData mib, List<SnmpTrapMasterData> traps) throws CreateException, NamingException {
		Principal pri = m_context.getCallerPrincipal();
		
		AddMibInfo add = new AddMibInfo();
		add.add(mib, traps, pri.getName());
	}
	
	/**
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="SnmptrapMonitorWrite"
	 *     method-intf="Remote"
	 */
	public void CheckPermission() {
	}
}
