/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.mibloader.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpNotificationType;
import net.percederberg.mibble.snmp.SnmpTrapType;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterData;

/**
 * Create SnmpTrapMasterData
 * 
 * @version 2.3.0
 * @since 2.3.0
 */
public class TrapsFactory {
	
	private TrapFactory v1Factory = new TrapV1Factory();
	private TrapFactory v2Factory = new TrapV2Factory();
	
	/**
	 * Create SnmpTrapMasterData
	 * 
	 */
	public List<SnmpTrapMasterData> create(Mib mib) {
		if(mib == null)
			return null;
		
		List<SnmpTrapMasterData> trapList = new ArrayList<SnmpTrapMasterData>();
		
		Collection list = mib.getAllSymbols();
		Iterator ite = list.iterator();
		while(ite.hasNext()){
			
			MibSymbol symbol = (MibSymbol)ite.next();
			
			if(symbol instanceof MibValueSymbol){
				
				SnmpTrapMasterData trap = null;
				
				if(symbol.getMib().getSmiVersion() == 1){
					if(((MibValueSymbol)symbol).getType() instanceof SnmpTrapType){
						trap = v1Factory.create(symbol);
					}
				}
				else if(symbol.getMib().getSmiVersion() == 2){
					if(((MibValueSymbol)symbol).getType() instanceof SnmpNotificationType){
						trap = v2Factory.create(symbol);
					}
				}
				
				if(trap instanceof SnmpTrapMasterData){
					trap.setMib(mib.getName());
					trap.setPriority(PriorityConstant.TYPE_CRITICAL);
					trapList.add(trap);
				}
			}
		}
		
		return trapList;
	}
}