/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.CompoundConstraint;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.SizeConstraint;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.type.ValueRangeConstraint;

public class NumberValue
extends MibValue {
    private Number value;

    public NumberValue(Number value) {
        super("Number");
        this.value = value;
    }

    public MibValue initialize(MibLoaderLog log, MibType type) {
        return this;
    }

    public MibValue createReference() {
        return new NumberValue(this.value);
    }

    public int compareTo(Object obj) {
        if (obj instanceof NumberValue) {
            return this.compareToNumber(((NumberValue)obj).value);
        }
        if (obj instanceof Number) {
            return this.compareToNumber((Number)obj);
        }
        return this.toString().compareTo(obj.toString());
    }

    private int compareToNumber(Number num) {
        if (this.value instanceof Integer && num instanceof Integer) {
            return ((Integer)this.value).compareTo((Integer)num);
        }
        if (this.value instanceof Long && num instanceof Long) {
            return ((Long)this.value).compareTo((Long)num);
        }
        if (this.value instanceof BigInteger && num instanceof BigInteger) {
            return ((BigInteger)this.value).compareTo((BigInteger)num);
        }
        BigDecimal num1 = new BigDecimal(this.value.toString());
        BigDecimal num2 = new BigDecimal(num.toString());
        return num1.compareTo(num2);
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object toObject() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    protected int getMinimumLength(MibType type, int byteLength) {
        Constraint c = null;
        if (type instanceof IntegerType) {
            c = ((IntegerType)type).getConstraint();
        } else if (type instanceof StringType) {
            c = ((StringType)type).getConstraint();
        }
        int minLength = this.getByteSize(c) * byteLength;
        if (minLength < 0) {
            minLength = 1;
        }
        return minLength;
    }

    private int getByteSize(Constraint c) {
        if (c instanceof CompoundConstraint) {
            ArrayList list = ((CompoundConstraint)c).getConstraintList();
            for (int i = 0; i < list.size(); ++i) {
                int size = this.getByteSize((Constraint)list.get(i));
                if (size < 0) continue;
                return size;
            }
        } else if (c instanceof SizeConstraint) {
            c = (Constraint)((SizeConstraint)c).getValues().get(0);
            MibValue value = null;
            if (c instanceof ValueConstraint) {
                value = ((ValueConstraint)c).getValue();
            } else if (c instanceof ValueRangeConstraint) {
                value = ((ValueRangeConstraint)c).getLowerBound();
            }
            if (value != null && value.toObject() instanceof Number) {
                return ((Number)value.toObject()).intValue();
            }
        }
        return -1;
    }
}

