/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.math.BigInteger;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.value.NumberValue;

public class HexNumberValue
extends NumberValue {
    private int minLength = -1;

    public HexNumberValue(Number value) {
        super(value);
    }

    public MibValue initialize(MibLoaderLog log, MibType type) {
        this.minLength = this.getMinimumLength(type, 2);
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("'");
        String value = this.toHexString();
        if (value.equals("0")) {
            value = "";
        }
        for (int i = value.length(); i < this.minLength; ++i) {
            buffer.append("0");
        }
        buffer.append(value);
        buffer.append("'H");
        return buffer.toString();
    }

    private String toHexString() {
        Number num = (Number)this.toObject();
        if (num instanceof BigInteger) {
            return ((BigInteger)num).toString(16).toUpperCase();
        }
        if (num instanceof Long) {
            return Long.toHexString(num.longValue()).toUpperCase();
        }
        return Integer.toHexString(num.intValue()).toUpperCase();
    }
}

