/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.UIManager;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.browser.BrowserFrame;
import net.percederberg.mibble.browser.MibTreeBuilder;

public class MibbleBrowser {
    private static final String COMMAND_HELP = "A graphical SNMP MIB file browser. This program comes with\nABSOLUTELY NO WARRANTY; for details see the LICENSE.txt file.\n\nSyntax: MibbleBrowser [<file(s) or URL(s)>]";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error has been found. Please report\n    this error to the maintainers (see the web site for\n    instructions). Be sure to include the version number, as\n    well as the text below:\n";
    private ArrayList loadedMibs = new ArrayList();

    public static void main(String[] args) {
        MibbleBrowser browser = new MibbleBrowser();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            MibbleBrowser.printHelp("No option '" + args[i] + "' exist");
            System.exit(1);
        }
        try {
            String str = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(str);
        }
        catch (Exception e) {
            MibbleBrowser.printInternalError(e);
        }
        BrowserFrame frame = new BrowserFrame(browser);
        frame.setVisible(true);
        if (args.length > 0) {
            frame.setBlocked(true);
            for (int i = 0; i < args.length; ++i) {
                frame.loadMib(args[i]);
            }
            frame.refreshTree();
            frame.setBlocked(false);
        }
    }

    private static void printHelp(String error) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (error != null) {
            MibbleBrowser.printError(error);
        }
    }

    private static void printInternalError(Exception e) {
        System.err.println(INTERNAL_ERROR);
        e.printStackTrace();
    }

    private static void printError(String message) {
        System.err.print("Error: ");
        System.err.println(message);
    }

    public void loadMib(String src) throws IOException, MibLoaderException {
        MibTreeBuilder mb = MibTreeBuilder.getInstance();
        Mib mib = null;
        mib = mb.loadMib(new File(src));
        for (int i = 0; i < this.loadedMibs.size(); ++i) {
            if (!mib.getName().equals(this.loadedMibs.get(i))) continue;
            return;
        }
        mb.addMib(mib);
        this.loadedMibs.add(mib.getName());
    }

    public void unloadMib(String name) {
        for (int i = 0; i < this.loadedMibs.size(); ++i) {
            if (!name.equals(this.loadedMibs.get(i))) continue;
            if (MibTreeBuilder.getInstance().unloadMib(name)) {
                this.loadedMibs.remove(i);
            }
            return;
        }
    }
}

